#include "../../lvgl.h"

/*******************************************************************************
 * Size: 16 px
 * Bpp: 4
 * Opts: --no-compress --no-prefilter --bpp 4 --size 16 --font ./Roboto-Regular.woff -r 0x20-0x7F --font FontAwesome.ttf -r 61441,61448,61451,61452,61453,61457,61459,61460,61461,61465,61468,61473,61478,61479,61480,61502,61504,61512,61515,61516,61517,61521,61522,61523,61524,61543,61544,61553,61556,61559,61560,61561,61563,61587,61589,61636,61637,61639,61671,61683,61724,61732,61787,61931,62016,62017,62018,62019,62020,62099 --format lvgl -o lv_font_roboto_16.c --force-fast-kern-format
 ******************************************************************************/

#ifndef LV_FONT_ROBOTO_16
#define LV_FONT_ROBOTO_16 1
#endif

#if LV_FONT_ROBOTO_16

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0x45, 0xad, 0xac, 0xac, 0xac, 0xac, 0x9b, 0x9b,
    0x79, 0x0, 0x35, 0x9d, 0x0,

    /* U+22 "\"" */
    0xe2, 0xc4, 0xe2, 0xd3, 0xe0, 0xd2, 0xc0, 0xb1,

    /* U+23 "#" */
    0x0, 0x0, 0x60, 0x5, 0x10, 0x0, 0x2, 0xf0,
    0xf, 0x20, 0x0, 0x5, 0xc0, 0x2f, 0x0, 0x1,
    0x29, 0xa2, 0x7c, 0x20, 0xc, 0xef, 0xfe, 0xff,
    0xe3, 0x0, 0xf, 0x20, 0xc5, 0x0, 0x0, 0x2f,
    0x0, 0xf2, 0x0, 0x14, 0x7d, 0x45, 0xf4, 0x20,
    0x5c, 0xee, 0xce, 0xfc, 0x80, 0x0, 0xb6, 0x8,
    0x90, 0x0, 0x0, 0xe3, 0xb, 0x60, 0x0, 0x1,
    0xf0, 0xe, 0x30, 0x0,

    /* U+24 "$" */
    0x0, 0x0, 0x20, 0x0, 0x0, 0x0, 0xe, 0x40,
    0x0, 0x0, 0x5, 0xf8, 0x10, 0x0, 0x1d, 0xfc,
    0xee, 0x30, 0x7, 0xf2, 0x0, 0xdb, 0x0, 0xac,
    0x0, 0x7, 0xf0, 0x8, 0xf2, 0x0, 0x2, 0x0,
    0x1e, 0xe8, 0x20, 0x0, 0x0, 0x19, 0xef, 0xa1,
    0x0, 0x0, 0x0, 0x6f, 0xb0, 0x5, 0x10, 0x0,
    0x7f, 0x0, 0xf7, 0x0, 0x6, 0xf1, 0xa, 0xe5,
    0x24, 0xec, 0x0, 0x1a, 0xff, 0xfb, 0x10, 0x0,
    0x1, 0xf2, 0x0, 0x0, 0x0, 0x9, 0x10, 0x0,

    /* U+25 "%" */
    0x0, 0x67, 0x20, 0x0, 0x0, 0x0, 0xc, 0xa8,
    0xe1, 0x0, 0x10, 0x0, 0x1f, 0x0, 0xa6, 0x3,
    0xd0, 0x0, 0x2e, 0x0, 0x97, 0xd, 0x40, 0x0,
    0xd, 0x74, 0xe3, 0x7a, 0x0, 0x0, 0x2, 0x9a,
    0x42, 0xe1, 0x0, 0x0, 0x0, 0x0, 0xb, 0x60,
    0x10, 0x0, 0x0, 0x0, 0x5c, 0x1c, 0xee, 0x40,
    0x0, 0x1, 0xe2, 0x7a, 0x4, 0xe0, 0x0, 0x9,
    0x80, 0xa7, 0x1, 0xf0, 0x0, 0x1d, 0x0, 0x8a,
    0x4, 0xe0, 0x0, 0x0, 0x0, 0x1c, 0xde, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x10, 0x0,

    /* U+26 "&" */
    0x0, 0x5, 0x75, 0x0, 0x0, 0x0, 0xbf, 0xbe,
    0xb0, 0x0, 0x2, 0xf5, 0x2, 0xf3, 0x0, 0x3,
    0xf4, 0x3, 0xf2, 0x0, 0x0, 0xeb, 0x3e, 0x90,
    0x0, 0x0, 0x4f, 0xf8, 0x0, 0x0, 0x1, 0xcf,
    0xf5, 0x0, 0x40, 0xb, 0xd1, 0x9f, 0x32, 0xf2,
    0x2f, 0x50, 0xb, 0xe8, 0xf0, 0x1f, 0x50, 0x1,
    0xdf, 0x80, 0xb, 0xd3, 0x14, 0xdf, 0xa0, 0x1,
    0xaf, 0xff, 0xa5, 0xf7, 0x0, 0x0, 0x20, 0x0,
    0x0,

    /* U+27 "'" */
    0x3f, 0x3f, 0x3e, 0x29,

    /* U+28 "(" */
    0x0, 0x8, 0x0, 0xa, 0xc0, 0x5, 0xe1, 0x0,
    0xd7, 0x0, 0x4f, 0x10, 0x9, 0xc0, 0x0, 0xca,
    0x0, 0xe, 0x80, 0x0, 0xe8, 0x0, 0xd, 0x90,
    0x0, 0xca, 0x0, 0x8, 0xd0, 0x0, 0x3f, 0x20,
    0x0, 0xc8, 0x0, 0x3, 0xf2, 0x0, 0x7, 0xd0,
    0x0, 0x5, 0x0,

    /* U+29 ")" */
    0x63, 0x0, 0x4, 0xe2, 0x0, 0x8, 0xc0, 0x0,
    0xf, 0x50, 0x0, 0xac, 0x0, 0x5, 0xf1, 0x0,
    0x3f, 0x40, 0x1, 0xf5, 0x0, 0xf, 0x60, 0x1,
    0xf5, 0x0, 0x3f, 0x40, 0x5, 0xf0, 0x0, 0xab,
    0x0, 0x1f, 0x40, 0x9, 0xb0, 0x6, 0xd1, 0x0,
    0x41, 0x0, 0x0,

    /* U+2A "*" */
    0x0, 0x6, 0x0, 0x0, 0x1, 0xf0, 0x0, 0x43,
    0x1f, 0x3, 0x28, 0xfd, 0xfd, 0xf7, 0x0, 0xbf,
    0x90, 0x0, 0x4f, 0x5f, 0x20, 0xb, 0x60, 0xa8,
    0x0, 0x0, 0x0, 0x0,

    /* U+2B "+" */
    0x0, 0x1, 0x61, 0x0, 0x0, 0x0, 0x3f, 0x30,
    0x0, 0x0, 0x3, 0xf3, 0x0, 0x0, 0x11, 0x4f,
    0x51, 0x10, 0x6f, 0xff, 0xff, 0xff, 0x61, 0x44,
    0x6f, 0x74, 0x41, 0x0, 0x3, 0xf3, 0x0, 0x0,
    0x0, 0x3f, 0x30, 0x0, 0x0, 0x3, 0xd3, 0x0,
    0x0,

    /* U+2C "," */
    0xb, 0x40, 0xf6, 0x3f, 0x39, 0xb0, 0x0, 0x0,

    /* U+2D "-" */
    0x46, 0x66, 0x8, 0xcc, 0xc1,

    /* U+2E "." */
    0x66, 0xbc, 0x0,

    /* U+2F "/" */
    0x0, 0x0, 0x16, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0xd6, 0x0, 0x0, 0x3f, 0x10, 0x0, 0x9,
    0xa0, 0x0, 0x0, 0xe4, 0x0, 0x0, 0x5d, 0x0,
    0x0, 0xc, 0x70, 0x0, 0x2, 0xf1, 0x0, 0x0,
    0x8b, 0x0, 0x0, 0xe, 0x50, 0x0, 0x4, 0xe0,
    0x0, 0x0, 0xa9, 0x0, 0x0, 0x0,

    /* U+30 "0" */
    0x0, 0x15, 0x75, 0x10, 0x0, 0x2e, 0xeb, 0xee,
    0x10, 0xa, 0xe1, 0x1, 0xe9, 0x0, 0xe8, 0x0,
    0x8, 0xe0, 0xf, 0x60, 0x0, 0x6f, 0x1, 0xf5,
    0x0, 0x5, 0xf1, 0x1f, 0x50, 0x0, 0x5f, 0x11,
    0xf5, 0x0, 0x6, 0xf0, 0xf, 0x70, 0x0, 0x7e,
    0x0, 0xda, 0x0, 0xa, 0xc0, 0x6, 0xf6, 0x15,
    0xf6, 0x0, 0x9, 0xff, 0xf9, 0x0, 0x0, 0x0,
    0x10, 0x0, 0x0,

    /* U+31 "1" */
    0x0, 0x1, 0x40, 0x4a, 0xfb, 0xaf, 0xad, 0xb3,
    0x0, 0xbb, 0x0, 0xb, 0xb0, 0x0, 0xbb, 0x0,
    0xb, 0xb0, 0x0, 0xbb, 0x0, 0xb, 0xb0, 0x0,
    0xbb, 0x0, 0xb, 0xb0, 0x0, 0xbb,

    /* U+32 "2" */
    0x0, 0x16, 0x85, 0x0, 0x0, 0x4e, 0xdb, 0xee,
    0x20, 0xe, 0xa0, 0x1, 0xea, 0x2, 0xf3, 0x0,
    0x9, 0xd0, 0x0, 0x0, 0x0, 0xba, 0x0, 0x0,
    0x0, 0x4f, 0x30, 0x0, 0x0, 0x2e, 0x90, 0x0,
    0x0, 0x1d, 0xb0, 0x0, 0x0, 0xc, 0xc0, 0x0,
    0x0, 0xb, 0xd1, 0x0, 0x0, 0xa, 0xf4, 0x33,
    0x33, 0x10, 0xff, 0xff, 0xff, 0xf6,

    /* U+33 "3" */
    0x0, 0x16, 0x75, 0x0, 0x4, 0xfd, 0xbe, 0xd1,
    0xe, 0xa0, 0x1, 0xe8, 0x9, 0x30, 0x0, 0xbb,
    0x0, 0x0, 0x0, 0xe9, 0x0, 0x6, 0x7c, 0xd1,
    0x0, 0xc, 0xdf, 0x90, 0x0, 0x0, 0x2, 0xe9,
    0x0, 0x0, 0x0, 0x9e, 0x3f, 0x40, 0x0, 0x9d,
    0xd, 0xd3, 0x15, 0xf7, 0x1, 0xbf, 0xff, 0x80,
    0x0, 0x0, 0x10, 0x0,

    /* U+34 "4" */
    0x0, 0x0, 0x3, 0x60, 0x0, 0x0, 0x1, 0xef,
    0x0, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0x0, 0x5f,
    0x8f, 0x0, 0x0, 0x1e, 0x66, 0xf0, 0x0, 0xa,
    0xc0, 0x6f, 0x0, 0x4, 0xf2, 0x6, 0xf0, 0x0,
    0xd7, 0x0, 0x6f, 0x0, 0x7f, 0xdc, 0xce, 0xfc,
    0x83, 0x55, 0x55, 0x9f, 0x53, 0x0, 0x0, 0x6,
    0xf0, 0x0, 0x0, 0x0, 0x6f, 0x0,

    /* U+35 "5" */
    0x5, 0x66, 0x66, 0x60, 0xe, 0xfe, 0xee, 0xe0,
    0xf, 0x50, 0x0, 0x0, 0x1f, 0x30, 0x0, 0x0,
    0x3f, 0x45, 0x61, 0x0, 0x4f, 0xfe, 0xff, 0x40,
    0x27, 0x10, 0x1c, 0xe0, 0x0, 0x0, 0x4, 0xf3,
    0x0, 0x0, 0x2, 0xf5, 0xab, 0x0, 0x4, 0xf3,
    0x4f, 0x61, 0x3d, 0xc0, 0x6, 0xef, 0xfc, 0x20,
    0x0, 0x1, 0x10, 0x0,

    /* U+36 "6" */
    0x0, 0x1, 0x43, 0x0, 0x0, 0x9f, 0xf8, 0x0,
    0xb, 0xe4, 0x0, 0x0, 0x4f, 0x30, 0x0, 0x0,
    0xab, 0x26, 0x61, 0x0, 0xdd, 0xfc, 0xee, 0x30,
    0xee, 0x20, 0xc, 0xd0, 0xf8, 0x0, 0x5, 0xf1,
    0xd9, 0x0, 0x3, 0xf2, 0xad, 0x0, 0x6, 0xf0,
    0x3f, 0x91, 0x4e, 0x90, 0x5, 0xef, 0xfa, 0x0,
    0x0, 0x1, 0x10, 0x0,

    /* U+37 "7" */
    0x26, 0x66, 0x66, 0x66, 0x15, 0xcc, 0xcc, 0xcd,
    0xf3, 0x0, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x0,
    0xf, 0x50, 0x0, 0x0, 0x7, 0xe0, 0x0, 0x0,
    0x0, 0xe7, 0x0, 0x0, 0x0, 0x6f, 0x10, 0x0,
    0x0, 0xd, 0x90, 0x0, 0x0, 0x5, 0xf2, 0x0,
    0x0, 0x0, 0xcb, 0x0, 0x0, 0x0, 0x4f, 0x30,
    0x0, 0x0, 0xb, 0xc0, 0x0, 0x0,

    /* U+38 "8" */
    0x0, 0x5, 0x75, 0x0, 0x0, 0x2e, 0xeb, 0xee,
    0x10, 0xa, 0xe0, 0x1, 0xe9, 0x0, 0xda, 0x0,
    0xa, 0xc0, 0xa, 0xd0, 0x0, 0xda, 0x0, 0x2e,
    0xb7, 0xbe, 0x20, 0x1, 0xbe, 0xcf, 0xb1, 0x0,
    0xbc, 0x0, 0x1d, 0xb0, 0x1f, 0x60, 0x0, 0x6f,
    0x1, 0xf7, 0x0, 0x7, 0xf0, 0xa, 0xe4, 0x14,
    0xea, 0x0, 0x1a, 0xff, 0xfa, 0x10, 0x0, 0x0,
    0x10, 0x0, 0x0,

    /* U+39 "9" */
    0x0, 0x16, 0x85, 0x0, 0x3, 0xfe, 0xbf, 0xb0,
    0xc, 0xc0, 0x4, 0xf5, 0x1f, 0x50, 0x0, 0xbb,
    0x2f, 0x30, 0x0, 0x8d, 0x1f, 0x60, 0x0, 0x9e,
    0xa, 0xe3, 0x6, 0xfe, 0x1, 0xcf, 0xfb, 0xac,
    0x0, 0x2, 0x20, 0xc9, 0x0, 0x0, 0x5, 0xf2,
    0x0, 0x24, 0x9f, 0x70, 0x0, 0x9e, 0xb5, 0x0,

    /* U+3A ":" */
    0x66, 0xbc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x66,
    0xbc, 0x0,

    /* U+3B ";" */
    0x6, 0x60, 0xbc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb4, 0xf, 0x63, 0xf3, 0x9b,
    0x0, 0x0,

    /* U+3C "<" */
    0x0, 0x0, 0x0, 0x50, 0x0, 0x7, 0xef, 0x1,
    0x8e, 0xf9, 0x25, 0xfc, 0x60, 0x0, 0x4e, 0xd7,
    0x10, 0x0, 0x6, 0xdf, 0xa3, 0x0, 0x0, 0x4c,
    0xf0, 0x0, 0x0, 0x3,

    /* U+3D "=" */
    0x8a, 0xaa, 0xaa, 0x78, 0xaa, 0xaa, 0xa7, 0x0,
    0x0, 0x0, 0x4, 0x66, 0x66, 0x64, 0xbe, 0xee,
    0xee, 0x90,

    /* U+3E ">" */
    0x50, 0x0, 0x0, 0xe, 0xe8, 0x10, 0x0, 0x16,
    0xdf, 0xa3, 0x0, 0x0, 0x3a, 0xf9, 0x0, 0x6,
    0xcf, 0x73, 0x9f, 0xe8, 0x10, 0xfd, 0x60, 0x0,
    0x3, 0x0, 0x0, 0x0,

    /* U+3F "?" */
    0x0, 0x47, 0x62, 0x0, 0xaf, 0xce, 0xf4, 0x3f,
    0x40, 0xc, 0xc1, 0x40, 0x0, 0x8e, 0x0, 0x0,
    0xc, 0xb0, 0x0, 0x9, 0xf2, 0x0, 0x7, 0xf4,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x2c, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0x10, 0x0, 0x2,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+40 "@" */
    0x0, 0x0, 0x0, 0x12, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x6d, 0xfd, 0xee, 0x80, 0x0, 0x0, 0xa,
    0xc4, 0x0, 0x2, 0xac, 0x0, 0x0, 0x9b, 0x0,
    0x0, 0x0, 0x9, 0x90, 0x2, 0xf1, 0x0, 0x5b,
    0x93, 0x0, 0xe1, 0x9, 0x90, 0x7, 0xd5, 0x8e,
    0x0, 0xa5, 0xd, 0x40, 0x1f, 0x20, 0x5c, 0x0,
    0x77, 0xf, 0x10, 0x6c, 0x0, 0x7b, 0x0, 0x78,
    0x1f, 0x0, 0xa9, 0x0, 0x89, 0x0, 0x88, 0x1f,
    0x10, 0xa8, 0x0, 0xa8, 0x0, 0xb5, 0xe, 0x30,
    0x8d, 0x4, 0xfa, 0x3, 0xe0, 0xb, 0x70, 0x1d,
    0xfc, 0x4e, 0xdd, 0x30, 0x4, 0xe1, 0x0, 0x10,
    0x0, 0x10, 0x0, 0x0, 0xac, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xea, 0x77, 0xab, 0x0,
    0x0, 0x0, 0x0, 0x15, 0x78, 0x51, 0x0, 0x0,

    /* U+41 "A" */
    0x0, 0x0, 0x36, 0x0, 0x0, 0x0, 0x0, 0xc,
    0xf3, 0x0, 0x0, 0x0, 0x2, 0xfe, 0x90, 0x0,
    0x0, 0x0, 0x8d, 0x6f, 0x0, 0x0, 0x0, 0xe,
    0x71, 0xf5, 0x0, 0x0, 0x4, 0xf2, 0xa, 0xb0,
    0x0, 0x0, 0xac, 0x0, 0x5f, 0x20, 0x0, 0x1f,
    0x83, 0x33, 0xf8, 0x0, 0x7, 0xff, 0xff, 0xff,
    0xe0, 0x0, 0xda, 0x0, 0x0, 0x3f, 0x40, 0x3f,
    0x40, 0x0, 0x0, 0xda, 0x9, 0xe0, 0x0, 0x0,
    0x7, 0xf1,

    /* U+42 "B" */
    0x46, 0x66, 0x53, 0x0, 0xa, 0xfd, 0xde, 0xfc,
    0x0, 0xad, 0x0, 0x3, 0xf8, 0xa, 0xd0, 0x0,
    0xc, 0xb0, 0xad, 0x0, 0x1, 0xe9, 0xa, 0xe8,
    0x89, 0xec, 0x10, 0xaf, 0xaa, 0xbe, 0xc2, 0xa,
    0xd0, 0x0, 0xc, 0xc0, 0xad, 0x0, 0x0, 0x7f,
    0xa, 0xd0, 0x0, 0x9, 0xe0, 0xad, 0x44, 0x48,
    0xf8, 0xa, 0xff, 0xff, 0xd7, 0x0,

    /* U+43 "C" */
    0x0, 0x1, 0x68, 0x61, 0x0, 0x0, 0x6f, 0xeb,
    0xef, 0x60, 0x3, 0xf8, 0x0, 0x9, 0xf2, 0xb,
    0xe0, 0x0, 0x0, 0xf7, 0xf, 0x90, 0x0, 0x0,
    0x32, 0xf, 0x70, 0x0, 0x0, 0x0, 0x1f, 0x70,
    0x0, 0x0, 0x0, 0xf, 0x80, 0x0, 0x0, 0x0,
    0xe, 0xa0, 0x0, 0x0, 0x85, 0x8, 0xf1, 0x0,
    0x2, 0xf6, 0x1, 0xec, 0x31, 0x4d, 0xd0, 0x0,
    0x2b, 0xff, 0xfb, 0x10, 0x0, 0x0, 0x2, 0x0,
    0x0,

    /* U+44 "D" */
    0x46, 0x66, 0x40, 0x0, 0xa, 0xfd, 0xdf, 0xf7,
    0x0, 0xad, 0x0, 0x6, 0xf7, 0xa, 0xd0, 0x0,
    0x8, 0xf1, 0xad, 0x0, 0x0, 0x2f, 0x5a, 0xd0,
    0x0, 0x0, 0xf8, 0xad, 0x0, 0x0, 0xf, 0x8a,
    0xd0, 0x0, 0x0, 0xf7, 0xad, 0x0, 0x0, 0x3f,
    0x4a, 0xd0, 0x0, 0xc, 0xd0, 0xad, 0x44, 0x6c,
    0xf3, 0xa, 0xff, 0xfe, 0x92, 0x0,

    /* U+45 "E" */
    0x46, 0x66, 0x66, 0x62, 0xaf, 0xdd, 0xdd, 0xd6,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xae, 0x77, 0x77, 0x50,
    0xaf, 0xbb, 0xbb, 0x80, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x33, 0x33, 0x32, 0xaf, 0xff, 0xff, 0xf8,

    /* U+46 "F" */
    0x46, 0x66, 0x66, 0x62, 0xaf, 0xdd, 0xdd, 0xd5,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x44, 0x44, 0x20,
    0xaf, 0xff, 0xff, 0x90, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,

    /* U+47 "G" */
    0x0, 0x1, 0x68, 0x62, 0x0, 0x0, 0x6f, 0xdb,
    0xef, 0x70, 0x4, 0xf8, 0x0, 0x8, 0xf3, 0xb,
    0xe0, 0x0, 0x0, 0xd8, 0xe, 0x90, 0x0, 0x0,
    0x0, 0xf, 0x80, 0x0, 0x0, 0x0, 0xf, 0x70,
    0x4, 0xaa, 0xa7, 0xf, 0x90, 0x3, 0x88, 0xeb,
    0xd, 0xb0, 0x0, 0x0, 0xcb, 0x7, 0xf3, 0x0,
    0x0, 0xcb, 0x0, 0xde, 0x51, 0x26, 0xf9, 0x0,
    0x19, 0xff, 0xfe, 0x80, 0x0, 0x0, 0x2, 0x10,
    0x0,

    /* U+48 "H" */
    0x44, 0x0, 0x0, 0x2, 0x60, 0xad, 0x0, 0x0,
    0x7, 0xf1, 0xad, 0x0, 0x0, 0x7, 0xf1, 0xad,
    0x0, 0x0, 0x7, 0xf1, 0xad, 0x0, 0x0, 0x7,
    0xf1, 0xae, 0x77, 0x77, 0x7b, 0xf1, 0xaf, 0xbb,
    0xbb, 0xbd, 0xf1, 0xad, 0x0, 0x0, 0x7, 0xf1,
    0xad, 0x0, 0x0, 0x7, 0xf1, 0xad, 0x0, 0x0,
    0x7, 0xf1, 0xad, 0x0, 0x0, 0x7, 0xf1, 0xad,
    0x0, 0x0, 0x7, 0xf1,

    /* U+49 "I" */
    0x35, 0x9f, 0x9f, 0x9f, 0x9f, 0x9f, 0x9f, 0x9f,
    0x9f, 0x9f, 0x9f, 0x9f,

    /* U+4A "J" */
    0x0, 0x0, 0x0, 0x53, 0x0, 0x0, 0x0, 0xe9,
    0x0, 0x0, 0x0, 0xe9, 0x0, 0x0, 0x0, 0xe9,
    0x0, 0x0, 0x0, 0xe9, 0x0, 0x0, 0x0, 0xe9,
    0x0, 0x0, 0x0, 0xe9, 0x0, 0x0, 0x0, 0xe9,
    0x12, 0x0, 0x0, 0xe9, 0x7f, 0x0, 0x1, 0xf7,
    0x3f, 0xa2, 0x2b, 0xf2, 0x5, 0xef, 0xfd, 0x40,
    0x0, 0x1, 0x10, 0x0,

    /* U+4B "K" */
    0x45, 0x0, 0x0, 0x16, 0x3a, 0xd0, 0x0, 0x1d,
    0xd1, 0xad, 0x0, 0xc, 0xe1, 0xa, 0xd0, 0xa,
    0xf3, 0x0, 0xad, 0x9, 0xf4, 0x0, 0xa, 0xd7,
    0xf7, 0x0, 0x0, 0xaf, 0xfe, 0xd0, 0x0, 0xa,
    0xf7, 0x2f, 0xa0, 0x0, 0xad, 0x0, 0x6f, 0x60,
    0xa, 0xd0, 0x0, 0xaf, 0x30, 0xad, 0x0, 0x0,
    0xdd, 0xa, 0xd0, 0x0, 0x2, 0xfa,

    /* U+4C "L" */
    0x44, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x33, 0x33, 0x30, 0xaf, 0xff, 0xff, 0xf3,

    /* U+4D "M" */
    0x46, 0x20, 0x0, 0x0, 0x2, 0x64, 0xaf, 0x90,
    0x0, 0x0, 0xa, 0xfa, 0xaf, 0xf0, 0x0, 0x0,
    0x1f, 0xfa, 0xac, 0xf6, 0x0, 0x0, 0x7f, 0xca,
    0xab, 0xad, 0x0, 0x0, 0xd9, 0xca, 0xac, 0x3f,
    0x30, 0x4, 0xf3, 0xca, 0xac, 0xd, 0x90, 0xa,
    0xc0, 0xda, 0xad, 0x6, 0xf0, 0x1f, 0x50, 0xda,
    0xad, 0x0, 0xf6, 0x7e, 0x0, 0xda, 0xad, 0x0,
    0x9d, 0xd8, 0x0, 0xda, 0xad, 0x0, 0x3f, 0xf2,
    0x0, 0xda, 0xad, 0x0, 0xc, 0xb0, 0x0, 0xda,

    /* U+4E "N" */
    0x45, 0x0, 0x0, 0x2, 0x60, 0xaf, 0x60, 0x0,
    0x6, 0xf1, 0xaf, 0xf1, 0x0, 0x6, 0xf1, 0xae,
    0xeb, 0x0, 0x6, 0xf1, 0xad, 0x5f, 0x50, 0x6,
    0xf1, 0xad, 0xa, 0xe1, 0x6, 0xf1, 0xad, 0x1,
    0xea, 0x6, 0xf1, 0xad, 0x0, 0x6f, 0x56, 0xf1,
    0xad, 0x0, 0xb, 0xe7, 0xf1, 0xad, 0x0, 0x1,
    0xff, 0xf1, 0xad, 0x0, 0x0, 0x6f, 0xf1, 0xad,
    0x0, 0x0, 0xc, 0xf1,

    /* U+4F "O" */
    0x0, 0x1, 0x68, 0x61, 0x0, 0x0, 0x5, 0xff,
    0xcf, 0xf6, 0x0, 0x3, 0xf9, 0x0, 0x9, 0xf3,
    0x0, 0xae, 0x0, 0x0, 0xe, 0xa0, 0xe, 0x90,
    0x0, 0x0, 0x9e, 0x0, 0xf7, 0x0, 0x0, 0x7,
    0xf0, 0x1f, 0x60, 0x0, 0x0, 0x6f, 0x10, 0xf8,
    0x0, 0x0, 0x8, 0xf0, 0xd, 0xb0, 0x0, 0x0,
    0xad, 0x0, 0x8f, 0x20, 0x0, 0x1f, 0x80, 0x0,
    0xdd, 0x52, 0x4d, 0xe1, 0x0, 0x1, 0xaf, 0xff,
    0xb1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0,

    /* U+50 "P" */
    0x46, 0x66, 0x53, 0x0, 0xa, 0xfd, 0xde, 0xfe,
    0x50, 0xad, 0x0, 0x1, 0xbf, 0x2a, 0xd0, 0x0,
    0x1, 0xf6, 0xad, 0x0, 0x0, 0x1f, 0x6a, 0xd0,
    0x0, 0x8, 0xf3, 0xaf, 0xaa, 0xbd, 0xf8, 0xa,
    0xe8, 0x88, 0x62, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xa, 0xd0, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0,
    0x0, 0xa, 0xd0, 0x0, 0x0, 0x0,

    /* U+51 "Q" */
    0x0, 0x1, 0x68, 0x61, 0x0, 0x0, 0x6, 0xff,
    0xce, 0xf5, 0x0, 0x4, 0xf8, 0x0, 0x9, 0xf2,
    0x0, 0xbd, 0x0, 0x0, 0xe, 0x90, 0xf, 0x80,
    0x0, 0x0, 0xad, 0x1, 0xf6, 0x0, 0x0, 0x8,
    0xf0, 0x2f, 0x50, 0x0, 0x0, 0x7f, 0x1, 0xf7,
    0x0, 0x0, 0x9, 0xf0, 0xe, 0xa0, 0x0, 0x0,
    0xbc, 0x0, 0x9f, 0x10, 0x0, 0x2f, 0x70, 0x1,
    0xed, 0x52, 0x5d, 0xd0, 0x0, 0x2, 0xbf, 0xff,
    0xf5, 0x0, 0x0, 0x0, 0x2, 0x1b, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x8, 0x70,

    /* U+52 "R" */
    0x46, 0x66, 0x53, 0x0, 0xa, 0xfd, 0xde, 0xfc,
    0x20, 0xad, 0x0, 0x3, 0xeb, 0xa, 0xd0, 0x0,
    0x8, 0xf0, 0xad, 0x0, 0x0, 0x8f, 0xa, 0xd0,
    0x0, 0x3e, 0xb0, 0xaf, 0xcc, 0xef, 0xb1, 0xa,
    0xe6, 0x69, 0xf2, 0x0, 0xad, 0x0, 0xd, 0xb0,
    0xa, 0xd0, 0x0, 0x5f, 0x40, 0xad, 0x0, 0x0,
    0xcc, 0xa, 0xd0, 0x0, 0x4, 0xf5,

    /* U+53 "S" */
    0x0, 0x5, 0x77, 0x30, 0x0, 0x2d, 0xfc, 0xcf,
    0xa0, 0xb, 0xd1, 0x0, 0x3f, 0x70, 0xf8, 0x0,
    0x0, 0xab, 0xc, 0xd1, 0x0, 0x0, 0x0, 0x3e,
    0xf9, 0x40, 0x0, 0x0, 0x17, 0xdf, 0xe5, 0x0,
    0x0, 0x0, 0x3a, 0xf5, 0x14, 0x0, 0x0, 0xc,
    0xc3, 0xf5, 0x0, 0x0, 0xbd, 0xb, 0xe5, 0x22,
    0x7f, 0x70, 0x8, 0xef, 0xfe, 0x70, 0x0, 0x0,
    0x11, 0x0, 0x0,

    /* U+54 "T" */
    0x36, 0x66, 0x66, 0x66, 0x61, 0x8d, 0xdd, 0xfe,
    0xdd, 0xd2, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0,

    /* U+55 "U" */
    0x53, 0x0, 0x0, 0x16, 0x2e, 0x90, 0x0, 0x2,
    0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90, 0x0,
    0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90,
    0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e,
    0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x3f,
    0x4b, 0xd0, 0x0, 0x6, 0xf2, 0x4f, 0xa2, 0x25,
    0xea, 0x0, 0x5d, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x10, 0x0, 0x0,

    /* U+56 "V" */
    0x45, 0x0, 0x0, 0x0, 0x45, 0x7f, 0x20, 0x0,
    0x0, 0xea, 0x1f, 0x80, 0x0, 0x4, 0xf4, 0xb,
    0xd0, 0x0, 0xa, 0xe0, 0x5, 0xf3, 0x0, 0xf,
    0x80, 0x0, 0xe8, 0x0, 0x5f, 0x20, 0x0, 0x9e,
    0x0, 0xbc, 0x0, 0x0, 0x3f, 0x31, 0xf6, 0x0,
    0x0, 0xd, 0x96, 0xf1, 0x0, 0x0, 0x7, 0xeb,
    0xb0, 0x0, 0x0, 0x1, 0xff, 0x50, 0x0, 0x0,
    0x0, 0xbe, 0x0, 0x0,

    /* U+57 "W" */
    0x36, 0x0, 0x0, 0x35, 0x0, 0x0, 0x45, 0x4f,
    0x20, 0x0, 0xaf, 0x10, 0x0, 0xda, 0x1f, 0x60,
    0x0, 0xff, 0x50, 0x1, 0xf6, 0xd, 0xa0, 0x4,
    0xfb, 0xa0, 0x4, 0xf2, 0x9, 0xe0, 0x8, 0xc6,
    0xe0, 0x8, 0xe0, 0x5, 0xf1, 0xd, 0x71, 0xf2,
    0xc, 0xa0, 0x1, 0xf5, 0x1f, 0x30, 0xd7, 0xf,
    0x60, 0x0, 0xd9, 0x6e, 0x0, 0x8b, 0x3f, 0x20,
    0x0, 0x9c, 0xa9, 0x0, 0x4f, 0x7e, 0x0, 0x0,
    0x5f, 0xe5, 0x0, 0xf, 0xdb, 0x0, 0x0, 0x2f,
    0xf0, 0x0, 0xb, 0xf7, 0x0, 0x0, 0xe, 0xb0,
    0x0, 0x6, 0xf3, 0x0,

    /* U+58 "X" */
    0x26, 0x20, 0x0, 0x2, 0x62, 0xd, 0xd0, 0x0,
    0xc, 0xe1, 0x4, 0xf7, 0x0, 0x6f, 0x50, 0x0,
    0xaf, 0x21, 0xeb, 0x0, 0x0, 0x1e, 0xba, 0xf1,
    0x0, 0x0, 0x5, 0xff, 0x60, 0x0, 0x0, 0x1,
    0xff, 0x20, 0x0, 0x0, 0xa, 0xfe, 0xb0, 0x0,
    0x0, 0x4f, 0x66, 0xf5, 0x0, 0x0, 0xec, 0x0,
    0xbe, 0x10, 0x9, 0xf3, 0x0, 0x2f, 0xa0, 0x3f,
    0x80, 0x0, 0x7, 0xf4,

    /* U+59 "Y" */
    0x45, 0x0, 0x0, 0x2, 0x62, 0x6f, 0x40, 0x0,
    0xb, 0xe1, 0xd, 0xd0, 0x0, 0x3f, 0x60, 0x4,
    0xf5, 0x0, 0xbd, 0x0, 0x0, 0xbd, 0x3, 0xf5,
    0x0, 0x0, 0x3f, 0x5c, 0xc0, 0x0, 0x0, 0xa,
    0xff, 0x30, 0x0, 0x0, 0x1, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0,

    /* U+5A "Z" */
    0x16, 0x66, 0x66, 0x66, 0x43, 0xdd, 0xdd, 0xde,
    0xfa, 0x0, 0x0, 0x0, 0x8f, 0x30, 0x0, 0x0,
    0x3f, 0x70, 0x0, 0x0, 0xd, 0xc0, 0x0, 0x0,
    0x9, 0xf2, 0x0, 0x0, 0x4, 0xf6, 0x0, 0x0,
    0x1, 0xeb, 0x0, 0x0, 0x0, 0xae, 0x10, 0x0,
    0x0, 0x6f, 0x50, 0x0, 0x0, 0x1f, 0xc4, 0x44,
    0x44, 0x45, 0xff, 0xff, 0xff, 0xff,

    /* U+5B "[" */
    0xdf, 0xf1, 0xda, 0x30, 0xd9, 0x0, 0xd9, 0x0,
    0xd9, 0x0, 0xd9, 0x0, 0xd9, 0x0, 0xd9, 0x0,
    0xd9, 0x0, 0xd9, 0x0, 0xd9, 0x0, 0xd9, 0x0,
    0xd9, 0x0, 0xd9, 0x0, 0xde, 0xc1, 0x67, 0x70,

    /* U+5C "\\" */
    0x34, 0x0, 0x0, 0x5, 0xf1, 0x0, 0x0, 0xe,
    0x60, 0x0, 0x0, 0x9c, 0x0, 0x0, 0x3, 0xf2,
    0x0, 0x0, 0xc, 0x80, 0x0, 0x0, 0x6e, 0x0,
    0x0, 0x1, 0xf5, 0x0, 0x0, 0xa, 0xb0, 0x0,
    0x0, 0x4f, 0x10, 0x0, 0x0, 0xe7, 0x0, 0x0,
    0x8, 0xd0, 0x0, 0x0, 0x2f, 0x40,

    /* U+5D "]" */
    0xef, 0xf0, 0x28, 0xf0, 0x6, 0xf0, 0x6, 0xf0,
    0x6, 0xf0, 0x6, 0xf0, 0x6, 0xf0, 0x6, 0xf0,
    0x6, 0xf0, 0x6, 0xf0, 0x6, 0xf0, 0x6, 0xf0,
    0x6, 0xf0, 0x6, 0xf0, 0xbd, 0xf0, 0x67, 0x70,

    /* U+5E "^" */
    0x0, 0x15, 0x0, 0x0, 0x8, 0xf3, 0x0, 0x0,
    0xee, 0x90, 0x0, 0x5e, 0x5f, 0x0, 0xc, 0x80,
    0xe6, 0x2, 0xf2, 0x7, 0xd0, 0x13, 0x0, 0x14,
    0x0,

    /* U+5F "_" */
    0xff, 0xff, 0xff, 0xf3, 0x22, 0x22, 0x22, 0x20,

    /* U+60 "`" */
    0x2e, 0x80, 0x4, 0xf3, 0x0, 0x33,

    /* U+61 "a" */
    0x0, 0x27, 0x97, 0x0, 0x5, 0xfb, 0x9e, 0xd1,
    0xb, 0x90, 0x1, 0xf6, 0x0, 0x0, 0x12, 0xe8,
    0x2, 0xaf, 0xed, 0xf8, 0xd, 0xb1, 0x0, 0xe8,
    0x1f, 0x50, 0x0, 0xe8, 0xe, 0xc3, 0x3b, 0xf8,
    0x4, 0xef, 0xf9, 0xdb, 0x0, 0x1, 0x0, 0x0,

    /* U+62 "b" */
    0xe8, 0x0, 0x0, 0x0, 0xe8, 0x0, 0x0, 0x0,
    0xe8, 0x0, 0x0, 0x0, 0xe8, 0x38, 0x83, 0x0,
    0xed, 0xda, 0xdf, 0x40, 0xec, 0x0, 0xc, 0xd0,
    0xe8, 0x0, 0x5, 0xf1, 0xe8, 0x0, 0x3, 0xf3,
    0xe8, 0x0, 0x4, 0xf2, 0xe9, 0x0, 0x7, 0xf0,
    0xef, 0x61, 0x5f, 0x90, 0xe9, 0xcf, 0xfb, 0x0,
    0x0, 0x1, 0x10, 0x0,

    /* U+63 "c" */
    0x0, 0x17, 0x96, 0x0, 0x3, 0xfc, 0x9d, 0xe1,
    0xc, 0xb0, 0x0, 0xd9, 0x1f, 0x50, 0x0, 0x45,
    0x4f, 0x30, 0x0, 0x0, 0x3f, 0x30, 0x0, 0x0,
    0xf, 0x70, 0x0, 0x67, 0x8, 0xf4, 0x15, 0xf6,
    0x0, 0x9f, 0xff, 0x70, 0x0, 0x0, 0x10, 0x0,

    /* U+64 "d" */
    0x0, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x0, 0x8d,
    0x0, 0x0, 0x0, 0x8d, 0x0, 0x28, 0x84, 0x8d,
    0x4, 0xfd, 0xad, 0xed, 0xc, 0xc0, 0x0, 0xcd,
    0x1f, 0x50, 0x0, 0x8d, 0x3f, 0x30, 0x0, 0x8d,
    0x2f, 0x40, 0x0, 0x8d, 0xf, 0x80, 0x0, 0x9d,
    0x8, 0xf5, 0x15, 0xfd, 0x0, 0xaf, 0xfc, 0x9d,
    0x0, 0x1, 0x10, 0x0,

    /* U+65 "e" */
    0x0, 0x16, 0x97, 0x10, 0x2, 0xed, 0xae, 0xd1,
    0xc, 0xc0, 0x1, 0xe8, 0x1f, 0x50, 0x0, 0x9c,
    0x3f, 0xff, 0xff, 0xfe, 0x3f, 0x63, 0x33, 0x32,
    0xf, 0x80, 0x0, 0x0, 0x9, 0xf6, 0x12, 0xc8,
    0x0, 0x8f, 0xff, 0xa1, 0x0, 0x0, 0x20, 0x0,

    /* U+66 "f" */
    0x0, 0x0, 0x20, 0x0, 0x5e, 0xf8, 0x0, 0xea,
    0x10, 0x2, 0xf4, 0x0, 0x39, 0xf9, 0x70, 0x5b,
    0xfb, 0xa0, 0x3, 0xf4, 0x0, 0x3, 0xf4, 0x0,
    0x3, 0xf4, 0x0, 0x3, 0xf4, 0x0, 0x3, 0xf4,
    0x0, 0x3, 0xf4, 0x0, 0x3, 0xf4, 0x0,

    /* U+67 "g" */
    0x0, 0x28, 0x94, 0x36, 0x4, 0xfd, 0xad, 0xde,
    0xc, 0xc0, 0x0, 0xce, 0x1f, 0x60, 0x0, 0x8e,
    0x3f, 0x30, 0x0, 0x8e, 0x2f, 0x40, 0x0, 0x8e,
    0xf, 0x80, 0x0, 0x9e, 0x8, 0xf5, 0x15, 0xfe,
    0x0, 0xaf, 0xfc, 0xbe, 0x0, 0x1, 0x10, 0xac,
    0x7, 0x70, 0x3, 0xf7, 0x3, 0xef, 0xef, 0xa0,
    0x0, 0x3, 0x42, 0x0,

    /* U+68 "h" */
    0xe8, 0x0, 0x0, 0xe, 0x80, 0x0, 0x0, 0xe8,
    0x0, 0x0, 0xe, 0x83, 0x88, 0x30, 0xed, 0xda,
    0xdf, 0x3e, 0xd0, 0x0, 0xe9, 0xe8, 0x0, 0xb,
    0xbe, 0x80, 0x0, 0xbb, 0xe8, 0x0, 0xb, 0xbe,
    0x80, 0x0, 0xbb, 0xe8, 0x0, 0xb, 0xbe, 0x80,
    0x0, 0xbb,

    /* U+69 "i" */
    0x54, 0xcb, 0x0, 0x55, 0xca, 0xca, 0xca, 0xca,
    0xca, 0xca, 0xca, 0xca,

    /* U+6A "j" */
    0x0, 0x63, 0x0, 0xe9, 0x0, 0x0, 0x0, 0x64,
    0x0, 0xd9, 0x0, 0xd9, 0x0, 0xd9, 0x0, 0xd9,
    0x0, 0xd9, 0x0, 0xd9, 0x0, 0xd9, 0x0, 0xd9,
    0x0, 0xd9, 0x0, 0xe8, 0x6e, 0xf3, 0x25, 0x20,

    /* U+6B "k" */
    0xe8, 0x0, 0x0, 0x0, 0xe8, 0x0, 0x0, 0x0,
    0xe8, 0x0, 0x0, 0x0, 0xe8, 0x0, 0x17, 0x30,
    0xe8, 0x1, 0xdc, 0x0, 0xe8, 0xc, 0xd1, 0x0,
    0xe9, 0xcd, 0x10, 0x0, 0xef, 0xfb, 0x0, 0x0,
    0xee, 0x6f, 0x70, 0x0, 0xe8, 0x7, 0xf4, 0x0,
    0xe8, 0x0, 0xbe, 0x10, 0xe8, 0x0, 0x1e, 0xb0,

    /* U+6C "l" */
    0xca, 0xca, 0xca, 0xca, 0xca, 0xca, 0xca, 0xca,
    0xca, 0xca, 0xca, 0xca,

    /* U+6D "m" */
    0x63, 0x38, 0x83, 0x3, 0x88, 0x40, 0xed, 0xda,
    0xdf, 0x9e, 0xac, 0xf6, 0xeb, 0x0, 0xe, 0xf2,
    0x0, 0xbc, 0xe8, 0x0, 0xb, 0xc0, 0x0, 0x8e,
    0xe8, 0x0, 0xb, 0xb0, 0x0, 0x8e, 0xe8, 0x0,
    0xb, 0xb0, 0x0, 0x8e, 0xe8, 0x0, 0xb, 0xb0,
    0x0, 0x8e, 0xe8, 0x0, 0xb, 0xb0, 0x0, 0x8e,
    0xe8, 0x0, 0xb, 0xb0, 0x0, 0x8e,

    /* U+6E "n" */
    0x63, 0x38, 0x83, 0xe, 0xde, 0xad, 0xf3, 0xed,
    0x0, 0xe, 0x9e, 0x80, 0x0, 0xbb, 0xe8, 0x0,
    0xb, 0xbe, 0x80, 0x0, 0xbb, 0xe8, 0x0, 0xb,
    0xbe, 0x80, 0x0, 0xbb, 0xe8, 0x0, 0xb, 0xb0,

    /* U+6F "o" */
    0x0, 0x17, 0x97, 0x10, 0x0, 0x2e, 0xda, 0xdf,
    0x40, 0xc, 0xc0, 0x0, 0xbe, 0x1, 0xf5, 0x0,
    0x3, 0xf3, 0x3f, 0x30, 0x0, 0x1f, 0x52, 0xf4,
    0x0, 0x1, 0xf4, 0xf, 0x80, 0x0, 0x6f, 0x20,
    0x8f, 0x51, 0x4e, 0xa0, 0x0, 0x8f, 0xff, 0x90,
    0x0, 0x0, 0x2, 0x0, 0x0,

    /* U+70 "p" */
    0x63, 0x49, 0x83, 0x0, 0xed, 0xda, 0xef, 0x40,
    0xec, 0x0, 0xc, 0xd0, 0xe8, 0x0, 0x6, 0xf1,
    0xe8, 0x0, 0x3, 0xf3, 0xe8, 0x0, 0x4, 0xf2,
    0xe8, 0x0, 0x8, 0xf0, 0xee, 0x41, 0x5f, 0x90,
    0xeb, 0xcf, 0xfb, 0x0, 0xe8, 0x1, 0x10, 0x0,
    0xe8, 0x0, 0x0, 0x0, 0xe8, 0x0, 0x0, 0x0,
    0x32, 0x0, 0x0, 0x0,

    /* U+71 "q" */
    0x0, 0x28, 0x84, 0x36, 0x4, 0xfd, 0x9d, 0xed,
    0xc, 0xc0, 0x0, 0xcd, 0x1f, 0x50, 0x0, 0x9d,
    0x3f, 0x30, 0x0, 0x9d, 0x2f, 0x40, 0x0, 0x9d,
    0xf, 0x80, 0x0, 0x9d, 0x9, 0xf5, 0x15, 0xfd,
    0x0, 0xbf, 0xfd, 0xbd, 0x0, 0x1, 0x10, 0x9d,
    0x0, 0x0, 0x0, 0x9d, 0x0, 0x0, 0x0, 0x9d,
    0x0, 0x0, 0x0, 0x23,

    /* U+72 "r" */
    0x63, 0x59, 0x1e, 0xdf, 0xc2, 0xed, 0x10, 0xe,
    0x80, 0x0, 0xe8, 0x0, 0xe, 0x80, 0x0, 0xe8,
    0x0, 0xe, 0x80, 0x0, 0xe8, 0x0, 0x0,

    /* U+73 "s" */
    0x0, 0x38, 0x85, 0x0, 0x6, 0xfb, 0xaf, 0xc0,
    0xe, 0x90, 0x3, 0xf4, 0xc, 0xc2, 0x0, 0x0,
    0x2, 0xcf, 0xd8, 0x10, 0x0, 0x2, 0x6d, 0xe2,
    0x19, 0x20, 0x1, 0xf6, 0xe, 0xb2, 0x16, 0xf3,
    0x2, 0xcf, 0xfe, 0x60, 0x0, 0x0, 0x10, 0x0,

    /* U+74 "t" */
    0x2, 0x70, 0x0, 0x6f, 0x10, 0x6a, 0xf8, 0x49,
    0xcf, 0xa6, 0x6, 0xf1, 0x0, 0x6f, 0x10, 0x6,
    0xf1, 0x0, 0x6f, 0x10, 0x6, 0xf1, 0x0, 0x4f,
    0x41, 0x0, 0xcf, 0xa0, 0x0, 0x10,

    /* U+75 "u" */
    0x73, 0x0, 0x5, 0x5e, 0x80, 0x0, 0xbb, 0xe8,
    0x0, 0xb, 0xbe, 0x80, 0x0, 0xbb, 0xe8, 0x0,
    0xb, 0xbe, 0x80, 0x0, 0xbb, 0xd9, 0x0, 0xb,
    0xba, 0xe3, 0x27, 0xfb, 0x2d, 0xff, 0xbc, 0xb0,
    0x1, 0x10, 0x0,

    /* U+76 "v" */
    0x46, 0x0, 0x0, 0x72, 0x6f, 0x10, 0x5, 0xf2,
    0xf, 0x60, 0xa, 0xb0, 0xa, 0xb0, 0xf, 0x60,
    0x4, 0xf1, 0x4f, 0x10, 0x0, 0xe6, 0x9a, 0x0,
    0x0, 0x9b, 0xe5, 0x0, 0x0, 0x3f, 0xe0, 0x0,
    0x0, 0xd, 0x90, 0x0,

    /* U+77 "w" */
    0x46, 0x0, 0x4, 0x40, 0x0, 0x64, 0x6f, 0x0,
    0xe, 0xe0, 0x0, 0xf6, 0x1f, 0x40, 0x3f, 0xf2,
    0x4, 0xf1, 0xc, 0x80, 0x8a, 0xb7, 0x8, 0xc0,
    0x8, 0xd0, 0xd5, 0x6c, 0xc, 0x80, 0x3, 0xf3,
    0xf1, 0x1f, 0x2f, 0x30, 0x0, 0xec, 0xb0, 0xc,
    0xbe, 0x0, 0x0, 0xaf, 0x60, 0x7, 0xf9, 0x0,
    0x0, 0x5f, 0x20, 0x2, 0xf5, 0x0,

    /* U+78 "x" */
    0x37, 0x10, 0x2, 0x72, 0xe, 0xa0, 0xb, 0xd0,
    0x4, 0xf4, 0x6f, 0x30, 0x0, 0xad, 0xe8, 0x0,
    0x0, 0x1f, 0xe0, 0x0, 0x0, 0x5f, 0xf4, 0x0,
    0x1, 0xe8, 0xad, 0x0, 0xa, 0xe0, 0x1e, 0x90,
    0x5f, 0x40, 0x6, 0xf4,

    /* U+79 "y" */
    0x56, 0x0, 0x1, 0x72, 0x7f, 0x10, 0x7, 0xf1,
    0x1f, 0x60, 0xc, 0xb0, 0xc, 0xb0, 0x1f, 0x50,
    0x6, 0xf1, 0x6f, 0x0, 0x1, 0xf6, 0xba, 0x0,
    0x0, 0xac, 0xf4, 0x0, 0x0, 0x5f, 0xe0, 0x0,
    0x0, 0xe, 0x90, 0x0, 0x0, 0x1f, 0x40, 0x0,
    0x0, 0x8d, 0x0, 0x0, 0x4e, 0xf4, 0x0, 0x0,
    0x15, 0x20, 0x0, 0x0,

    /* U+7A "z" */
    0x17, 0x77, 0x77, 0x71, 0x2b, 0xbb, 0xbe, 0xf1,
    0x0, 0x0, 0x3f, 0x70, 0x0, 0x1, 0xeb, 0x0,
    0x0, 0xb, 0xe1, 0x0, 0x0, 0x7f, 0x30, 0x0,
    0x3, 0xf7, 0x0, 0x0, 0x1e, 0xc3, 0x33, 0x31,
    0x5f, 0xff, 0xff, 0xf6,

    /* U+7B "{" */
    0x0, 0x0, 0x40, 0x0, 0xb, 0xd1, 0x0, 0x7e,
    0x10, 0x0, 0xca, 0x0, 0x0, 0xd9, 0x0, 0x0,
    0xd9, 0x0, 0x0, 0xf8, 0x0, 0x3b, 0xe2, 0x0,
    0x6f, 0xb0, 0x0, 0x2, 0xf6, 0x0, 0x0, 0xd9,
    0x0, 0x0, 0xd9, 0x0, 0x0, 0xca, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x2f, 0x80, 0x0, 0x2, 0xa1,

    /* U+7C "|" */
    0x33, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8,
    0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0x10,

    /* U+7D "}" */
    0x31, 0x0, 0x8, 0xf3, 0x0, 0x9, 0xe0, 0x0,
    0x4f, 0x20, 0x3, 0xf3, 0x0, 0x3f, 0x30, 0x1,
    0xf5, 0x0, 0x9, 0xe6, 0x0, 0x4f, 0xb0, 0xf,
    0x80, 0x2, 0xf4, 0x0, 0x3f, 0x30, 0x3, 0xf3,
    0x0, 0x6f, 0x0, 0x3e, 0x80, 0x8, 0x60, 0x0,

    /* U+7E "~" */
    0x0, 0x31, 0x0, 0x0, 0x3, 0xef, 0xf7, 0x0,
    0x6c, 0xca, 0x6, 0xfb, 0x7e, 0x78, 0x30, 0x3,
    0xbc, 0x70,

    /* U+F001 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x73, 0x0,
    0x0, 0x0, 0x0, 0x49, 0xef, 0xfb, 0x0, 0x0,
    0x5, 0xaf, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x5f,
    0xff, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x6f, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0x0, 0x6f, 0xff, 0xff,
    0xc7, 0x8b, 0x0, 0x0, 0x6f, 0xfb, 0x61, 0x0,
    0x6b, 0x0, 0x0, 0x6c, 0x0, 0x0, 0x0, 0x6b,
    0x0, 0x0, 0x6b, 0x0, 0x0, 0x0, 0x6b, 0x0,
    0x0, 0x6b, 0x0, 0x2, 0x65, 0x8b, 0x0, 0x0,
    0x6b, 0x0, 0x9f, 0xff, 0xfb, 0x0, 0x11, 0x6b,
    0x0, 0xef, 0xff, 0xfa, 0x5e, 0xff, 0xeb, 0x0,
    0x3c, 0xfe, 0xa1, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0xff, 0xe4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x33, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F008 "" */
    0x39, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x40, 0xeb, 0x9e, 0xe9, 0x99, 0x99, 0x99, 0xdf,
    0x9a, 0xf1, 0xf2, 0x9, 0x90, 0x0, 0x0, 0x0,
    0x6b, 0x0, 0xf2, 0xf5, 0x2b, 0x90, 0x0, 0x0,
    0x0, 0x6d, 0x23, 0xf2, 0xff, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0xf2, 0xf3, 0xa, 0x90,
    0x0, 0x0, 0x0, 0x6c, 0x1, 0xf2, 0xf2, 0x9,
    0x90, 0x0, 0x0, 0x0, 0x7b, 0x0, 0xf2, 0xfd,
    0xbf, 0xfb, 0xbb, 0xbb, 0xbb, 0xef, 0xbc, 0xf2,
    0xf9, 0x6d, 0xd6, 0x66, 0x66, 0x66, 0xce, 0x68,
    0xf2, 0xf2, 0x9, 0x90, 0x0, 0x0, 0x0, 0x6b,
    0x0, 0xf2, 0xf7, 0x4c, 0x90, 0x0, 0x0, 0x0,
    0x6d, 0x45, 0xf2, 0xfe, 0xdf, 0x90, 0x0, 0x0,
    0x0, 0x6f, 0xee, 0xf2, 0xf2, 0x9, 0x90, 0x0,
    0x0, 0x0, 0x6c, 0x0, 0xf2, 0xf2, 0x9, 0x90,
    0x0, 0x0, 0x0, 0x7c, 0x0, 0xf2, 0xce, 0xdf,
    0xfd, 0xdd, 0xdd, 0xdd, 0xff, 0xee, 0xe0, 0x4,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x10,

    /* U+F00B "" */
    0x69, 0x99, 0x20, 0x89, 0x99, 0x99, 0x99, 0x96,
    0xff, 0xff, 0x84, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x94, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xad, 0xdd, 0x41, 0xcd, 0xdd, 0xdd, 0xdd, 0xda,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xff, 0x62, 0xef, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0x94, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x83, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x36, 0x66, 0x10, 0x56, 0x66, 0x66, 0x66, 0x63,
    0x36, 0x66, 0x10, 0x56, 0x66, 0x66, 0x66, 0x63,
    0xff, 0xff, 0x83, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x94, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xcf, 0xff, 0x62, 0xef, 0xff, 0xff, 0xff, 0xfc,

    /* U+F00C "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xfc, 0x2, 0x50, 0x0,
    0x0, 0xbf, 0xff, 0xe3, 0x3f, 0xf8, 0x0, 0xb,
    0xff, 0xfe, 0x30, 0xdf, 0xff, 0x80, 0xbf, 0xff,
    0xe3, 0x0, 0x5f, 0xff, 0xfd, 0xff, 0xfe, 0x30,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xe3, 0x0, 0x0,
    0x0, 0x5f, 0xff, 0xfe, 0x30, 0x0, 0x0, 0x0,
    0x5, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5c, 0x20, 0x0, 0x0, 0x0,

    /* U+F00D "" */
    0x3, 0x30, 0x0, 0x0, 0x50, 0x4, 0xff, 0x50,
    0x0, 0xbf, 0xc0, 0xef, 0xff, 0x50, 0xcf, 0xff,
    0x77, 0xff, 0xff, 0xdf, 0xff, 0xe2, 0x7, 0xff,
    0xff, 0xff, 0xe2, 0x0, 0x8, 0xff, 0xff, 0xe2,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0x50, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0x50, 0xbf, 0xff, 0xe9, 0xff,
    0xff, 0x4d, 0xff, 0xe2, 0x8, 0xff, 0xf6, 0x1d,
    0xe2, 0x0, 0x7, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F011 "" */
    0x0, 0x0, 0x0, 0x96, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0x0, 0x0, 0x0, 0x0, 0x15,
    0x4, 0xff, 0x2, 0x50, 0x0, 0x2, 0xdf, 0x74,
    0xff, 0xc, 0xfa, 0x0, 0xc, 0xff, 0x34, 0xff,
    0x7, 0xff, 0x80, 0x6f, 0xf4, 0x4, 0xff, 0x0,
    0x9f, 0xf1, 0xbf, 0xa0, 0x4, 0xff, 0x0, 0xe,
    0xf7, 0xef, 0x60, 0x2, 0xfe, 0x0, 0xa, 0xfa,
    0xff, 0x40, 0x0, 0x21, 0x0, 0x9, 0xfa, 0xdf,
    0x70, 0x0, 0x0, 0x0, 0xc, 0xf9, 0x9f, 0xd0,
    0x0, 0x0, 0x0, 0x3f, 0xf4, 0x2f, 0xfa, 0x0,
    0x0, 0x1, 0xdf, 0xd0, 0x8, 0xff, 0xc5, 0x23,
    0x7e, 0xff, 0x30, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xf4, 0x0, 0x0, 0x3, 0xaf, 0xff, 0xe9, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x11, 0x0, 0x0, 0x0,

    /* U+F013 "" */
    0x0, 0x0, 0x4, 0x99, 0x10, 0x0, 0x0, 0x0,
    0x12, 0x9, 0xff, 0x40, 0x30, 0x0, 0x2, 0xee,
    0x7e, 0xff, 0xb9, 0xfa, 0x0, 0xa, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x50, 0x1, 0xef, 0xff, 0xff,
    0xff, 0xfb, 0x0, 0x13, 0xff, 0xf8, 0x12, 0xbf,
    0xfc, 0x20, 0xff, 0xff, 0xc0, 0x0, 0x1f, 0xff,
    0xfb, 0xff, 0xff, 0xa0, 0x0, 0xe, 0xff, 0xfb,
    0x9c, 0xff, 0xe1, 0x0, 0x4f, 0xff, 0xc6, 0x0,
    0xdf, 0xfd, 0x79, 0xff, 0xf9, 0x0, 0x5, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x20, 0x7, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x40, 0x0, 0x8a, 0x1b, 0xff,
    0x72, 0xc5, 0x0, 0x0, 0x0, 0x8, 0xff, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x22, 0x0, 0x0,
    0x0,

    /* U+F014 "" */
    0x0, 0x0, 0x79, 0x99, 0x30, 0x0, 0x0, 0x0,
    0x6d, 0x99, 0xaf, 0x10, 0x0, 0x34, 0x4d, 0x94,
    0x44, 0xe8, 0x44, 0x2d, 0xfe, 0xdd, 0xdd, 0xdd,
    0xdf, 0xe7, 0xd, 0x40, 0x0, 0x0, 0x0, 0xb6,
    0x0, 0xd4, 0x33, 0x15, 0x6, 0xb, 0x60, 0xd,
    0x49, 0x94, 0xd0, 0xf2, 0xb6, 0x0, 0xd4, 0x99,
    0x4d, 0xf, 0x2b, 0x60, 0xd, 0x49, 0x94, 0xd0,
    0xf2, 0xb6, 0x0, 0xd4, 0x99, 0x4d, 0xf, 0x2b,
    0x60, 0xd, 0x49, 0x94, 0xd0, 0xf2, 0xb6, 0x0,
    0xd4, 0x22, 0x3, 0x3, 0xb, 0x60, 0xd, 0x50,
    0x0, 0x0, 0x0, 0xc6, 0x0, 0x7f, 0xff, 0xff,
    0xff, 0xfe, 0x10, 0x0, 0x12, 0x22, 0x22, 0x22,
    0x0, 0x0,

    /* U+F015 "" */
    0x0, 0x0, 0x0, 0x15, 0x0, 0x46, 0x30, 0x0,
    0x0, 0x0, 0x3e, 0xfd, 0x2b, 0xf9, 0x0, 0x0,
    0x0, 0x5f, 0xc5, 0xee, 0xdf, 0x90, 0x0, 0x0,
    0x7f, 0xa6, 0xe5, 0xcf, 0xf9, 0x0, 0x0, 0xaf,
    0x88, 0xff, 0xf7, 0xaf, 0xb0, 0x1, 0xcf, 0x6b,
    0xff, 0xff, 0xf9, 0x7f, 0xb1, 0x9e, 0x5d, 0xff,
    0xff, 0xff, 0xfc, 0x6f, 0x70, 0x1b, 0xff, 0xff,
    0xff, 0xff, 0xf9, 0x20, 0x0, 0xbf, 0xff, 0xb9,
    0xcf, 0xff, 0x90, 0x0, 0xb, 0xff, 0xf4, 0x6,
    0xff, 0xf9, 0x0, 0x0, 0xbf, 0xff, 0x40, 0x6f,
    0xff, 0x90, 0x0, 0x9, 0xff, 0xf4, 0x6, 0xff,
    0xf7, 0x0,

    /* U+F019 "" */
    0x0, 0x0, 0x2, 0xbb, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xff, 0x20, 0x0, 0x0, 0x0, 0x1,
    0x26, 0xff, 0xf4, 0x21, 0x0, 0x0, 0x1, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x4, 0xff,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x4, 0xff,
    0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff,
    0xf3, 0x0, 0x0, 0x6, 0x99, 0x99, 0x25, 0xe3,
    0x49, 0x99, 0x94, 0xff, 0xff, 0xfe, 0x30, 0x4f,
    0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xef, 0xfe,
    0xff, 0xed, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8b,
    0xb8, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfa,

    /* U+F01C "" */
    0x0, 0x26, 0x66, 0x66, 0x66, 0x60, 0x0, 0x0,
    0xdf, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x4, 0xfa,
    0x44, 0x44, 0x44, 0xee, 0x0, 0xb, 0xf2, 0x0,
    0x0, 0x0, 0x7f, 0x60, 0x2f, 0xb0, 0x0, 0x0,
    0x0, 0x1f, 0xd0, 0x8f, 0x50, 0x0, 0x0, 0x0,
    0x9, 0xf4, 0xde, 0x22, 0x10, 0x0, 0x1, 0x25,
    0xf9, 0xff, 0xff, 0xd0, 0x0, 0x2f, 0xff, 0xfb,
    0xff, 0xff, 0xf9, 0x66, 0xbf, 0xff, 0xfb, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf9,

    /* U+F021 "" */
    0x0, 0x0, 0x27, 0x88, 0x50, 0x0, 0x0, 0x0,
    0x1b, 0xff, 0xff, 0xff, 0x70, 0x99, 0x2, 0xef,
    0xfe, 0xcc, 0xff, 0xfe, 0xfb, 0xd, 0xff, 0x60,
    0x0, 0x19, 0xff, 0xfb, 0x6f, 0xf4, 0x0, 0x0,
    0x9, 0xff, 0xfb, 0xbf, 0xa0, 0x0, 0x0, 0x4f,
    0xff, 0xfa, 0x12, 0x0, 0x0, 0x0, 0x2, 0x22,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x79, 0x99, 0x80, 0x0, 0x0, 0x7, 0x94, 0xff,
    0xff, 0xc0, 0x0, 0x0, 0x3f, 0xf4, 0xff, 0xff,
    0x10, 0x0, 0x1, 0xdf, 0xc0, 0xff, 0xff, 0xd5,
    0x23, 0x7e, 0xff, 0x30, 0xfc, 0x8f, 0xff, 0xff,
    0xff, 0xf4, 0x0, 0x71, 0x3, 0xbf, 0xff, 0xe9,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x11, 0x0, 0x0,
    0x0,

    /* U+F026 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9d, 0x0,
    0x0, 0x9f, 0xd0, 0x0, 0x9f, 0xfd, 0xef, 0xff,
    0xff, 0xdf, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff,
    0xdf, 0xff, 0xff, 0xfd, 0x79, 0x9f, 0xff, 0xd0,
    0x0, 0x3e, 0xfd, 0x0, 0x0, 0x3e, 0xd0, 0x0,
    0x0, 0x38,

    /* U+F027 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9d, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xd0, 0x0,
    0x0, 0x0, 0x9f, 0xfd, 0x0, 0x0, 0xef, 0xff,
    0xff, 0xd0, 0xa6, 0xf, 0xff, 0xff, 0xfd, 0x4,
    0xf1, 0xff, 0xff, 0xff, 0xd0, 0xe, 0x3f, 0xff,
    0xff, 0xfd, 0xa, 0xd0, 0x79, 0x9f, 0xff, 0xd0,
    0x41, 0x0, 0x0, 0x3e, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x3e, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x38,
    0x0, 0x0,

    /* U+F028 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0x80, 0x0, 0x0,
    0x0, 0x9, 0xd0, 0x0, 0x2c, 0xc0, 0x0, 0x0,
    0x9, 0xfd, 0x0, 0xd7, 0xb, 0xa0, 0x0, 0x9,
    0xff, 0xd0, 0x3, 0xd9, 0x1f, 0x3e, 0xff, 0xff,
    0xfd, 0xa, 0x62, 0xf2, 0x99, 0xff, 0xff, 0xff,
    0xd0, 0x4f, 0x1b, 0x76, 0xbf, 0xff, 0xff, 0xfd,
    0x0, 0xe3, 0x98, 0x5d, 0xff, 0xff, 0xff, 0xd0,
    0xad, 0xd, 0x57, 0xa7, 0x99, 0xff, 0xfd, 0x4,
    0x17, 0xe0, 0xc7, 0x0, 0x3, 0xff, 0xd0, 0xa,
    0xf3, 0x5e, 0x0, 0x0, 0x3, 0xfd, 0x0, 0x61,
    0x4f, 0x50, 0x0, 0x0, 0x3, 0x80, 0x0, 0x9f,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x20,
    0x0,

    /* U+F03E "" */
    0x39, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x40, 0xea, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x99, 0xf1, 0xf2, 0x2, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf2, 0xf2, 0x6f, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf2, 0xf2, 0xaf, 0xfa, 0x0,
    0x0, 0x47, 0x0, 0x0, 0xf2, 0xf2, 0x4f, 0xf4,
    0x0, 0x4, 0xff, 0x80, 0x0, 0xf2, 0xf2, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xf8, 0x0, 0xf2, 0xf2,
    0x0, 0x25, 0x4, 0xff, 0xff, 0xff, 0x70, 0xf2,
    0xf2, 0x2, 0xef, 0x8f, 0xff, 0xff, 0xff, 0xd0,
    0xf2, 0xf2, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xd0, 0xf2, 0xf2, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd0, 0xf2, 0xf2, 0x9d, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xb0, 0xf2, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf2, 0xaf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x1, 0x22,
    0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x0,

    /* U+F040 "" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2e, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xa0, 0x0, 0x0, 0x0,
    0x2b, 0x2d, 0xff, 0xf6, 0x0, 0x0, 0x2, 0xec,
    0xd2, 0xdf, 0xf4, 0x0, 0x0, 0x2e, 0xbc, 0xfd,
    0x2d, 0x50, 0x0, 0x2, 0xea, 0xcf, 0xff, 0xd0,
    0x0, 0x0, 0x2e, 0xbc, 0xff, 0xff, 0x50, 0x0,
    0x2, 0xeb, 0xcf, 0xff, 0xf5, 0x0, 0x0, 0x2e,
    0xdc, 0xff, 0xff, 0x50, 0x0, 0x0, 0xe8, 0xaf,
    0xff, 0xf5, 0x0, 0x0, 0x0, 0xf4, 0xa, 0xff,
    0x50, 0x0, 0x0, 0x0, 0xff, 0x44, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x22, 0x21, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F048 "" */
    0x79, 0x10, 0x0, 0x0, 0x31, 0xff, 0x40, 0x0,
    0x3, 0xf2, 0xff, 0x40, 0x0, 0x3f, 0xf2, 0xff,
    0x40, 0x3, 0xff, 0xf2, 0xff, 0x40, 0x3f, 0xff,
    0xf2, 0xff, 0x43, 0xff, 0xff, 0xf2, 0xff, 0x8f,
    0xff, 0xff, 0xf2, 0xff, 0xef, 0xff, 0xff, 0xf2,
    0xff, 0x5b, 0xff, 0xff, 0xf2, 0xff, 0x40, 0xbf,
    0xff, 0xf2, 0xff, 0x40, 0xb, 0xff, 0xf2, 0xff,
    0x40, 0x0, 0xbf, 0xf2, 0xff, 0x40, 0x0, 0xb,
    0xf2, 0xff, 0x30, 0x0, 0x0, 0xc2, 0x11, 0x0,
    0x0, 0x0, 0x0,

    /* U+F04B "" */
    0x71, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xfe, 0x60,
    0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xc3, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xfb, 0x20, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0x91, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xa1, 0xf, 0xff, 0xff, 0xff, 0xfb, 0x20,
    0x0, 0xff, 0xff, 0xff, 0xd4, 0x0, 0x0, 0xf,
    0xff, 0xfe, 0x60, 0x0, 0x0, 0x0, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x91, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F04C "" */
    0x79, 0x99, 0x95, 0x0, 0x79, 0x99, 0x95, 0xff,
    0xff, 0xfb, 0x0, 0xff, 0xff, 0xfb, 0xff, 0xff,
    0xfb, 0x0, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xfb,
    0x0, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xfb, 0x0,
    0xff, 0xff, 0xfb, 0xff, 0xff, 0xfb, 0x0, 0xff,
    0xff, 0xfb, 0xff, 0xff, 0xfb, 0x0, 0xff, 0xff,
    0xfb, 0xff, 0xff, 0xfb, 0x0, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xfb, 0x0, 0xff, 0xff, 0xfb, 0xff,
    0xff, 0xfb, 0x0, 0xff, 0xff, 0xfb, 0xff, 0xff,
    0xfb, 0x0, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xfb,
    0x0, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xfb, 0x0,
    0xff, 0xff, 0xfb, 0xff, 0xff, 0xfa, 0x0, 0xff,
    0xff, 0xfa, 0x12, 0x22, 0x20, 0x0, 0x12, 0x22,
    0x20,

    /* U+F04D "" */
    0x79, 0x99, 0x99, 0x99, 0x99, 0x99, 0x95, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x20,

    /* U+F051 "" */
    0x40, 0x0, 0x0, 0x8, 0x80, 0xf5, 0x0, 0x0,
    0x2f, 0xf2, 0xff, 0x50, 0x0, 0x2f, 0xf2, 0xff,
    0xf5, 0x0, 0x2f, 0xf2, 0xff, 0xff, 0x50, 0x2f,
    0xf2, 0xff, 0xff, 0xf5, 0x2f, 0xf2, 0xff, 0xff,
    0xff, 0x7f, 0xf2, 0xff, 0xff, 0xff, 0xef, 0xf2,
    0xff, 0xff, 0xfd, 0x3f, 0xf2, 0xff, 0xff, 0xd1,
    0x2f, 0xf2, 0xff, 0xfd, 0x10, 0x2f, 0xf2, 0xff,
    0xd1, 0x0, 0x2f, 0xf2, 0xfd, 0x10, 0x0, 0x2f,
    0xf2, 0xd1, 0x0, 0x0, 0x1f, 0xf1, 0x0, 0x0,
    0x0, 0x1, 0x10,

    /* U+F052 "" */
    0x0, 0x0, 0x0, 0x42, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x5, 0xff,
    0xff, 0xfe, 0x20, 0x0, 0x0, 0x5f, 0xff, 0xff,
    0xff, 0xe2, 0x0, 0x5, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x20, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe2, 0x56, 0x66, 0x66, 0x66, 0x66, 0x66, 0x64,
    0x56, 0x66, 0x66, 0x66, 0x66, 0x66, 0x63, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf9,

    /* U+F053 "" */
    0x0, 0x0, 0x0, 0x5, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0xc0, 0x0, 0x0, 0xa, 0xff, 0xf8, 0x0,
    0x0, 0xaf, 0xff, 0xd1, 0x0, 0xa, 0xff, 0xfd,
    0x10, 0x0, 0xaf, 0xff, 0xd1, 0x0, 0xa, 0xff,
    0xfd, 0x10, 0x0, 0x7f, 0xff, 0xe1, 0x0, 0x0,
    0x2e, 0xff, 0xf8, 0x0, 0x0, 0x2, 0xef, 0xff,
    0x80, 0x0, 0x0, 0x2e, 0xff, 0xf8, 0x0, 0x0,
    0x2, 0xef, 0xff, 0x80, 0x0, 0x0, 0x2e, 0xff,
    0xf6, 0x0, 0x0, 0x2, 0xef, 0xf3, 0x0, 0x0,
    0x0, 0x2c, 0x40,

    /* U+F054 "" */
    0x0, 0x42, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xe2,
    0x0, 0x0, 0x0, 0x1f, 0xff, 0xe2, 0x0, 0x0,
    0x0, 0x7f, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x7f,
    0xff, 0xe2, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xe2,
    0x0, 0x0, 0x0, 0x7f, 0xff, 0xe2, 0x0, 0x0,
    0x0, 0x9f, 0xff, 0xe0, 0x0, 0x0, 0x2e, 0xff,
    0xf7, 0x0, 0x0, 0x2e, 0xff, 0xf7, 0x0, 0x0,
    0x2e, 0xff, 0xf7, 0x0, 0x0, 0x2e, 0xff, 0xf7,
    0x0, 0x0, 0x1e, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0xbf, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xa7, 0x0,
    0x0, 0x0, 0x0,

    /* U+F067 "" */
    0x0, 0x0, 0x18, 0x96, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x36, 0x66, 0xaf, 0xff,
    0x66, 0x66, 0x10, 0x0, 0x6, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xfc, 0x0, 0x0, 0x0,

    /* U+F068 "" */
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x83, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x61,

    /* U+F071 "" */
    0x0, 0x0, 0x0, 0x8, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xff, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xfd, 0xdf, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xb0, 0xb, 0xf8, 0x0, 0x0,
    0x0, 0x1, 0xff, 0xc0, 0xc, 0xff, 0x10, 0x0,
    0x0, 0x9, 0xff, 0xc0, 0xc, 0xff, 0x90, 0x0,
    0x0, 0x2f, 0xff, 0xd0, 0xd, 0xff, 0xf2, 0x0,
    0x0, 0xbf, 0xff, 0xf9, 0x9f, 0xff, 0xfb, 0x0,
    0x3, 0xff, 0xff, 0xf9, 0x9f, 0xff, 0xff, 0x30,
    0xc, 0xff, 0xff, 0xd0, 0xd, 0xff, 0xff, 0xc0,
    0x5f, 0xff, 0xff, 0xe2, 0x2e, 0xff, 0xff, 0xf5,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0x2, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20,

    /* U+F074 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x21, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0x10,
    0x66, 0x63, 0x0, 0x0, 0x15, 0x66, 0xaf, 0xd1,
    0xff, 0xff, 0xc1, 0x5, 0xff, 0xff, 0xff, 0xfc,
    0xdd, 0xef, 0xfc, 0x4f, 0xff, 0xdd, 0xef, 0xf5,
    0x0, 0x4, 0xf8, 0xef, 0xc1, 0x0, 0x6f, 0x50,
    0x0, 0x0, 0x77, 0xff, 0x20, 0x0, 0x55, 0x0,
    0x0, 0x0, 0xd, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xf5, 0x0, 0x0, 0x21, 0x0,
    0x0, 0x0, 0xdf, 0xbb, 0x70, 0x0, 0x6d, 0x10,
    0x66, 0x7d, 0xff, 0x5f, 0xf9, 0x66, 0xaf, 0xd1,
    0xff, 0xff, 0xf6, 0xc, 0xff, 0xff, 0xff, 0xfc,
    0xdd, 0xda, 0x30, 0x0, 0x7c, 0xdd, 0xef, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x55, 0x0,

    /* U+F077 "" */
    0x0, 0x0, 0x0, 0x2, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xff, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xf3, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0,
    0x0, 0x3f, 0xff, 0xf6, 0x6f, 0xff, 0xf3, 0x0,
    0x3, 0xff, 0xff, 0x60, 0x6, 0xff, 0xff, 0x30,
    0x1f, 0xff, 0xf6, 0x0, 0x0, 0x6f, 0xff, 0xf1,
    0xa, 0xff, 0x60, 0x0, 0x0, 0x6, 0xff, 0xa0,
    0x0, 0x96, 0x0, 0x0, 0x0, 0x0, 0x69, 0x0,

    /* U+F078 "" */
    0x0, 0xb8, 0x0, 0x0, 0x0, 0x0, 0x8b, 0x0,
    0xc, 0xff, 0x80, 0x0, 0x0, 0x8, 0xff, 0xc0,
    0x1e, 0xff, 0xf8, 0x0, 0x0, 0x8f, 0xff, 0xe1,
    0x2, 0xdf, 0xff, 0x80, 0x8, 0xff, 0xfe, 0x20,
    0x0, 0x2e, 0xff, 0xf8, 0x8f, 0xff, 0xe2, 0x0,
    0x0, 0x1, 0xdf, 0xff, 0xff, 0xfe, 0x20, 0x0,
    0x0, 0x0, 0x1d, 0xff, 0xff, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xdf, 0xfe, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1d, 0xe2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x10, 0x0, 0x0, 0x0,

    /* U+F079 "" */
    0x0, 0x2, 0x0, 0x44, 0x44, 0x44, 0x44, 0x30,
    0x0, 0x0, 0x7f, 0x51, 0xdf, 0xff, 0xff, 0xff,
    0xd0, 0x0, 0x5, 0xff, 0xf3, 0x2f, 0xff, 0xff,
    0xff, 0xd0, 0x0, 0x3f, 0xff, 0xfe, 0x10, 0x0,
    0x0, 0x6f, 0xd0, 0x0, 0xdf, 0xff, 0xff, 0xb0,
    0x0, 0x0, 0x6f, 0xd0, 0x0, 0x34, 0xcf, 0xb4,
    0x20, 0x0, 0x0, 0x6f, 0xd0, 0x0, 0x0, 0xbf,
    0x90, 0x0, 0x0, 0x59, 0xcf, 0xf9, 0x80, 0x0,
    0xbf, 0x90, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xd0,
    0x0, 0xbf, 0xb4, 0x44, 0x44, 0xa, 0xff, 0xfe,
    0x20, 0x0, 0xbf, 0xff, 0xff, 0xff, 0x80, 0xcf,
    0xf4, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xf3,
    0x1d, 0x60, 0x0,

    /* U+F07B "" */
    0x7, 0x99, 0x96, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xff, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xe4, 0x44, 0x44, 0x42, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfb, 0x4e, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x30,

    /* U+F093 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x1, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x4,
    0xff, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0x20, 0x0, 0x0, 0x36, 0x66, 0x51, 0x99, 0x80,
    0x56, 0x66, 0x3f, 0xff, 0xff, 0x84, 0x44, 0x9f,
    0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xbb,
    0x6d, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xb0, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20,

    /* U+F095 "" */
    0x4, 0x80, 0x0, 0x0, 0x0, 0x0, 0x5, 0xff,
    0x80, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0x10,
    0x0, 0x0, 0x0, 0xf, 0xff, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xf5, 0x0,
    0x7, 0x10, 0x0, 0x1, 0xdf, 0xf9, 0x19, 0xff,
    0x80, 0x0, 0x1, 0xcf, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x8f, 0xff, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x17, 0xdf, 0xc5, 0x0,

    /* U+F0C4 "" */
    0x2, 0x64, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xff, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x20,
    0xea, 0x2, 0xaf, 0x50, 0x0, 0x0, 0x59, 0x69,
    0xea, 0x0, 0xb, 0xc0, 0x0, 0x4a, 0x40, 0x67,
    0x6f, 0xa4, 0x3d, 0xd0, 0x29, 0x60, 0x9, 0x40,
    0x6, 0xef, 0xff, 0x7d, 0x80, 0x2, 0xa2, 0x0,
    0x0, 0x2, 0x32, 0xa7, 0x90, 0x49, 0x0, 0x0,
    0x0, 0x37, 0x87, 0x92, 0x67, 0x7a, 0x30, 0x0,
    0xa, 0xff, 0xef, 0xa9, 0xd7, 0x0, 0x86, 0x0,
    0x9f, 0x60, 0xb, 0xc0, 0x6, 0x92, 0x5, 0x80,
    0xe8, 0x0, 0xd, 0xb0, 0x0, 0x7, 0x81, 0x2a,
    0xdc, 0x56, 0xdf, 0x30, 0x0, 0x0, 0x19, 0xa6,
    0x3d, 0xff, 0xb2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F0C5 "" */
    0x0, 0x0, 0x4a, 0xbb, 0xba, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xfd, 0x66, 0x6e, 0x40, 0x0, 0x0,
    0x0, 0x5f, 0xbb, 0x0, 0xd, 0x40, 0x0, 0x0,
    0x5, 0xf4, 0x6b, 0x0, 0xd, 0x54, 0x44, 0x42,
    0x5f, 0x62, 0x7b, 0x0, 0xd, 0xfe, 0xdd, 0xee,
    0xef, 0xff, 0xf8, 0x0, 0x4f, 0xe6, 0x0, 0x2f,
    0xf2, 0x0, 0x0, 0x3, 0xf6, 0xb6, 0x0, 0x2f,
    0xf2, 0x0, 0x0, 0x3f, 0x60, 0xb6, 0x0, 0x2f,
    0xf2, 0x0, 0x0, 0xee, 0xbb, 0xe6, 0x0, 0x2f,
    0xf2, 0x0, 0x4, 0xe6, 0x66, 0x50, 0x0, 0x2f,
    0xf2, 0x0, 0x4, 0xd0, 0x0, 0x0, 0x0, 0x2f,
    0xf5, 0x44, 0x47, 0xd0, 0x0, 0x0, 0x0, 0x2f,
    0xad, 0xdd, 0xde, 0xd0, 0x0, 0x0, 0x0, 0x2f,
    0x0, 0x0, 0x4, 0xd0, 0x0, 0x0, 0x0, 0x2f,
    0x0, 0x0, 0x4, 0xd0, 0x0, 0x0, 0x0, 0x2f,
    0x0, 0x0, 0x3, 0xfd, 0xdd, 0xdd, 0xdd, 0xee,
    0x0, 0x0, 0x0, 0x34, 0x44, 0x44, 0x44, 0x42,

    /* U+F0C7 "" */
    0x69, 0x99, 0x99, 0x99, 0x97, 0x10, 0x0, 0xfa,
    0xef, 0xfe, 0x99, 0xfc, 0xe2, 0x0, 0xf2, 0xbf,
    0xfb, 0x0, 0xf2, 0x8e, 0x20, 0xf2, 0xbf, 0xfb,
    0x0, 0xf2, 0x8, 0xe2, 0xf2, 0xbf, 0xfb, 0x0,
    0xf2, 0x0, 0xa9, 0xf2, 0x9f, 0xff, 0xff, 0xf1,
    0x0, 0x6b, 0xf2, 0x2, 0x22, 0x22, 0x10, 0x0,
    0x6b, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6b,
    0xf2, 0x39, 0x99, 0x99, 0x99, 0x81, 0x6b, 0xf2,
    0xbc, 0x99, 0x99, 0x99, 0xe6, 0x6b, 0xf2, 0xb6,
    0x0, 0x0, 0x0, 0xb6, 0x6b, 0xf2, 0xb6, 0x0,
    0x0, 0x0, 0xb6, 0x6b, 0xf2, 0xb6, 0x0, 0x0,
    0x0, 0xb6, 0x6b, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0x2, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x20,

    /* U+F0E7 "" */
    0x1, 0x99, 0x94, 0x0, 0x6, 0xff, 0xf4, 0x0,
    0xa, 0xff, 0xe0, 0x0, 0xe, 0xff, 0x80, 0x0,
    0x1f, 0xff, 0x34, 0x8a, 0x5f, 0xff, 0xff, 0xf9,
    0x9f, 0xff, 0xff, 0xf2, 0xdf, 0xfc, 0xff, 0xa0,
    0x74, 0x1, 0xff, 0x30, 0x0, 0x5, 0xfb, 0x0,
    0x0, 0x9, 0xf4, 0x0, 0x0, 0xc, 0xc0, 0x0,
    0x0, 0xf, 0x50, 0x0, 0x0, 0x4d, 0x0, 0x0,
    0x0, 0x86, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0,

    /* U+F0F3 "" */
    0x0, 0x0, 0x0, 0x6, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4e, 0xe4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2d, 0xff, 0xff, 0xd2, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xff, 0xff, 0xfe, 0x0, 0x0,
    0x0, 0x6, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0,
    0x0, 0x9, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0,
    0x0, 0xa, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0,
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,
    0x2e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2,
    0x3e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2,
    0x0, 0x0, 0x2, 0xbf, 0xff, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9b, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x20, 0x0, 0x0, 0x0,

    /* U+F11C "" */
    0x14, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x20, 0xee, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xdd, 0xf1, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf2, 0xf2, 0xb6, 0x6b, 0x2f, 0xd,
    0x49, 0x94, 0xd0, 0xf2, 0xf2, 0x10, 0x1, 0x2,
    0x1, 0x1, 0x14, 0xd0, 0xf2, 0xf2, 0x8b, 0x63,
    0x90, 0xb1, 0x84, 0x4c, 0xd0, 0xf2, 0xf2, 0x46,
    0x31, 0x50, 0x60, 0x42, 0x26, 0x50, 0xf2, 0xf2,
    0x42, 0x26, 0x66, 0x66, 0x66, 0x31, 0x50, 0xf2,
    0xf2, 0x84, 0x4b, 0xbb, 0xbb, 0xbb, 0x63, 0x90,
    0xf2, 0xf4, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22, 0xf2, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xc0,

    /* U+F124 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x3b, 0xf7, 0x0, 0x0, 0x0,
    0x3, 0xbf, 0xfe, 0x0, 0x0, 0x0, 0x3b, 0xff,
    0xff, 0x70, 0x0, 0x3, 0xbf, 0xff, 0xff, 0xe0,
    0x0, 0x3b, 0xff, 0xff, 0xff, 0xf7, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0xfe, 0x0, 0x5, 0x66, 0x66,
    0x9f, 0xff, 0x70, 0x0, 0x0, 0x0, 0x4, 0xff,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x0, 0x0, 0x0,

    /* U+F15B "" */
    0x8b, 0xbb, 0xbb, 0xbb, 0x1, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xc, 0x20, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xd, 0xe2, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xd, 0xfe, 0x20, 0xff, 0xff, 0xff, 0xff,
    0xb, 0xdd, 0xc1, 0xff, 0xff, 0xff, 0xff, 0x30,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,

    /* U+F1EB "" */
    0x0, 0x0, 0x0, 0x46, 0x88, 0x75, 0x10, 0x0,
    0x0, 0x0, 0x3, 0xaf, 0xff, 0xff, 0xff, 0xfc,
    0x50, 0x0, 0x1, 0xaf, 0xff, 0xfd, 0xcc, 0xdf,
    0xff, 0xfd, 0x30, 0x2d, 0xff, 0xd6, 0x10, 0x11,
    0x0, 0x5b, 0xff, 0xf5, 0x4f, 0xf7, 0x5, 0xbf,
    0xff, 0xfc, 0x71, 0x4e, 0xf9, 0x4, 0x33, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0x61, 0x60, 0x0, 0xf,
    0xff, 0xb6, 0x32, 0x49, 0xff, 0xf4, 0x0, 0x0,
    0x5, 0xd3, 0x17, 0xab, 0x82, 0x2c, 0x90, 0x0,
    0x0, 0x0, 0x5, 0xff, 0xff, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xff, 0xba, 0xef, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x31, 0x23, 0x4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x59, 0x0, 0x0, 0x0, 0x0,

    /* U+F240 "" */
    0x16, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x40, 0xd, 0xcb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbf, 0x40, 0xf2, 0x12, 0x22,
    0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0xb6, 0xf,
    0x2b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x2b, 0xb1, 0xf2, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf2, 0x6d, 0x8f, 0x2b, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x99, 0xf2,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x9, 0x9f, 0x2b, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x20, 0x99, 0xf2, 0xbf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf2, 0xbf, 0x6f, 0x28,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x1b,
    0x70, 0xf4, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x22, 0xc6, 0x8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x10,

    /* U+F241 "" */
    0x16, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x40, 0xd, 0xcb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbf, 0x40, 0xf2, 0x12, 0x22,
    0x22, 0x22, 0x22, 0x21, 0x0, 0x0, 0xb6, 0xf,
    0x2b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0xb, 0xb1, 0xf2, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0, 0x0, 0x6d, 0x8f, 0x2b, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x99, 0xf2,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x9, 0x9f, 0x2b, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xb0, 0x0, 0x0, 0x99, 0xf2, 0xbf, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0x0, 0xbf, 0x6f, 0x28,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x80, 0x0, 0xb,
    0x70, 0xf4, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x22, 0xc6, 0x8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x10,

    /* U+F242 "" */
    0x16, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x40, 0xd, 0xcb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbf, 0x40, 0xf2, 0x12, 0x22,
    0x22, 0x22, 0x0, 0x0, 0x0, 0x0, 0xb6, 0xf,
    0x2b, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0,
    0xb, 0xb1, 0xf2, 0xbf, 0xff, 0xff, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x6d, 0x8f, 0x2b, 0xff, 0xff,
    0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x99, 0xf2,
    0xbf, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0, 0x0,
    0x9, 0x9f, 0x2b, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x99, 0xf2, 0xbf, 0xff, 0xff,
    0xff, 0x40, 0x0, 0x0, 0x0, 0xbf, 0x6f, 0x28,
    0xbb, 0xbb, 0xbb, 0xb3, 0x0, 0x0, 0x0, 0xb,
    0x70, 0xf4, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x22, 0xc6, 0x8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x10,

    /* U+F243 "" */
    0x16, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x40, 0xd, 0xcb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbf, 0x40, 0xf2, 0x12, 0x22,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb6, 0xf,
    0x2b, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xb1, 0xf2, 0xbf, 0xff, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6d, 0x8f, 0x2b, 0xff, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x99, 0xf2,
    0xbf, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9, 0x9f, 0x2b, 0xff, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x99, 0xf2, 0xbf, 0xff, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x6f, 0x28,
    0xbb, 0xba, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb,
    0x70, 0xf4, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x22, 0xc6, 0x8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x10,

    /* U+F244 "" */
    0x16, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x40, 0xd, 0xcb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbf, 0x40, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb6, 0xf,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xb1, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6d, 0x8f, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x99, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9, 0x9f, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x99, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x6f, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb,
    0x70, 0xf4, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x22, 0xc6, 0x8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x10,

    /* U+F293 "" */
    0x0, 0x0, 0x59, 0xaa, 0x83, 0x0, 0x0, 0x1,
    0xdf, 0xfd, 0xff, 0xfa, 0x0, 0x0, 0xcf, 0xff,
    0x58, 0xff, 0xf8, 0x0, 0x4f, 0xff, 0xf5, 0x8,
    0xff, 0xf1, 0x9, 0xff, 0xef, 0x54, 0x8, 0xff,
    0x50, 0xdf, 0x72, 0xe5, 0x79, 0xc, 0xf8, 0xf,
    0xff, 0x52, 0x35, 0x17, 0xff, 0xa0, 0xff, 0xff,
    0x50, 0x7, 0xff, 0xfb, 0xf, 0xff, 0xfc, 0x1,
    0xef, 0xff, 0xc0, 0xff, 0xfc, 0x10, 0x2, 0xef,
    0xfb, 0xe, 0xfc, 0x17, 0x57, 0x52, 0xef, 0x90,
    0xcf, 0x97, 0xf5, 0x75, 0x2d, 0xf7, 0x8, 0xff,
    0xff, 0x50, 0x2d, 0xff, 0x30, 0x2f, 0xff, 0xf5,
    0x2d, 0xff, 0xd0, 0x0, 0x7f, 0xff, 0x7d, 0xff,
    0xf3, 0x0, 0x0, 0x6e, 0xff, 0xff, 0xc3, 0x0,
    0x0, 0x0, 0x2, 0x33, 0x10, 0x0, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_h = 0, .box_w = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 63, .box_h = 0, .box_w = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 66, .box_h = 13, .box_w = 2, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 13, .adv_w = 82, .box_h = 4, .box_w = 4, .ofs_x = 1, .ofs_y = 8},
    {.bitmap_index = 21, .adv_w = 159, .box_h = 12, .box_w = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 81, .adv_w = 144, .box_h = 16, .box_w = 9, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 153, .adv_w = 188, .box_h = 13, .box_w = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 231, .adv_w = 159, .box_h = 13, .box_w = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 296, .adv_w = 45, .box_h = 4, .box_w = 2, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 300, .adv_w = 88, .box_h = 17, .box_w = 5, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 343, .adv_w = 89, .box_h = 17, .box_w = 5, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 386, .adv_w = 110, .box_h = 8, .box_w = 7, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 414, .adv_w = 145, .box_h = 9, .box_w = 9, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 455, .adv_w = 50, .box_h = 5, .box_w = 3, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 463, .adv_w = 71, .box_h = 2, .box_w = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 468, .adv_w = 67, .box_h = 3, .box_w = 2, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 471, .adv_w = 106, .box_h = 13, .box_w = 7, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 517, .adv_w = 144, .box_h = 13, .box_w = 9, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 576, .adv_w = 144, .box_h = 12, .box_w = 5, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 606, .adv_w = 144, .box_h = 12, .box_w = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 660, .adv_w = 144, .box_h = 13, .box_w = 8, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 712, .adv_w = 144, .box_h = 12, .box_w = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 766, .adv_w = 144, .box_h = 13, .box_w = 8, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 818, .adv_w = 144, .box_h = 13, .box_w = 8, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 870, .adv_w = 144, .box_h = 12, .box_w = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 924, .adv_w = 144, .box_h = 13, .box_w = 9, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 983, .adv_w = 144, .box_h = 12, .box_w = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1031, .adv_w = 62, .box_h = 10, .box_w = 2, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 1041, .adv_w = 54, .box_h = 12, .box_w = 3, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1059, .adv_w = 130, .box_h = 8, .box_w = 7, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 1087, .adv_w = 141, .box_h = 5, .box_w = 7, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 1105, .adv_w = 134, .box_h = 8, .box_w = 7, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 1133, .adv_w = 121, .box_h = 13, .box_w = 7, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1179, .adv_w = 230, .box_h = 16, .box_w = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 1291, .adv_w = 167, .box_h = 12, .box_w = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1357, .adv_w = 159, .box_h = 12, .box_w = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1411, .adv_w = 167, .box_h = 13, .box_w = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1476, .adv_w = 168, .box_h = 12, .box_w = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1530, .adv_w = 146, .box_h = 12, .box_w = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1578, .adv_w = 142, .box_h = 12, .box_w = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1626, .adv_w = 174, .box_h = 13, .box_w = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1691, .adv_w = 183, .box_h = 12, .box_w = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1751, .adv_w = 70, .box_h = 12, .box_w = 2, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1763, .adv_w = 141, .box_h = 13, .box_w = 8, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1815, .adv_w = 161, .box_h = 12, .box_w = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1869, .adv_w = 138, .box_h = 12, .box_w = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1917, .adv_w = 224, .box_h = 12, .box_w = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1989, .adv_w = 183, .box_h = 12, .box_w = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2049, .adv_w = 176, .box_h = 13, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 2121, .adv_w = 162, .box_h = 12, .box_w = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2175, .adv_w = 176, .box_h = 14, .box_w = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2252, .adv_w = 158, .box_h = 12, .box_w = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2306, .adv_w = 152, .box_h = 13, .box_w = 9, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 2365, .adv_w = 153, .box_h = 12, .box_w = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2425, .adv_w = 166, .box_h = 13, .box_w = 9, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 2484, .adv_w = 163, .box_h = 12, .box_w = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2544, .adv_w = 227, .box_h = 12, .box_w = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2628, .adv_w = 161, .box_h = 12, .box_w = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2688, .adv_w = 154, .box_h = 12, .box_w = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2748, .adv_w = 153, .box_h = 12, .box_w = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2802, .adv_w = 68, .box_h = 16, .box_w = 4, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 2834, .adv_w = 105, .box_h = 13, .box_w = 7, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 2880, .adv_w = 68, .box_h = 16, .box_w = 4, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2912, .adv_w = 107, .box_h = 7, .box_w = 7, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 2937, .adv_w = 116, .box_h = 2, .box_w = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2945, .adv_w = 79, .box_h = 3, .box_w = 4, .ofs_x = 0, .ofs_y = 9},
    {.bitmap_index = 2951, .adv_w = 139, .box_h = 10, .box_w = 8, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 2991, .adv_w = 144, .box_h = 13, .box_w = 8, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 3043, .adv_w = 134, .box_h = 10, .box_w = 8, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3083, .adv_w = 144, .box_h = 13, .box_w = 8, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3135, .adv_w = 136, .box_h = 10, .box_w = 8, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3175, .adv_w = 89, .box_h = 13, .box_w = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3214, .adv_w = 144, .box_h = 13, .box_w = 8, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 3266, .adv_w = 141, .box_h = 12, .box_w = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3308, .adv_w = 62, .box_h = 12, .box_w = 2, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3320, .adv_w = 61, .box_h = 16, .box_w = 4, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 3352, .adv_w = 130, .box_h = 12, .box_w = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3400, .adv_w = 62, .box_h = 12, .box_w = 2, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3412, .adv_w = 224, .box_h = 9, .box_w = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3466, .adv_w = 141, .box_h = 9, .box_w = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3498, .adv_w = 146, .box_h = 10, .box_w = 9, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3543, .adv_w = 144, .box_h = 13, .box_w = 8, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 3595, .adv_w = 146, .box_h = 13, .box_w = 8, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 3647, .adv_w = 87, .box_h = 9, .box_w = 5, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3670, .adv_w = 132, .box_h = 10, .box_w = 8, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3710, .adv_w = 84, .box_h = 12, .box_w = 5, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3740, .adv_w = 141, .box_h = 10, .box_w = 7, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 3775, .adv_w = 124, .box_h = 9, .box_w = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3811, .adv_w = 192, .box_h = 9, .box_w = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3865, .adv_w = 127, .box_h = 9, .box_w = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3901, .adv_w = 121, .box_h = 13, .box_w = 8, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 3953, .adv_w = 127, .box_h = 9, .box_w = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3989, .adv_w = 87, .box_h = 16, .box_w = 6, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4037, .adv_w = 62, .box_h = 15, .box_w = 2, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 4052, .adv_w = 87, .box_h = 16, .box_w = 5, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4092, .adv_w = 174, .box_h = 4, .box_w = 9, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 4110, .adv_w = 219, .box_h = 16, .box_w = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4222, .adv_w = 274, .box_h = 16, .box_w = 18, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4366, .adv_w = 256, .box_h = 13, .box_w = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4470, .adv_w = 256, .box_h = 11, .box_w = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4547, .adv_w = 201, .box_h = 12, .box_w = 11, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 4613, .adv_w = 219, .box_h = 16, .box_w = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4725, .adv_w = 219, .box_h = 15, .box_w = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4830, .adv_w = 201, .box_h = 15, .box_w = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4928, .adv_w = 238, .box_h = 12, .box_w = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5018, .adv_w = 238, .box_h = 14, .box_w = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5123, .adv_w = 219, .box_h = 12, .box_w = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5207, .adv_w = 219, .box_h = 15, .box_w = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 5312, .adv_w = 110, .box_h = 12, .box_w = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5354, .adv_w = 165, .box_h = 12, .box_w = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5420, .adv_w = 238, .box_h = 14, .box_w = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5525, .adv_w = 274, .box_h = 15, .box_w = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 5660, .adv_w = 219, .box_h = 15, .box_w = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 5765, .adv_w = 146, .box_h = 15, .box_w = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 5840, .adv_w = 201, .box_h = 15, .box_w = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 5938, .adv_w = 219, .box_h = 15, .box_w = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 6043, .adv_w = 219, .box_h = 15, .box_w = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 6148, .adv_w = 146, .box_h = 15, .box_w = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 6223, .adv_w = 220, .box_h = 12, .box_w = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6307, .adv_w = 183, .box_h = 15, .box_w = 10, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6382, .adv_w = 183, .box_h = 15, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6465, .adv_w = 201, .box_h = 13, .box_w = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6550, .adv_w = 201, .box_h = 4, .box_w = 13, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 6576, .adv_w = 256, .box_h = 16, .box_w = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 6704, .adv_w = 256, .box_h = 15, .box_w = 16, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6824, .adv_w = 256, .box_h = 10, .box_w = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6904, .adv_w = 256, .box_h = 10, .box_w = 16, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6984, .adv_w = 274, .box_h = 11, .box_w = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7083, .adv_w = 238, .box_h = 13, .box_w = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7181, .adv_w = 238, .box_h = 16, .box_w = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7301, .adv_w = 201, .box_h = 13, .box_w = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7386, .adv_w = 256, .box_h = 14, .box_w = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7498, .adv_w = 256, .box_h = 17, .box_w = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7634, .adv_w = 219, .box_h = 15, .box_w = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7739, .adv_w = 128, .box_h = 16, .box_w = 8, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7803, .adv_w = 256, .box_h = 17, .box_w = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7939, .adv_w = 274, .box_h = 11, .box_w = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8038, .adv_w = 201, .box_h = 14, .box_w = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 8129, .adv_w = 219, .box_h = 17, .box_w = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8248, .adv_w = 293, .box_h = 13, .box_w = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8365, .adv_w = 329, .box_h = 12, .box_w = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8491, .adv_w = 329, .box_h = 12, .box_w = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8617, .adv_w = 329, .box_h = 12, .box_w = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8743, .adv_w = 329, .box_h = 12, .box_w = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8869, .adv_w = 329, .box_h = 12, .box_w = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8995, .adv_w = 219, .box_h = 17, .box_w = 13, .ofs_x = 0, .ofs_y = -3}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static uint16_t unicode_list_1[] = {
    0x0, 0x7, 0xa, 0xb, 0xc, 0x10, 0x12, 0x13,
    0x14, 0x18, 0x1b, 0x20, 0x25, 0x26, 0x27, 0x3d,
    0x3f, 0x47, 0x4a, 0x4b, 0x4c, 0x50, 0x51, 0x52,
    0x53, 0x66, 0x67, 0x70, 0x73, 0x76, 0x77, 0x78,
    0x7a, 0x92, 0x94, 0xc3, 0xc4, 0xc6, 0xe6, 0xf2,
    0x11b, 0x123, 0x15a, 0x1ea, 0x23f, 0x240, 0x241, 0x242,
    0x243, 0x292
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY,
        .glyph_id_start = 1, .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0
    },
    {
        .range_start = 61441, .range_length = 659, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY,
        .glyph_id_start = 96, .unicode_list = unicode_list_1, .glyph_id_ofs_list = NULL, .list_length = 50
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static uint8_t kern_left_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 0,
    2, 3, 0, 0, 0, 4, 0, 4,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6, 7, 8, 9, 10, 11,
    0, 12, 12, 13, 14, 15, 12, 12,
    9, 16, 17, 18, 0, 19, 13, 20,
    21, 22, 23, 24, 25, 0, 0, 0,
    0, 0, 26, 27, 28, 0, 29, 30,
    0, 31, 0, 0, 32, 0, 31, 31,
    33, 27, 0, 34, 0, 35, 0, 36,
    37, 38, 36, 39, 40, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0
};

/*Map glyph_ids to kern right classes*/
static uint8_t kern_right_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 3,
    2, 0, 4, 5, 0, 6, 7, 6,
    8, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    9, 0, 10, 0, 11, 0, 0, 0,
    11, 0, 0, 12, 0, 0, 0, 0,
    11, 0, 11, 0, 13, 14, 15, 16,
    17, 18, 19, 20, 0, 0, 21, 0,
    0, 0, 22, 0, 23, 23, 23, 24,
    23, 0, 0, 0, 0, 0, 25, 25,
    26, 25, 23, 27, 28, 29, 30, 31,
    32, 33, 31, 34, 0, 0, 35, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0
};

/*Kern values between classes*/
static uint8_t kern_class_values[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -13, 0, 0, 0,
    0, 0, 0, 0, -15, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -6, -7, 0, -2, -8, 0, -10, 0,
    0, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 3, 2, 0,
    3, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -21, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -28, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -15, 0, 0, 0, 0, 0, 0, -8,
    0, -1, 0, 0, -16, -2, -11, -9,
    0, -12, 0, 0, 0, 0, 0, 0,
    -1, 0, 0, -2, -1, -6, -4, 0,
    2, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -3,
    0, -3, 0, 0, -7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -3, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -4, 0, 0, 0, 0, 0,
    0, -1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -2,
    0, 0, 0, 0, 0, -13, 0, 0,
    0, -3, 0, 0, 0, -3, 0, -3,
    0, -3, -5, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    3, 0, 0, 0, 0, 0, 0, 0,
    0, -2, -2, 0, -2, 0, 0, 0,
    -2, -3, -3, 0, 0, 0, 0, 0,
    0, 0, 0, -29, 0, 0, 0, -21,
    0, -33, 0, 3, 0, 0, 0, 0,
    0, 0, 0, -4, -3, 0, 0, -3,
    -3, 0, 0, -3, -3, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 0, 0, 0, -4, 0,
    0, 0, 2, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -8, 0, 0,
    0, -4, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, -3,
    -3, 0, 0, 0, -3, -5, -8, 0,
    0, 0, 0, -42, 0, 0, 0, 0,
    0, 0, 0, 2, -8, 0, 0, -34,
    -7, -22, -18, 0, -30, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -5,
    -17, -11, 0, 0, 0, 0, 0, 0,
    0, 0, -40, 0, 0, 0, -17, 0,
    -25, 0, 0, 0, 0, 0, -4, 0,
    -3, 0, -1, -2, 0, 0, -2, 0,
    0, 2, 0, 2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, 0, -3,
    -2, 0, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -10, 0, -2, 0, 0, -6, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -5, 0,
    0, 0, 0, -27, -29, 0, 0, -10,
    -3, -30, -2, 2, 0, 2, 2, 0,
    2, 0, 0, -14, -12, 0, -14, -12,
    -9, -14, 0, -12, -9, -7, -10, -7,
    0, 0, 0, 0, 3, 0, -28, -5,
    0, 0, -9, -2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2, -6, -5,
    0, 0, -6, -4, 0, 0, -3, -1,
    0, 0, 0, 2, 0, 0, 0, 2,
    0, -15, -7, 0, 0, -5, 0, 0,
    0, 2, 0, 0, 0, 0, 0, 0,
    2, -4, -4, 0, 0, -4, -3, 0,
    0, -2, 0, 0, 0, 0, 2, 0,
    0, 0, 0, 0, 0, -6, 0, 0,
    0, -3, 0, 0, 0, 0, 2, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    -3, 0, 0, 0, -3, -4, 0, 0,
    0, 0, 0, 0, -4, 3, -6, -26,
    -6, 0, 0, -12, -4, -12, -2, 2,
    -12, 2, 2, 2, 2, 0, 2, -9,
    -8, -3, -5, -8, -5, -7, -3, -5,
    -2, 0, -3, -4, 2, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 2, -3,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -3, 0, 0, -3, 0,
    0, 0, -2, -3, -3, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -2, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -8, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, -4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -1, 0, -2, -2,
    0, 0, -1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -2, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -2, 0, 0, 0, 0, 0,
    2, 0, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2, 0, -3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 0, -13, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    -3, -2, 0, 0, 2, 0, 0, 0,
    -15, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, -2, 2, 0, -2, 0, 0, 6,
    0, 2, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 0, 0, 0, -13, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, -2,
    2, 0, -2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -15, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -2, 0, 0,
    -2, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -2, 0, 0, -2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -2, 0, 0, -2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0
};


/*Collect the kern class' data in one place*/
static lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 40,
    .right_class_cnt     = 35,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .cmap_num = 2,
    .bpp = 4,

    .kern_scale = 16,
    .kern_dsc = &kern_classes,
    .kern_classes = 1
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t lv_font_roboto_16 = {
    .dsc = &font_dsc,          /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .line_height = 18,          /*The maximum line height required by the font*/
    .base_line = 4,             /*Baseline measured from the bottom of the line*/
};

#endif /*#if LV_FONT_ROBOTO_16*/

