#include "../../lvgl.h"

/*******************************************************************************
 * Size: 28 px
 * Bpp: 4
 * Opts: --no-compress --no-prefilter --bpp 4 --size 28 --font ./Roboto-Regular.woff -r 0x20-0x7F --font FontAwesome.ttf -r 61441,61448,61451,61452,61453,61457,61459,61460,61461,61465,61468,61473,61478,61479,61480,61502,61504,61512,61515,61516,61517,61521,61522,61523,61524,61543,61544,61553,61556,61559,61560,61561,61563,61587,61589,61636,61637,61639,61671,61683,61724,61732,61787,61931,62016,62017,62018,62019,62020,62099 --format lvgl -o lv_font_roboto_28.c --force-fast-kern-format
 ******************************************************************************/

#ifndef LV_FONT_ROBOTO_28
#define LV_FONT_ROBOTO_28 1
#endif

#if LV_FONT_ROBOTO_28

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0xae, 0xd0, 0xbf, 0xe0, 0xbf, 0xe0, 0xaf, 0xe0,
    0xaf, 0xe0, 0xaf, 0xd0, 0xaf, 0xd0, 0x9f, 0xd0,
    0x9f, 0xd0, 0x9f, 0xc0, 0x9f, 0xc0, 0x9f, 0xc0,
    0x8f, 0xc0, 0x8f, 0xc0, 0x36, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x3a, 0x70, 0xcf, 0xf2, 0x8f, 0xd0,
    0x1, 0x0,

    /* U+22 "\"" */
    0x2f, 0xc0, 0x7f, 0x72, 0xfc, 0x7, 0xf7, 0x2f,
    0xb0, 0x7f, 0x62, 0xfa, 0x7, 0xf5, 0x2f, 0x80,
    0x7f, 0x42, 0xf7, 0x7, 0xf2, 0x1b, 0x40, 0x5b,
    0x10,

    /* U+23 "#" */
    0x0, 0x0, 0x0, 0x1e, 0xd0, 0x0, 0x7e, 0x60,
    0x0, 0x0, 0x0, 0x4, 0xfa, 0x0, 0xb, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x70, 0x0, 0xef,
    0x10, 0x0, 0x0, 0x0, 0xa, 0xf4, 0x0, 0x1f,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x10, 0x4,
    0xfa, 0x0, 0x0, 0x3, 0x33, 0x3f, 0xe3, 0x33,
    0x9f, 0x93, 0x30, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x30, 0xa, 0xaa, 0xdf, 0xda,
    0xaa, 0xff, 0xaa, 0xa2, 0x0, 0x0, 0xa, 0xf5,
    0x0, 0x1f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0x10, 0x4, 0xfb, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xe0, 0x0, 0x7f, 0x80, 0x0, 0x0, 0x0, 0x3,
    0xfb, 0x0, 0xa, 0xf4, 0x0, 0x0, 0x7, 0x77,
    0xaf, 0xc7, 0x77, 0xef, 0x87, 0x71, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x6,
    0x66, 0xef, 0x76, 0x68, 0xfd, 0x66, 0x61, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x6f, 0x80, 0x0, 0x0,
    0x0, 0x3, 0xfc, 0x0, 0x9, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x90, 0x0, 0xcf, 0x20, 0x0,
    0x0, 0x0, 0x9, 0xf6, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0x30, 0x3, 0xfc, 0x0,
    0x0, 0x0,

    /* U+24 "$" */
    0x0, 0x0, 0x0, 0x12, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x30, 0x0, 0x0, 0x0, 0x3, 0xbf, 0xff,
    0xfc, 0x40, 0x0, 0x0, 0x5f, 0xff, 0xff, 0xff,
    0xf7, 0x0, 0x1, 0xff, 0xe5, 0x10, 0x5e, 0xff,
    0x30, 0x7, 0xff, 0x40, 0x0, 0x3, 0xff, 0xa0,
    0xa, 0xfe, 0x0, 0x0, 0x0, 0xbf, 0xe0, 0xb,
    0xfd, 0x0, 0x0, 0x0, 0x8f, 0xf0, 0x9, 0xff,
    0x10, 0x0, 0x0, 0x13, 0x30, 0x4, 0xff, 0xc1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0x82,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0xb5,
    0x0, 0x0, 0x0, 0x0, 0x3a, 0xff, 0xff, 0xd2,
    0x0, 0x0, 0x0, 0x0, 0x17, 0xdf, 0xff, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xf1, 0x6d, 0xd0,
    0x0, 0x0, 0x0, 0x5f, 0xf3, 0x6f, 0xf3, 0x0,
    0x0, 0x0, 0x6f, 0xf2, 0x2f, 0xfa, 0x0, 0x0,
    0x0, 0xcf, 0xf0, 0xa, 0xff, 0x92, 0x0, 0x3b,
    0xff, 0x90, 0x1, 0xdf, 0xff, 0xff, 0xff, 0xfc,
    0x0, 0x0, 0x8, 0xef, 0xff, 0xfe, 0x70, 0x0,
    0x0, 0x0, 0x3, 0xff, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdd, 0x0, 0x0, 0x0,

    /* U+25 "%" */
    0x0, 0x1, 0x21, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1b, 0xff, 0xfb, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xfc, 0x8b, 0xfd, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xfb, 0x0, 0xb,
    0xf5, 0x0, 0x0, 0xb4, 0x0, 0x0, 0x7f, 0x60,
    0x0, 0x5f, 0x80, 0x0, 0x8f, 0x70, 0x0, 0x8,
    0xf5, 0x0, 0x4, 0xf9, 0x0, 0x2f, 0xd0, 0x0,
    0x0, 0x7f, 0x60, 0x0, 0x5f, 0x70, 0xc, 0xf3,
    0x0, 0x0, 0x4, 0xfc, 0x0, 0xc, 0xf4, 0x6,
    0xf9, 0x0, 0x0, 0x0, 0xb, 0xfd, 0xad, 0xfc,
    0x1, 0xee, 0x10, 0x0, 0x0, 0x0, 0x8, 0xef,
    0xe9, 0x0, 0xaf, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf7, 0x1,
    0x9e, 0xfc, 0x50, 0x0, 0x0, 0x0, 0x2, 0xfd,
    0x1, 0xef, 0xdb, 0xff, 0x60, 0x0, 0x0, 0x0,
    0xcf, 0x30, 0x8f, 0x90, 0x3, 0xfe, 0x0, 0x0,
    0x0, 0x6f, 0x90, 0xc, 0xf1, 0x0, 0xb, 0xf3,
    0x0, 0x0, 0x1e, 0xe1, 0x0, 0xdf, 0x0, 0x0,
    0x9f, 0x40, 0x0, 0xa, 0xf5, 0x0, 0xd, 0xf1,
    0x0, 0xa, 0xf3, 0x0, 0x1, 0xfb, 0x0, 0x0,
    0xaf, 0x50, 0x0, 0xef, 0x10, 0x0, 0x2, 0x20,
    0x0, 0x3, 0xff, 0x86, 0xcf, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xef, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x34, 0x10,
    0x0,

    /* U+26 "&" */
    0x0, 0x0, 0x0, 0x22, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1a, 0xff, 0xff, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x1e, 0xff, 0xff, 0xff, 0xc0, 0x0,
    0x0, 0x0, 0x9, 0xff, 0x70, 0x6, 0xff, 0x60,
    0x0, 0x0, 0x0, 0xdf, 0xc0, 0x0, 0xb, 0xfa,
    0x0, 0x0, 0x0, 0xf, 0xf9, 0x0, 0x0, 0xaf,
    0xa0, 0x0, 0x0, 0x0, 0xdf, 0xb0, 0x0, 0x1f,
    0xf6, 0x0, 0x0, 0x0, 0x8, 0xff, 0x30, 0x2d,
    0xfd, 0x0, 0x0, 0x0, 0x0, 0x1e, 0xfd, 0x6f,
    0xfd, 0x20, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xff,
    0xfb, 0x10, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff,
    0xff, 0xf6, 0x0, 0x0, 0x33, 0x0, 0x6, 0xff,
    0xc1, 0xcf, 0xf3, 0x0, 0x3f, 0xf1, 0x1, 0xff,
    0xc0, 0x1, 0xef, 0xe2, 0x5, 0xff, 0x0, 0x7f,
    0xf3, 0x0, 0x3, 0xff, 0xd0, 0x9f, 0xd0, 0x9,
    0xff, 0x0, 0x0, 0x5, 0xff, 0xbe, 0xf8, 0x0,
    0x8f, 0xf0, 0x0, 0x0, 0x7, 0xff, 0xff, 0x20,
    0x4, 0xff, 0x70, 0x0, 0x0, 0xc, 0xff, 0xa0,
    0x0, 0xd, 0xff, 0x60, 0x0, 0x19, 0xff, 0xff,
    0x40, 0x0, 0x2e, 0xff, 0xfd, 0xdf, 0xff, 0xbe,
    0xfe, 0x20, 0x0, 0x19, 0xef, 0xff, 0xfc, 0x60,
    0x2f, 0xfd, 0x10, 0x0, 0x0, 0x23, 0x31, 0x0,
    0x0, 0x0, 0x0,

    /* U+27 "'" */
    0x9f, 0x79, 0xf7, 0x9f, 0x69, 0xf5, 0x9f, 0x49,
    0xf3, 0x58, 0x10,

    /* U+28 "(" */
    0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0xbd,
    0x0, 0x0, 0xb, 0xfa, 0x0, 0x0, 0x9f, 0xb0,
    0x0, 0x4, 0xfe, 0x10, 0x0, 0xe, 0xf6, 0x0,
    0x0, 0x5f, 0xe0, 0x0, 0x0, 0xcf, 0x80, 0x0,
    0x2, 0xff, 0x30, 0x0, 0x6, 0xff, 0x0, 0x0,
    0xa, 0xfb, 0x0, 0x0, 0xe, 0xf9, 0x0, 0x0,
    0xf, 0xf7, 0x0, 0x0, 0x2f, 0xf6, 0x0, 0x0,
    0x2f, 0xf5, 0x0, 0x0, 0x2f, 0xf5, 0x0, 0x0,
    0x2f, 0xf6, 0x0, 0x0, 0xf, 0xf7, 0x0, 0x0,
    0xe, 0xf9, 0x0, 0x0, 0xa, 0xfb, 0x0, 0x0,
    0x6, 0xff, 0x0, 0x0, 0x2, 0xff, 0x30, 0x0,
    0x0, 0xcf, 0x80, 0x0, 0x0, 0x5f, 0xe0, 0x0,
    0x0, 0xd, 0xf6, 0x0, 0x0, 0x4, 0xfe, 0x10,
    0x0, 0x0, 0x9f, 0xb0, 0x0, 0x0, 0xb, 0xfa,
    0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0, 0x2,

    /* U+29 ")" */
    0x2, 0x0, 0x0, 0x0, 0x4f, 0x60, 0x0, 0x0,
    0x2e, 0xf5, 0x0, 0x0, 0x3, 0xff, 0x30, 0x0,
    0x0, 0x7f, 0xd0, 0x0, 0x0, 0xd, 0xf7, 0x0,
    0x0, 0x6, 0xfe, 0x0, 0x0, 0x0, 0xff, 0x60,
    0x0, 0x0, 0xbf, 0xb0, 0x0, 0x0, 0x6f, 0xf0,
    0x0, 0x0, 0x3f, 0xf4, 0x0, 0x0, 0xf, 0xf7,
    0x0, 0x0, 0xe, 0xf9, 0x0, 0x0, 0xd, 0xfa,
    0x0, 0x0, 0xd, 0xfb, 0x0, 0x0, 0xd, 0xfb,
    0x0, 0x0, 0xd, 0xfa, 0x0, 0x0, 0xe, 0xf9,
    0x0, 0x0, 0xf, 0xf7, 0x0, 0x0, 0x3f, 0xf4,
    0x0, 0x0, 0x6f, 0xf0, 0x0, 0x0, 0xaf, 0xb0,
    0x0, 0x0, 0xff, 0x50, 0x0, 0x5, 0xfe, 0x0,
    0x0, 0xd, 0xf7, 0x0, 0x0, 0x6f, 0xd0, 0x0,
    0x2, 0xff, 0x20, 0x0, 0x2e, 0xf5, 0x0, 0x0,
    0x4f, 0x50, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0,

    /* U+2A "*" */
    0x0, 0x0, 0xe, 0xe1, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf0,
    0x0, 0x0, 0x18, 0x20, 0xe, 0xf0, 0x1, 0x71,
    0x5f, 0xfc, 0x7e, 0xf5, 0xbf, 0xf5, 0x3a, 0xff,
    0xff, 0xff, 0xff, 0xc5, 0x0, 0x4, 0xcf, 0xfd,
    0x61, 0x0, 0x0, 0x3, 0xff, 0xfe, 0x20, 0x0,
    0x0, 0xd, 0xf7, 0x9f, 0xc0, 0x0, 0x0, 0xaf,
    0xc0, 0xd, 0xf8, 0x0, 0x0, 0xdf, 0x20, 0x4,
    0xfd, 0x0, 0x0, 0x4, 0x0, 0x0, 0x60, 0x0,

    /* U+2B "+" */
    0x0, 0x0, 0x2, 0x77, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0x20,
    0x0, 0x0, 0xaa, 0xaa, 0xac, 0xff, 0xba, 0xaa,
    0xa7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xab, 0xbb, 0xbd, 0xff, 0xcb, 0xbb, 0xb8, 0x0,
    0x0, 0x6, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0x20, 0x0,
    0x0,

    /* U+2C "," */
    0x4, 0xff, 0x30, 0x4f, 0xf3, 0x4, 0xff, 0x20,
    0x7f, 0xf0, 0xc, 0xf9, 0x5, 0xff, 0x10, 0x1b,
    0x40, 0x0,

    /* U+2D "-" */
    0x37, 0x77, 0x77, 0x71, 0x8f, 0xff, 0xff, 0xf2,
    0x49, 0x99, 0x99, 0x91,

    /* U+2E "." */
    0x7, 0xd8, 0x0, 0xff, 0xf1, 0xb, 0xfc, 0x0,
    0x1, 0x0,

    /* U+2F "/" */
    0x0, 0x0, 0x0, 0x0, 0x9e, 0x80, 0x0, 0x0,
    0x0, 0xe, 0xf2, 0x0, 0x0, 0x0, 0x5, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x60, 0x0, 0x0,
    0x0, 0x2f, 0xf1, 0x0, 0x0, 0x0, 0x8, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0xef, 0x40, 0x0, 0x0,
    0x0, 0x4f, 0xd0, 0x0, 0x0, 0x0, 0xa, 0xf7,
    0x0, 0x0, 0x0, 0x1, 0xff, 0x10, 0x0, 0x0,
    0x0, 0x7f, 0xb0, 0x0, 0x0, 0x0, 0xd, 0xf5,
    0x0, 0x0, 0x0, 0x3, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0x90, 0x0, 0x0, 0x0, 0xe, 0xf3,
    0x0, 0x0, 0x0, 0x5, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x60, 0x0, 0x0, 0x0, 0x2f, 0xf1,
    0x0, 0x0, 0x0, 0x8, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0xef, 0x40, 0x0, 0x0, 0x0, 0x4f, 0xe0,
    0x0, 0x0, 0x0, 0x7, 0xb6, 0x0, 0x0, 0x0,
    0x0,

    /* U+30 "0" */
    0x0, 0x0, 0x1, 0x22, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xcf, 0xff, 0xfb, 0x20, 0x0, 0x0, 0x7f,
    0xff, 0xef, 0xff, 0xf4, 0x0, 0x3, 0xff, 0xb2,
    0x0, 0x4e, 0xfe, 0x0, 0xa, 0xfe, 0x0, 0x0,
    0x4, 0xff, 0x60, 0xf, 0xf8, 0x0, 0x0, 0x0,
    0xdf, 0xb0, 0x2f, 0xf5, 0x0, 0x0, 0x0, 0x9f,
    0xe0, 0x5f, 0xf3, 0x0, 0x0, 0x0, 0x8f, 0xf0,
    0x6f, 0xf2, 0x0, 0x0, 0x0, 0x7f, 0xf1, 0x6f,
    0xf1, 0x0, 0x0, 0x0, 0x6f, 0xf2, 0x6f, 0xf1,
    0x0, 0x0, 0x0, 0x6f, 0xf2, 0x6f, 0xf1, 0x0,
    0x0, 0x0, 0x6f, 0xf2, 0x6f, 0xf1, 0x0, 0x0,
    0x0, 0x6f, 0xf2, 0x6f, 0xf2, 0x0, 0x0, 0x0,
    0x7f, 0xf1, 0x5f, 0xf3, 0x0, 0x0, 0x0, 0x8f,
    0xf0, 0x2f, 0xf5, 0x0, 0x0, 0x0, 0x9f, 0xe0,
    0xf, 0xf8, 0x0, 0x0, 0x0, 0xdf, 0xb0, 0xa,
    0xfe, 0x0, 0x0, 0x3, 0xff, 0x60, 0x3, 0xff,
    0xb1, 0x0, 0x3d, 0xfe, 0x0, 0x0, 0x8f, 0xff,
    0xdd, 0xff, 0xf4, 0x0, 0x0, 0x6, 0xdf, 0xff,
    0xfc, 0x30, 0x0, 0x0, 0x0, 0x2, 0x33, 0x10,
    0x0, 0x0,

    /* U+31 "1" */
    0x0, 0x0, 0x3, 0x9e, 0x0, 0x16, 0xdf, 0xff,
    0x4b, 0xff, 0xff, 0xff, 0xaf, 0xfd, 0x7a, 0xff,
    0x99, 0x30, 0x9, 0xff, 0x0, 0x0, 0x9, 0xff,
    0x0, 0x0, 0x9, 0xff, 0x0, 0x0, 0x9, 0xff,
    0x0, 0x0, 0x9, 0xff, 0x0, 0x0, 0x9, 0xff,
    0x0, 0x0, 0x9, 0xff, 0x0, 0x0, 0x9, 0xff,
    0x0, 0x0, 0x9, 0xff, 0x0, 0x0, 0x9, 0xff,
    0x0, 0x0, 0x9, 0xff, 0x0, 0x0, 0x9, 0xff,
    0x0, 0x0, 0x9, 0xff, 0x0, 0x0, 0x9, 0xff,
    0x0, 0x0, 0x9, 0xff, 0x0, 0x0, 0x9, 0xff,

    /* U+32 "2" */
    0x0, 0x0, 0x1, 0x22, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xdf, 0xff, 0xfb, 0x30, 0x0, 0x1, 0xcf,
    0xff, 0xef, 0xff, 0xf5, 0x0, 0xb, 0xff, 0x71,
    0x0, 0x5e, 0xff, 0x20, 0x4f, 0xf7, 0x0, 0x0,
    0x5, 0xff, 0x80, 0x8f, 0xf0, 0x0, 0x0, 0x0,
    0xef, 0xb0, 0xae, 0xc0, 0x0, 0x0, 0x0, 0xcf,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0x30, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x2e, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xef, 0xd1, 0x0, 0x0, 0x0,
    0x0, 0x1d, 0xfd, 0x10, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xe2, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff,
    0x31, 0x11, 0x11, 0x11, 0x10, 0x5f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0x5f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb,

    /* U+33 "3" */
    0x0, 0x0, 0x1, 0x22, 0x0, 0x0, 0x0, 0x0,
    0x7d, 0xff, 0xff, 0x92, 0x0, 0x1, 0xcf, 0xff,
    0xef, 0xff, 0xf3, 0x0, 0xbf, 0xf8, 0x10, 0x4,
    0xef, 0xd0, 0x3f, 0xf8, 0x0, 0x0, 0x5, 0xff,
    0x57, 0xff, 0x20, 0x0, 0x0, 0xf, 0xf8, 0x25,
    0x50, 0x0, 0x0, 0x0, 0xff, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xff, 0x10, 0x0, 0x2, 0x33, 0x6c, 0xff,
    0x40, 0x0, 0x0, 0xaf, 0xff, 0xfd, 0x20, 0x0,
    0x0, 0x9, 0xde, 0xff, 0xfc, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x5e, 0xfd, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xc3, 0x43, 0x0, 0x0, 0x0, 0xa, 0xfe,
    0xaf, 0xf0, 0x0, 0x0, 0x0, 0xcf, 0xc6, 0xff,
    0x50, 0x0, 0x0, 0x1f, 0xf8, 0x1e, 0xfe, 0x50,
    0x0, 0x2c, 0xff, 0x20, 0x3f, 0xff, 0xfd, 0xef,
    0xff, 0x50, 0x0, 0x2a, 0xff, 0xff, 0xfb, 0x30,
    0x0, 0x0, 0x0, 0x24, 0x30, 0x0, 0x0,

    /* U+34 "4" */
    0x0, 0x0, 0x0, 0x0, 0x9, 0xee, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xf6, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0x93, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x8, 0xfe, 0x13, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x2f, 0xf5, 0x3, 0xff, 0x50, 0x0,
    0x0, 0x0, 0xcf, 0xa0, 0x3, 0xff, 0x50, 0x0,
    0x0, 0x7, 0xff, 0x10, 0x3, 0xff, 0x50, 0x0,
    0x0, 0x2f, 0xf6, 0x0, 0x3, 0xff, 0x50, 0x0,
    0x0, 0xbf, 0xc0, 0x0, 0x3, 0xff, 0x50, 0x0,
    0x6, 0xff, 0x20, 0x0, 0x3, 0xff, 0x50, 0x0,
    0x1e, 0xfe, 0xaa, 0xaa, 0xab, 0xff, 0xca, 0xa1,
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x16, 0x66, 0x66, 0x66, 0x68, 0xff, 0x96, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x50, 0x0,

    /* U+35 "5" */
    0x3, 0xee, 0xee, 0xee, 0xee, 0xee, 0x0, 0x5f,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x6, 0xff, 0x77,
    0x77, 0x77, 0x77, 0x0, 0x8f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0x99,
    0xef, 0xeb, 0x50, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xa0, 0x2, 0xff, 0xe8, 0x44, 0x8e, 0xff,
    0x80, 0x3, 0x61, 0x0, 0x0, 0x2e, 0xff, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xf9, 0x34, 0x20, 0x0, 0x0, 0x0,
    0xff, 0x8c, 0xfb, 0x0, 0x0, 0x0, 0x2f, 0xf6,
    0x8f, 0xf2, 0x0, 0x0, 0x9, 0xff, 0x21, 0xff,
    0xd3, 0x0, 0x7, 0xff, 0xa0, 0x4, 0xff, 0xfe,
    0xdf, 0xff, 0xd1, 0x0, 0x3, 0xbf, 0xff, 0xfe,
    0x80, 0x0, 0x0, 0x0, 0x3, 0x32, 0x0, 0x0,
    0x0,

    /* U+36 "6" */
    0x0, 0x0, 0x0, 0x49, 0xcd, 0x80, 0x0, 0x0,
    0x0, 0x3d, 0xff, 0xff, 0x80, 0x0, 0x0, 0x5,
    0xff, 0xfb, 0x64, 0x10, 0x0, 0x0, 0x3f, 0xfd,
    0x20, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xe1, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xf9, 0x3a, 0xff, 0xfc, 0x40, 0x0,
    0xf, 0xfc, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x1f,
    0xff, 0xf7, 0x21, 0x4d, 0xff, 0x50, 0x2f, 0xff,
    0x30, 0x0, 0x1, 0xef, 0xc0, 0x3f, 0xf7, 0x0,
    0x0, 0x0, 0x8f, 0xf1, 0x3f, 0xf5, 0x0, 0x0,
    0x0, 0x4f, 0xf4, 0x2f, 0xf6, 0x0, 0x0, 0x0,
    0x2f, 0xf5, 0xf, 0xf8, 0x0, 0x0, 0x0, 0x3f,
    0xf4, 0xc, 0xfd, 0x0, 0x0, 0x0, 0x6f, 0xf2,
    0x6, 0xff, 0x50, 0x0, 0x0, 0xdf, 0xd0, 0x0,
    0xcf, 0xf5, 0x0, 0x1a, 0xff, 0x50, 0x0, 0x2e,
    0xff, 0xed, 0xff, 0xf9, 0x0, 0x0, 0x1, 0x9f,
    0xff, 0xfd, 0x50, 0x0, 0x0, 0x0, 0x0, 0x23,
    0x20, 0x0, 0x0,

    /* U+37 "7" */
    0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xe7, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x33, 0x33,
    0x33, 0x33, 0x33, 0x7f, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0x20,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xf7,
    0x0, 0x0, 0x0, 0x0,

    /* U+38 "8" */
    0x0, 0x0, 0x0, 0x22, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xcf, 0xff, 0xfa, 0x20, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xff, 0xf4, 0x0, 0x4, 0xff, 0xc3,
    0x0, 0x5e, 0xff, 0x10, 0xb, 0xfe, 0x10, 0x0,
    0x5, 0xff, 0x70, 0xe, 0xfa, 0x0, 0x0, 0x0,
    0xff, 0xa0, 0xf, 0xf9, 0x0, 0x0, 0x0, 0xdf,
    0xb0, 0xd, 0xfb, 0x0, 0x0, 0x0, 0xff, 0x80,
    0x6, 0xff, 0x40, 0x0, 0x8, 0xff, 0x20, 0x0,
    0xbf, 0xf9, 0x56, 0xbf, 0xf7, 0x0, 0x0, 0x9,
    0xff, 0xff, 0xff, 0x50, 0x0, 0x0, 0x6f, 0xff,
    0xdd, 0xff, 0xd2, 0x0, 0x6, 0xff, 0x90, 0x0,
    0x2c, 0xfe, 0x20, 0xe, 0xf9, 0x0, 0x0, 0x0,
    0xdf, 0xa0, 0x4f, 0xf3, 0x0, 0x0, 0x0, 0x8f,
    0xf0, 0x6f, 0xf1, 0x0, 0x0, 0x0, 0x6f, 0xf2,
    0x6f, 0xf3, 0x0, 0x0, 0x0, 0x8f, 0xf1, 0x2f,
    0xf8, 0x0, 0x0, 0x0, 0xdf, 0xd0, 0xb, 0xff,
    0x70, 0x0, 0x1a, 0xff, 0x60, 0x1, 0xdf, 0xff,
    0xde, 0xff, 0xfa, 0x0, 0x0, 0x8, 0xef, 0xff,
    0xfd, 0x50, 0x0, 0x0, 0x0, 0x2, 0x33, 0x10,
    0x0, 0x0,

    /* U+39 "9" */
    0x0, 0x0, 0x1, 0x21, 0x0, 0x0, 0x0, 0x0,
    0x6d, 0xff, 0xfd, 0x60, 0x0, 0x0, 0xbf, 0xff,
    0xff, 0xff, 0xa0, 0x0, 0x8f, 0xf9, 0x10, 0x1a,
    0xff, 0x70, 0x1f, 0xfa, 0x0, 0x0, 0xb, 0xff,
    0x15, 0xff, 0x30, 0x0, 0x0, 0x3f, 0xf6, 0x8f,
    0xf0, 0x0, 0x0, 0x0, 0xef, 0xa9, 0xfe, 0x0,
    0x0, 0x0, 0xb, 0xfc, 0x9f, 0xf0, 0x0, 0x0,
    0x0, 0xaf, 0xd6, 0xff, 0x20, 0x0, 0x0, 0xb,
    0xfe, 0x2f, 0xf9, 0x0, 0x0, 0x4, 0xff, 0xd0,
    0xbf, 0xf6, 0x0, 0x6, 0xff, 0xfc, 0x2, 0xef,
    0xfe, 0xce, 0xfe, 0xdf, 0xb0, 0x2, 0xbf, 0xff,
    0xfb, 0x2d, 0xf8, 0x0, 0x0, 0x14, 0x41, 0x0,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x1c, 0xff, 0x20, 0x0, 0x1, 0x35,
    0x9f, 0xff, 0x50, 0x0, 0x0, 0xdf, 0xff, 0xfd,
    0x40, 0x0, 0x0, 0xd, 0xfd, 0xa5, 0x0, 0x0,
    0x0,

    /* U+3A ":" */
    0x7, 0xd8, 0x0, 0xff, 0xf1, 0xb, 0xfc, 0x0,
    0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xd8,
    0x0, 0xff, 0xf1, 0xb, 0xfc, 0x0, 0x1, 0x0,

    /* U+3B ";" */
    0x0, 0x7d, 0x80, 0x0, 0xff, 0xf1, 0x0, 0xbf,
    0xc0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0x30, 0x4,
    0xff, 0x30, 0x4, 0xff, 0x20, 0x7, 0xff, 0x0,
    0xc, 0xf9, 0x0, 0x5f, 0xf1, 0x0, 0x1b, 0x40,
    0x0,

    /* U+3C "<" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0x20, 0x0,
    0x0, 0x0, 0x4, 0xcf, 0xf2, 0x0, 0x0, 0x0,
    0x6d, 0xff, 0xfe, 0x10, 0x0, 0x6, 0xef, 0xff,
    0xc6, 0x0, 0x1, 0x8e, 0xff, 0xf9, 0x30, 0x0,
    0x0, 0xff, 0xfd, 0x60, 0x0, 0x0, 0x0, 0xf,
    0xfe, 0x71, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xff,
    0xfa, 0x30, 0x0, 0x0, 0x0, 0x4, 0xcf, 0xff,
    0xd7, 0x10, 0x0, 0x0, 0x0, 0x3b, 0xff, 0xff,
    0x91, 0x0, 0x0, 0x0, 0x2, 0x9f, 0xff, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x18, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x0,

    /* U+3D "=" */
    0x45, 0x55, 0x55, 0x55, 0x55, 0x52, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xf7, 0xce, 0xee, 0xee, 0xee,
    0xee, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9a, 0xaa, 0xaa, 0xaa,
    0xaa, 0xa4, 0xef, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x84,

    /* U+3E ">" */
    0x2c, 0x50, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff,
    0xd6, 0x0, 0x0, 0x0, 0x0, 0x1d, 0xff, 0xfe,
    0x81, 0x0, 0x0, 0x0, 0x3, 0x9f, 0xff, 0xfa,
    0x30, 0x0, 0x0, 0x0, 0x5, 0xbf, 0xff, 0xc5,
    0x0, 0x0, 0x0, 0x0, 0x29, 0xef, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x5c, 0xff, 0x80, 0x0, 0x0,
    0x28, 0xef, 0xff, 0x92, 0x0, 0x5, 0xbf, 0xff,
    0xe8, 0x10, 0x0, 0x9e, 0xff, 0xfc, 0x50, 0x0,
    0x0, 0x2f, 0xff, 0xb4, 0x0, 0x0, 0x0, 0x2,
    0xf9, 0x20, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+3F "?" */
    0x0, 0x0, 0x12, 0x20, 0x0, 0x0, 0x0, 0x6d,
    0xff, 0xfe, 0x91, 0x0, 0xa, 0xff, 0xff, 0xff,
    0xfd, 0x10, 0x6f, 0xfb, 0x31, 0x2a, 0xff, 0x90,
    0xcf, 0xd0, 0x0, 0x0, 0xcf, 0xe0, 0xab, 0x70,
    0x0, 0x0, 0x8f, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xd0,
    0x0, 0x0, 0x0, 0x4, 0xff, 0x70, 0x0, 0x0,
    0x0, 0x3f, 0xfd, 0x0, 0x0, 0x0, 0x2, 0xef,
    0xe2, 0x0, 0x0, 0x0, 0x1e, 0xfe, 0x30, 0x0,
    0x0, 0x0, 0x9f, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xb0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x66, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7a, 0x30,
    0x0, 0x0, 0x0, 0x2, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x1, 0xef, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x0, 0x0, 0x0,

    /* U+40 "@" */
    0x0, 0x0, 0x0, 0x0, 0x3, 0x67, 0x87, 0x51,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8e,
    0xff, 0xff, 0xff, 0xfc, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xef, 0xfa, 0x64, 0x45, 0x7c, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x5, 0xff, 0x80, 0x0,
    0x0, 0x0, 0x2, 0xbf, 0xc0, 0x0, 0x0, 0x4,
    0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xa0, 0x0, 0x1, 0xef, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0x40, 0x0, 0x9f, 0x80,
    0x0, 0x0, 0x6, 0x76, 0x20, 0x0, 0x2, 0xfb,
    0x0, 0x1f, 0xf0, 0x0, 0x0, 0x5e, 0xff, 0xff,
    0xa1, 0x0, 0xb, 0xf1, 0x7, 0xf8, 0x0, 0x0,
    0x5f, 0xf8, 0x45, 0xef, 0x50, 0x0, 0x6f, 0x50,
    0xcf, 0x30, 0x0, 0x1e, 0xf4, 0x0, 0xc, 0xf3,
    0x0, 0x3, 0xf7, 0xf, 0xf0, 0x0, 0x8, 0xfb,
    0x0, 0x0, 0xef, 0x20, 0x0, 0x1f, 0xa3, 0xfc,
    0x0, 0x0, 0xef, 0x40, 0x0, 0xf, 0xf0, 0x0,
    0x1, 0xfa, 0x4f, 0xa0, 0x0, 0x2f, 0xf0, 0x0,
    0x1, 0xff, 0x0, 0x0, 0xf, 0xb6, 0xf9, 0x0,
    0x5, 0xfd, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x1,
    0xfa, 0x6f, 0x90, 0x0, 0x7f, 0xb0, 0x0, 0x4,
    0xfc, 0x0, 0x0, 0x3f, 0x95, 0xf9, 0x0, 0x8,
    0xfa, 0x0, 0x0, 0x5f, 0xa0, 0x0, 0x6, 0xf5,
    0x4f, 0xb0, 0x0, 0x7f, 0xd0, 0x0, 0xc, 0xfb,
    0x0, 0x0, 0xdf, 0x11, 0xfd, 0x0, 0x3, 0xff,
    0x40, 0x8, 0xff, 0xd0, 0x0, 0x6f, 0x90, 0xe,
    0xf1, 0x0, 0xc, 0xff, 0xcd, 0xf7, 0xef, 0xa6,
    0x9f, 0xd1, 0x0, 0x9f, 0x70, 0x0, 0x2d, 0xff,
    0xf6, 0x3, 0xef, 0xff, 0xa1, 0x0, 0x3, 0xfe,
    0x10, 0x0, 0x2, 0x30, 0x0, 0x0, 0x23, 0x10,
    0x0, 0x0, 0xa, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1e, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2e, 0xfc, 0x40, 0x0, 0x0, 0x1,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1b, 0xff,
    0xea, 0x98, 0x9c, 0xff, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0x9e, 0xff, 0xff, 0xfb, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x12, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+41 "A" */
    0x0, 0x0, 0x0, 0x2, 0xee, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xff, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xfd,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xb6, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xff, 0x51, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xff, 0x0, 0xbf, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xf9, 0x0, 0x5f, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xf4, 0x0, 0xe, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xe0, 0x0, 0x9, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0xef, 0x80, 0x0, 0x4,
    0xff, 0x40, 0x0, 0x0, 0x5, 0xff, 0x20, 0x0,
    0x0, 0xdf, 0xa0, 0x0, 0x0, 0xb, 0xfe, 0x55,
    0x55, 0x55, 0xbf, 0xf0, 0x0, 0x0, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x8f,
    0xfc, 0xcc, 0xcc, 0xcc, 0xce, 0xfc, 0x0, 0x0,
    0xef, 0xb0, 0x0, 0x0, 0x0, 0x7, 0xff, 0x20,
    0x4, 0xff, 0x50, 0x0, 0x0, 0x0, 0x1, 0xff,
    0x80, 0xa, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xe0, 0x1f, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xf5, 0x6f, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xfb,

    /* U+42 "B" */
    0xae, 0xee, 0xee, 0xed, 0xc9, 0x40, 0x0, 0xaf,
    0xff, 0xff, 0xff, 0xff, 0xfa, 0x0, 0xaf, 0xf4,
    0x44, 0x45, 0x7d, 0xff, 0x90, 0xaf, 0xe0, 0x0,
    0x0, 0x0, 0xdf, 0xf0, 0xaf, 0xe0, 0x0, 0x0,
    0x0, 0x7f, 0xf4, 0xaf, 0xe0, 0x0, 0x0, 0x0,
    0x5f, 0xf4, 0xaf, 0xe0, 0x0, 0x0, 0x0, 0x8f,
    0xf2, 0xaf, 0xe0, 0x0, 0x0, 0x3, 0xff, 0xb0,
    0xaf, 0xf6, 0x66, 0x68, 0xbf, 0xfc, 0x10, 0xaf,
    0xff, 0xff, 0xff, 0xff, 0xc0, 0x0, 0xaf, 0xfa,
    0xaa, 0xab, 0xdf, 0xfe, 0x30, 0xaf, 0xe0, 0x0,
    0x0, 0x2, 0xcf, 0xf1, 0xaf, 0xe0, 0x0, 0x0,
    0x0, 0x2f, 0xf8, 0xaf, 0xe0, 0x0, 0x0, 0x0,
    0xe, 0xfb, 0xaf, 0xe0, 0x0, 0x0, 0x0, 0xd,
    0xfd, 0xaf, 0xe0, 0x0, 0x0, 0x0, 0xf, 0xfb,
    0xaf, 0xe0, 0x0, 0x0, 0x0, 0x8f, 0xf7, 0xaf,
    0xf2, 0x22, 0x22, 0x5b, 0xff, 0xe0, 0xaf, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x20, 0xaf, 0xff, 0xff,
    0xff, 0xeb, 0x60, 0x0,

    /* U+43 "C" */
    0x0, 0x0, 0x0, 0x1, 0x21, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x19, 0xef, 0xff, 0xfb, 0x40, 0x0,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x0, 0x4f, 0xfe, 0x61, 0x0, 0x4c, 0xff, 0x70,
    0x1, 0xef, 0xe2, 0x0, 0x0, 0x0, 0xcf, 0xf2,
    0x7, 0xff, 0x40, 0x0, 0x0, 0x0, 0x3f, 0xf8,
    0xd, 0xfd, 0x0, 0x0, 0x0, 0x0, 0xe, 0xfc,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5, 0x76,
    0x4f, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x3, 0x54,
    0xe, 0xfc, 0x0, 0x0, 0x0, 0x0, 0xe, 0xfc,
    0x8, 0xff, 0x30, 0x0, 0x0, 0x0, 0x2f, 0xf8,
    0x1, 0xff, 0xd0, 0x0, 0x0, 0x0, 0xbf, 0xf2,
    0x0, 0x6f, 0xfd, 0x40, 0x0, 0x3b, 0xff, 0x80,
    0x0, 0x7, 0xff, 0xff, 0xef, 0xff, 0xf9, 0x0,
    0x0, 0x0, 0x3b, 0xff, 0xff, 0xfc, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x42, 0x0, 0x0, 0x0,

    /* U+44 "D" */
    0xae, 0xee, 0xee, 0xdc, 0x83, 0x0, 0x0, 0xa,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x20, 0x0, 0xaf,
    0xf4, 0x44, 0x46, 0xbf, 0xfe, 0x30, 0xa, 0xfe,
    0x0, 0x0, 0x0, 0x4f, 0xfd, 0x10, 0xaf, 0xe0,
    0x0, 0x0, 0x0, 0x4f, 0xf8, 0xa, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0xf0, 0xaf, 0xe0, 0x0,
    0x0, 0x0, 0x4, 0xff, 0x4a, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xf8, 0xaf, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xaa, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xfb, 0xaf, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0xef, 0xba, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xfa, 0xaf, 0xe0, 0x0, 0x0, 0x0, 0x1,
    0xff, 0x8a, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xf5, 0xaf, 0xe0, 0x0, 0x0, 0x0, 0xa, 0xff,
    0x1a, 0xfe, 0x0, 0x0, 0x0, 0x4, 0xff, 0x90,
    0xaf, 0xe0, 0x0, 0x0, 0x4, 0xef, 0xe1, 0xa,
    0xff, 0x22, 0x23, 0x5b, 0xff, 0xf4, 0x0, 0xaf,
    0xff, 0xff, 0xff, 0xff, 0xc2, 0x0, 0xa, 0xff,
    0xff, 0xfe, 0xd9, 0x40, 0x0, 0x0,

    /* U+45 "E" */
    0x9e, 0xee, 0xee, 0xee, 0xee, 0xee, 0xcb, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0xbf, 0xf4, 0x44,
    0x44, 0x44, 0x44, 0x3b, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xf5, 0x55, 0x55,
    0x55, 0x53, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x90, 0xbf, 0xfc, 0xcc, 0xcc, 0xcc, 0xc7, 0xb,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff,
    0x22, 0x22, 0x22, 0x22, 0x22, 0xbf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff,

    /* U+46 "F" */
    0x9e, 0xee, 0xee, 0xee, 0xee, 0xee, 0x9b, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfa, 0xbf, 0xf4, 0x44,
    0x44, 0x44, 0x44, 0x2b, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x40, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xb,
    0xff, 0x33, 0x33, 0x33, 0x33, 0x0, 0xbf, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+47 "G" */
    0x0, 0x0, 0x0, 0x1, 0x22, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0x9e, 0xff, 0xff, 0xc5, 0x0,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x0, 0x0, 0x5, 0xff, 0xe6, 0x10, 0x4, 0xbf,
    0xfa, 0x0, 0x1, 0xff, 0xe1, 0x0, 0x0, 0x0,
    0xaf, 0xf4, 0x0, 0x7f, 0xf4, 0x0, 0x0, 0x0,
    0x1, 0xff, 0xa0, 0xd, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xed, 0x1, 0xff, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xff, 0x50,
    0x0, 0x3, 0xee, 0xee, 0xee, 0xe0, 0x4f, 0xf5,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0x3, 0xff,
    0x60, 0x0, 0x0, 0x33, 0x33, 0xaf, 0xf0, 0xf,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0x0,
    0xcf, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xf0,
    0x6, 0xff, 0x60, 0x0, 0x0, 0x0, 0x9, 0xff,
    0x0, 0xd, 0xff, 0x30, 0x0, 0x0, 0x0, 0xaf,
    0xf0, 0x0, 0x3f, 0xff, 0x71, 0x0, 0x3, 0xaf,
    0xfd, 0x0, 0x0, 0x3e, 0xff, 0xfe, 0xef, 0xff,
    0xfc, 0x10, 0x0, 0x0, 0x18, 0xef, 0xff, 0xff,
    0xb5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x23, 0x32,
    0x0, 0x0, 0x0,

    /* U+48 "H" */
    0x9e, 0xd0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xe8,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf5, 0x55, 0x55, 0x55, 0x55, 0x5f, 0xf9,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0xbf, 0xfc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,

    /* U+49 "I" */
    0x7e, 0xe1, 0x8f, 0xf2, 0x8f, 0xf2, 0x8f, 0xf2,
    0x8f, 0xf2, 0x8f, 0xf2, 0x8f, 0xf2, 0x8f, 0xf2,
    0x8f, 0xf2, 0x8f, 0xf2, 0x8f, 0xf2, 0x8f, 0xf2,
    0x8f, 0xf2, 0x8f, 0xf2, 0x8f, 0xf2, 0x8f, 0xf2,
    0x8f, 0xf2, 0x8f, 0xf2, 0x8f, 0xf2, 0x8f, 0xf2,

    /* U+4A "J" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5e, 0xe4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xf4, 0x17, 0x72, 0x0, 0x0, 0x0, 0x5f,
    0xf4, 0x3f, 0xf7, 0x0, 0x0, 0x0, 0x8f, 0xf2,
    0xf, 0xfc, 0x0, 0x0, 0x0, 0xef, 0xe0, 0x9,
    0xff, 0xb2, 0x0, 0x2c, 0xff, 0x70, 0x0, 0xcf,
    0xff, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x7, 0xef,
    0xff, 0xfd, 0x60, 0x0, 0x0, 0x0, 0x2, 0x33,
    0x10, 0x0, 0x0,

    /* U+4B "K" */
    0xae, 0xd0, 0x0, 0x0, 0x0, 0x9, 0xee, 0x80,
    0xaf, 0xe0, 0x0, 0x0, 0x0, 0x7f, 0xfb, 0x0,
    0xaf, 0xe0, 0x0, 0x0, 0x5, 0xff, 0xc0, 0x0,
    0xaf, 0xe0, 0x0, 0x0, 0x4f, 0xfd, 0x10, 0x0,
    0xaf, 0xe0, 0x0, 0x3, 0xff, 0xe2, 0x0, 0x0,
    0xaf, 0xe0, 0x0, 0x2e, 0xff, 0x30, 0x0, 0x0,
    0xaf, 0xe0, 0x1, 0xdf, 0xf4, 0x0, 0x0, 0x0,
    0xaf, 0xe0, 0xd, 0xff, 0x50, 0x0, 0x0, 0x0,
    0xaf, 0xe0, 0xbf, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0xfa, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0, 0x0,
    0xaf, 0xff, 0xa2, 0xef, 0xf2, 0x0, 0x0, 0x0,
    0xaf, 0xfa, 0x0, 0x4f, 0xfd, 0x0, 0x0, 0x0,
    0xaf, 0xf0, 0x0, 0x8, 0xff, 0x90, 0x0, 0x0,
    0xaf, 0xe0, 0x0, 0x0, 0xbf, 0xf6, 0x0, 0x0,
    0xaf, 0xe0, 0x0, 0x0, 0x1e, 0xff, 0x30, 0x0,
    0xaf, 0xe0, 0x0, 0x0, 0x4, 0xff, 0xd0, 0x0,
    0xaf, 0xe0, 0x0, 0x0, 0x0, 0x7f, 0xfa, 0x0,
    0xaf, 0xe0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x60,
    0xaf, 0xe0, 0x0, 0x0, 0x0, 0x1, 0xdf, 0xf3,

    /* U+4C "L" */
    0x9e, 0xd0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff,
    0x22, 0x22, 0x22, 0x22, 0x20, 0xbf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x6b, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf6,

    /* U+4D "M" */
    0xae, 0xed, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6e, 0xee, 0x1a, 0xff, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xff, 0xf2, 0xaf, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff, 0x2a,
    0xff, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0xf2, 0xaf, 0xcf, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xfc, 0xff, 0x2a, 0xfb, 0xaf, 0xd0,
    0x0, 0x0, 0x0, 0x7, 0xff, 0x6f, 0xf2, 0xaf,
    0xc4, 0xff, 0x40, 0x0, 0x0, 0x0, 0xdf, 0xa5,
    0xff, 0x2a, 0xfc, 0xd, 0xfa, 0x0, 0x0, 0x0,
    0x4f, 0xf4, 0x5f, 0xf2, 0xaf, 0xd0, 0x7f, 0xf1,
    0x0, 0x0, 0xa, 0xfd, 0x6, 0xff, 0x2a, 0xfd,
    0x1, 0xff, 0x70, 0x0, 0x1, 0xff, 0x70, 0x6f,
    0xf2, 0xaf, 0xe0, 0xa, 0xfd, 0x0, 0x0, 0x7f,
    0xf1, 0x7, 0xff, 0x2a, 0xfe, 0x0, 0x4f, 0xf4,
    0x0, 0xd, 0xfa, 0x0, 0x7f, 0xf2, 0xaf, 0xe0,
    0x0, 0xdf, 0xa0, 0x4, 0xff, 0x30, 0x7, 0xff,
    0x2a, 0xfe, 0x0, 0x7, 0xff, 0x10, 0xaf, 0xd0,
    0x0, 0x8f, 0xf2, 0xaf, 0xe0, 0x0, 0x1f, 0xf7,
    0x1f, 0xf6, 0x0, 0x8, 0xff, 0x2a, 0xfe, 0x0,
    0x0, 0x9f, 0xd7, 0xff, 0x10, 0x0, 0x8f, 0xf2,
    0xaf, 0xe0, 0x0, 0x3, 0xff, 0xff, 0x90, 0x0,
    0x8, 0xff, 0x2a, 0xfe, 0x0, 0x0, 0xc, 0xff,
    0xf3, 0x0, 0x0, 0x8f, 0xf2, 0xaf, 0xe0, 0x0,
    0x0, 0x6f, 0xfd, 0x0, 0x0, 0x8, 0xff, 0x2a,
    0xfe, 0x0, 0x0, 0x0, 0xff, 0x60, 0x0, 0x0,
    0x8f, 0xf2,

    /* U+4E "N" */
    0xae, 0xe3, 0x0, 0x0, 0x0, 0x0, 0xe, 0xe9,
    0xaf, 0xfd, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xaf, 0xff, 0x80, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xaf, 0xff, 0xf3, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xaf, 0xff, 0xfc, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xaf, 0xf7, 0xff, 0x70, 0x0, 0x0, 0xf, 0xf9,
    0xaf, 0xf0, 0xcf, 0xf2, 0x0, 0x0, 0xf, 0xf9,
    0xaf, 0xf0, 0x3f, 0xfc, 0x0, 0x0, 0xf, 0xf9,
    0xaf, 0xf0, 0x8, 0xff, 0x60, 0x0, 0xf, 0xf9,
    0xaf, 0xf0, 0x0, 0xdf, 0xf2, 0x0, 0xf, 0xf9,
    0xaf, 0xf0, 0x0, 0x3f, 0xfb, 0x0, 0xf, 0xf9,
    0xaf, 0xf0, 0x0, 0x9, 0xff, 0x60, 0xf, 0xf9,
    0xaf, 0xf0, 0x0, 0x0, 0xdf, 0xf1, 0xf, 0xf9,
    0xaf, 0xf0, 0x0, 0x0, 0x4f, 0xfb, 0xf, 0xf9,
    0xaf, 0xf0, 0x0, 0x0, 0x9, 0xff, 0x5f, 0xf9,
    0xaf, 0xf0, 0x0, 0x0, 0x1, 0xef, 0xef, 0xf9,
    0xaf, 0xf0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xf9,
    0xaf, 0xf0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xf9,
    0xaf, 0xf0, 0x0, 0x0, 0x0, 0x1, 0xef, 0xf9,
    0xaf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf9,

    /* U+4F "O" */
    0x0, 0x0, 0x0, 0x1, 0x21, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x8e, 0xff, 0xff, 0xa3, 0x0,
    0x0, 0x0, 0x4, 0xef, 0xff, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0x3, 0xff, 0xf8, 0x31, 0x26, 0xef,
    0xf7, 0x0, 0x0, 0xdf, 0xe3, 0x0, 0x0, 0x0,
    0xcf, 0xf3, 0x0, 0x6f, 0xf5, 0x0, 0x0, 0x0,
    0x2, 0xff, 0xa0, 0xc, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xff, 0x11, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xf4, 0x4f, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xff, 0x75, 0xff, 0x40, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xf8, 0x6f, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0x96, 0xff, 0x30,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf9, 0x5f, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x94, 0xff,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x1f,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0x50,
    0xdf, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xf1,
    0x7, 0xff, 0x50, 0x0, 0x0, 0x0, 0x1e, 0xfb,
    0x0, 0xe, 0xfe, 0x20, 0x0, 0x0, 0xb, 0xff,
    0x30, 0x0, 0x4f, 0xfe, 0x61, 0x0, 0x4c, 0xff,
    0x90, 0x0, 0x0, 0x5f, 0xff, 0xff, 0xff, 0xff,
    0x90, 0x0, 0x0, 0x0, 0x19, 0xef, 0xff, 0xfb,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x23, 0x21,
    0x0, 0x0, 0x0,

    /* U+50 "P" */
    0xae, 0xee, 0xee, 0xee, 0xdb, 0x71, 0x0, 0xa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0, 0xaf,
    0xf4, 0x44, 0x44, 0x58, 0xff, 0xf6, 0xa, 0xfe,
    0x0, 0x0, 0x0, 0x2, 0xef, 0xf1, 0xaf, 0xe0,
    0x0, 0x0, 0x0, 0x5, 0xff, 0x6a, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0xf8, 0xaf, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0x9a, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xf7, 0xaf, 0xe0, 0x0, 0x0,
    0x0, 0xa, 0xff, 0x3a, 0xfe, 0x0, 0x0, 0x0,
    0x3a, 0xff, 0xb0, 0xaf, 0xfe, 0xee, 0xee, 0xff,
    0xff, 0xd1, 0xa, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x70, 0x0, 0xaf, 0xf3, 0x33, 0x33, 0x20, 0x0,
    0x0, 0xa, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+51 "Q" */
    0x0, 0x0, 0x0, 0x1, 0x21, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x9e, 0xff, 0xfe, 0x92, 0x0,
    0x0, 0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0x0, 0x0, 0x5, 0xff, 0xf7, 0x31, 0x27, 0xef,
    0xf6, 0x0, 0x1, 0xef, 0xe2, 0x0, 0x0, 0x1,
    0xdf, 0xf1, 0x0, 0x8f, 0xf4, 0x0, 0x0, 0x0,
    0x3, 0xff, 0x80, 0xe, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xfe, 0x2, 0xff, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xf2, 0x6f, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0x57, 0xff, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xf7, 0x8f, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xff, 0x88, 0xff, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf8, 0x7f, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xff, 0x76, 0xff,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xf5, 0x3f,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0x30,
    0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xe0,
    0x9, 0xff, 0x30, 0x0, 0x0, 0x0, 0x2f, 0xfa,
    0x0, 0x2f, 0xfd, 0x10, 0x0, 0x0, 0xc, 0xff,
    0x20, 0x0, 0x6f, 0xfe, 0x51, 0x1, 0x5d, 0xff,
    0x70, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xff, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x2a, 0xff, 0xff, 0xff,
    0xfb, 0x10, 0x0, 0x0, 0x0, 0x0, 0x23, 0x21,
    0xbf, 0xfd, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x20, 0x0,

    /* U+52 "R" */
    0xae, 0xee, 0xee, 0xed, 0xc9, 0x40, 0x0, 0xb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb1, 0x0, 0xbf,
    0xf4, 0x44, 0x44, 0x7d, 0xff, 0xc0, 0xb, 0xfe,
    0x0, 0x0, 0x0, 0xa, 0xff, 0x60, 0xbf, 0xe0,
    0x0, 0x0, 0x0, 0x1f, 0xfb, 0xb, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xd0, 0xbf, 0xe0, 0x0,
    0x0, 0x0, 0xd, 0xfc, 0xb, 0xfe, 0x0, 0x0,
    0x0, 0x1, 0xff, 0xa0, 0xbf, 0xe0, 0x0, 0x0,
    0x0, 0xaf, 0xf4, 0xb, 0xff, 0x33, 0x33, 0x36,
    0xcf, 0xfa, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0xb, 0xff, 0xee, 0xee, 0xff, 0xf5,
    0x0, 0x0, 0xbf, 0xe0, 0x0, 0x1, 0xff, 0xb0,
    0x0, 0xb, 0xfe, 0x0, 0x0, 0x8, 0xff, 0x40,
    0x0, 0xbf, 0xe0, 0x0, 0x0, 0x1f, 0xfc, 0x0,
    0xb, 0xfe, 0x0, 0x0, 0x0, 0x7f, 0xf5, 0x0,
    0xbf, 0xe0, 0x0, 0x0, 0x0, 0xef, 0xe0, 0xb,
    0xfe, 0x0, 0x0, 0x0, 0x6, 0xff, 0x70, 0xbf,
    0xe0, 0x0, 0x0, 0x0, 0xd, 0xfe, 0x1b, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xf8,

    /* U+53 "S" */
    0x0, 0x0, 0x0, 0x12, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x3a, 0xff, 0xff, 0xea, 0x20, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0x70, 0x0, 0x6f,
    0xfd, 0x51, 0x1, 0x5d, 0xff, 0x60, 0xe, 0xfd,
    0x10, 0x0, 0x0, 0xd, 0xfe, 0x3, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x5f, 0xf5, 0x4f, 0xf7, 0x0,
    0x0, 0x0, 0x2, 0xdd, 0x61, 0xff, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xb2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1d, 0xff, 0xfa, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x19, 0xff, 0xff, 0xfa,
    0x40, 0x0, 0x0, 0x0, 0x2, 0x8e, 0xff, 0xff,
    0xc3, 0x0, 0x0, 0x0, 0x0, 0x3, 0x9e, 0xff,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff,
    0x5a, 0xb9, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xf8,
    0xbf, 0xe0, 0x0, 0x0, 0x0, 0x2, 0xff, 0x85,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x8f, 0xf4, 0xb,
    0xff, 0xa3, 0x0, 0x2, 0x9f, 0xfc, 0x0, 0xb,
    0xff, 0xff, 0xef, 0xff, 0xfd, 0x20, 0x0, 0x4,
    0xbf, 0xff, 0xff, 0xd7, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x33, 0x10, 0x0, 0x0,

    /* U+54 "T" */
    0x4e, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee,
    0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf1, 0x14, 0x44, 0x44, 0x4f, 0xfc, 0x44, 0x44,
    0x44, 0x0, 0x0, 0x0, 0x0, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xa0, 0x0,
    0x0, 0x0,

    /* U+55 "U" */
    0x1e, 0xe7, 0x0, 0x0, 0x0, 0x0, 0x4e, 0xe4,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0xf, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xf3,
    0xd, 0xfd, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xf1,
    0x8, 0xff, 0x60, 0x0, 0x0, 0x3, 0xff, 0xb0,
    0x0, 0xef, 0xf8, 0x10, 0x0, 0x6e, 0xff, 0x20,
    0x0, 0x2e, 0xff, 0xfe, 0xef, 0xff, 0xf4, 0x0,
    0x0, 0x1, 0x8e, 0xff, 0xff, 0xe9, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x23, 0x32, 0x0, 0x0, 0x0,

    /* U+56 "V" */
    0x6e, 0xe5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8e,
    0xe4, 0x1f, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xe0, 0xb, 0xff, 0x10, 0x0, 0x0, 0x0,
    0x3, 0xff, 0x80, 0x5, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x9, 0xff, 0x30, 0x0, 0xef, 0xc0, 0x0,
    0x0, 0x0, 0xe, 0xfd, 0x0, 0x0, 0x9f, 0xf1,
    0x0, 0x0, 0x0, 0x4f, 0xf7, 0x0, 0x0, 0x3f,
    0xf7, 0x0, 0x0, 0x0, 0xaf, 0xf1, 0x0, 0x0,
    0xd, 0xfc, 0x0, 0x0, 0x0, 0xff, 0xb0, 0x0,
    0x0, 0x8, 0xff, 0x20, 0x0, 0x5, 0xff, 0x50,
    0x0, 0x0, 0x2, 0xff, 0x70, 0x0, 0xa, 0xff,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xd0, 0x0, 0xf,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xf2, 0x0,
    0x5f, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf8,
    0x0, 0xbf, 0xd0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xfd, 0x1, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xff, 0x36, 0xff, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0x8b, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0xef, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff,
    0x40, 0x0, 0x0, 0x0,

    /* U+57 "W" */
    0x1e, 0xe8, 0x0, 0x0, 0x0, 0x9, 0xec, 0x0,
    0x0, 0x0, 0x7, 0xee, 0x10, 0xdf, 0xc0, 0x0,
    0x0, 0x0, 0xef, 0xf1, 0x0, 0x0, 0x0, 0xbf,
    0xe0, 0x9, 0xff, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0x50, 0x0, 0x0, 0xe, 0xfa, 0x0, 0x5f, 0xf3,
    0x0, 0x0, 0x7, 0xff, 0xfa, 0x0, 0x0, 0x2,
    0xff, 0x60, 0x1, 0xff, 0x70, 0x0, 0x0, 0xcf,
    0xcf, 0xe0, 0x0, 0x0, 0x6f, 0xf2, 0x0, 0xd,
    0xfb, 0x0, 0x0, 0x1f, 0xf5, 0xff, 0x30, 0x0,
    0x9, 0xfe, 0x0, 0x0, 0x9f, 0xe0, 0x0, 0x5,
    0xff, 0xc, 0xf7, 0x0, 0x0, 0xdf, 0xa0, 0x0,
    0x6, 0xff, 0x20, 0x0, 0x9f, 0xb0, 0x8f, 0xc0,
    0x0, 0x1f, 0xf7, 0x0, 0x0, 0x2f, 0xf6, 0x0,
    0xe, 0xf6, 0x3, 0xff, 0x0, 0x4, 0xff, 0x30,
    0x0, 0x0, 0xef, 0xa0, 0x2, 0xff, 0x20, 0xe,
    0xf4, 0x0, 0x8f, 0xf0, 0x0, 0x0, 0xa, 0xfd,
    0x0, 0x7f, 0xd0, 0x0, 0xaf, 0x90, 0xc, 0xfb,
    0x0, 0x0, 0x0, 0x6f, 0xf1, 0xb, 0xf8, 0x0,
    0x6, 0xfd, 0x0, 0xff, 0x70, 0x0, 0x0, 0x2,
    0xff, 0x50, 0xff, 0x30, 0x0, 0x1f, 0xf2, 0x3f,
    0xf3, 0x0, 0x0, 0x0, 0xe, 0xf8, 0x5f, 0xe0,
    0x0, 0x0, 0xdf, 0x66, 0xff, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xb9, 0xfa, 0x0, 0x0, 0x8, 0xfa,
    0x9f, 0xb0, 0x0, 0x0, 0x0, 0x7, 0xfd, 0xdf,
    0x50, 0x0, 0x0, 0x4f, 0xec, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xf1, 0x0, 0x0, 0x0,
    0xff, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xfc, 0x0, 0x0, 0x0, 0xb, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0x70, 0x0, 0x0,
    0x0, 0x6f, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xf3, 0x0, 0x0, 0x0, 0x2, 0xff, 0x80,
    0x0, 0x0,

    /* U+58 "X" */
    0xb, 0xee, 0x40, 0x0, 0x0, 0x0, 0xa, 0xee,
    0x50, 0x2f, 0xfd, 0x0, 0x0, 0x0, 0x4, 0xff,
    0xc0, 0x0, 0x8f, 0xf8, 0x0, 0x0, 0x0, 0xdf,
    0xf2, 0x0, 0x0, 0xdf, 0xf2, 0x0, 0x0, 0x8f,
    0xf7, 0x0, 0x0, 0x3, 0xff, 0xc0, 0x0, 0x2f,
    0xfd, 0x0, 0x0, 0x0, 0x9, 0xff, 0x60, 0xc,
    0xff, 0x30, 0x0, 0x0, 0x0, 0xe, 0xff, 0x16,
    0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xfb,
    0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xff, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xff, 0xbe, 0xfe, 0x10, 0x0, 0x0, 0x0,
    0x1, 0xef, 0xe1, 0x6f, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0xf6, 0x0, 0xbf, 0xf4, 0x0, 0x0,
    0x0, 0x5f, 0xfc, 0x0, 0x2, 0xff, 0xe0, 0x0,
    0x0, 0xe, 0xff, 0x20, 0x0, 0x8, 0xff, 0x90,
    0x0, 0x9, 0xff, 0x70, 0x0, 0x0, 0xd, 0xff,
    0x30, 0x4, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x3f,
    0xfd, 0x0, 0xdf, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xf7,

    /* U+59 "Y" */
    0x8e, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x9, 0xee,
    0x41, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x2, 0xff,
    0xc0, 0x7, 0xff, 0x70, 0x0, 0x0, 0x0, 0xaf,
    0xf3, 0x0, 0xe, 0xfe, 0x0, 0x0, 0x0, 0x3f,
    0xfa, 0x0, 0x0, 0x6f, 0xf7, 0x0, 0x0, 0xb,
    0xff, 0x20, 0x0, 0x0, 0xcf, 0xf1, 0x0, 0x3,
    0xff, 0x90, 0x0, 0x0, 0x4, 0xff, 0x80, 0x0,
    0xbf, 0xf1, 0x0, 0x0, 0x0, 0xb, 0xff, 0x10,
    0x4f, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xf8,
    0xc, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0xf6, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xff, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xef, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xef, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xa0, 0x0,
    0x0, 0x0,

    /* U+5A "Z" */
    0x9e, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0x3a,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x24,
    0x44, 0x44, 0x44, 0x44, 0x6f, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xff, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xff,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xef, 0xe1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xa2, 0x22, 0x22, 0x22, 0x22, 0x21, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xad, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,

    /* U+5B "[" */
    0xcc, 0xcc, 0xc1, 0xff, 0xff, 0xf2, 0xff, 0xb5,
    0x50, 0xff, 0x80, 0x0, 0xff, 0x80, 0x0, 0xff,
    0x80, 0x0, 0xff, 0x80, 0x0, 0xff, 0x80, 0x0,
    0xff, 0x80, 0x0, 0xff, 0x80, 0x0, 0xff, 0x80,
    0x0, 0xff, 0x80, 0x0, 0xff, 0x80, 0x0, 0xff,
    0x80, 0x0, 0xff, 0x80, 0x0, 0xff, 0x80, 0x0,
    0xff, 0x80, 0x0, 0xff, 0x80, 0x0, 0xff, 0x80,
    0x0, 0xff, 0x80, 0x0, 0xff, 0x80, 0x0, 0xff,
    0x80, 0x0, 0xff, 0x80, 0x0, 0xff, 0x80, 0x0,
    0xff, 0x80, 0x0, 0xff, 0xed, 0xd2, 0xff, 0xff,
    0xf2, 0x44, 0x44, 0x40,

    /* U+5C "\\" */
    0x4e, 0xe1, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xff, 0x40, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x90, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0xff, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x3b, 0xb1,

    /* U+5D "]" */
    0xac, 0xcc, 0xc3, 0xef, 0xff, 0xf4, 0x45, 0x7f,
    0xf4, 0x0, 0x3f, 0xf4, 0x0, 0x3f, 0xf4, 0x0,
    0x3f, 0xf4, 0x0, 0x3f, 0xf4, 0x0, 0x3f, 0xf4,
    0x0, 0x3f, 0xf4, 0x0, 0x3f, 0xf4, 0x0, 0x3f,
    0xf4, 0x0, 0x3f, 0xf4, 0x0, 0x3f, 0xf4, 0x0,
    0x3f, 0xf4, 0x0, 0x3f, 0xf4, 0x0, 0x3f, 0xf4,
    0x0, 0x3f, 0xf4, 0x0, 0x3f, 0xf4, 0x0, 0x3f,
    0xf4, 0x0, 0x3f, 0xf4, 0x0, 0x3f, 0xf4, 0x0,
    0x3f, 0xf4, 0x0, 0x3f, 0xf4, 0x0, 0x3f, 0xf4,
    0x0, 0x3f, 0xf4, 0xbd, 0xdf, 0xf4, 0xef, 0xff,
    0xf4, 0x34, 0x44, 0x41,

    /* U+5E "^" */
    0x0, 0x0, 0x3e, 0xd0, 0x0, 0x0, 0x0, 0x9,
    0xff, 0x40, 0x0, 0x0, 0x1, 0xff, 0xfb, 0x0,
    0x0, 0x0, 0x6f, 0xef, 0xf1, 0x0, 0x0, 0xd,
    0xf6, 0xcf, 0x80, 0x0, 0x4, 0xff, 0x15, 0xfe,
    0x0, 0x0, 0xaf, 0x90, 0xe, 0xf5, 0x0, 0x1f,
    0xf3, 0x0, 0x9f, 0xb0, 0x7, 0xfd, 0x0, 0x2,
    0xff, 0x20, 0xef, 0x70, 0x0, 0xc, 0xf9,

    /* U+5F "_" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf9, 0x1, 0x11, 0x11,
    0x11, 0x11, 0x11, 0x0,

    /* U+60 "`" */
    0xc, 0xff, 0x20, 0x0, 0x1d, 0xfc, 0x0, 0x0,
    0x2e, 0xf7, 0x0, 0x0, 0x3f, 0xf2, 0x0, 0x0,
    0x1, 0x0,

    /* U+61 "a" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5b, 0xff, 0xfd, 0x80, 0x0, 0x0, 0xbf, 0xff,
    0xff, 0xff, 0xd1, 0x0, 0x9f, 0xf8, 0x20, 0x18,
    0xff, 0xa0, 0x1f, 0xf9, 0x0, 0x0, 0xa, 0xff,
    0x1, 0x55, 0x10, 0x0, 0x0, 0x6f, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xff, 0x30, 0x0, 0x5a,
    0xde, 0xff, 0xff, 0xf3, 0x1, 0xdf, 0xff, 0xed,
    0xcd, 0xff, 0x30, 0xdf, 0xe6, 0x10, 0x0, 0x5f,
    0xf3, 0x4f, 0xf4, 0x0, 0x0, 0x5, 0xff, 0x37,
    0xff, 0x0, 0x0, 0x0, 0x5f, 0xf3, 0x7f, 0xf3,
    0x0, 0x0, 0xc, 0xff, 0x32, 0xff, 0xd3, 0x0,
    0x4c, 0xff, 0xf3, 0x9, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0x50, 0x7, 0xef, 0xff, 0xd6, 0x1f, 0xf9,
    0x0, 0x0, 0x23, 0x20, 0x0, 0x0, 0x0,

    /* U+62 "b" */
    0x1f, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xf7, 0x2a, 0xff, 0xfb, 0x40,
    0x0, 0x1f, 0xfb, 0xff, 0xff, 0xff, 0xf7, 0x0,
    0x1f, 0xff, 0xe6, 0x22, 0x6e, 0xff, 0x30, 0x1f,
    0xfe, 0x20, 0x0, 0x2, 0xff, 0xb0, 0x1f, 0xf7,
    0x0, 0x0, 0x0, 0x9f, 0xf1, 0x1f, 0xf7, 0x0,
    0x0, 0x0, 0x4f, 0xf4, 0x1f, 0xf7, 0x0, 0x0,
    0x0, 0x3f, 0xf6, 0x1f, 0xf7, 0x0, 0x0, 0x0,
    0x1f, 0xf6, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0x2f,
    0xf6, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0x4f, 0xf4,
    0x1f, 0xf7, 0x0, 0x0, 0x0, 0x8f, 0xf1, 0x1f,
    0xfd, 0x0, 0x0, 0x1, 0xef, 0xc0, 0x1f, 0xff,
    0xc3, 0x0, 0x2c, 0xff, 0x50, 0x1f, 0xfb, 0xff,
    0xfe, 0xff, 0xf9, 0x0, 0x1f, 0xf4, 0x5d, 0xff,
    0xfe, 0x70, 0x0, 0x0, 0x0, 0x0, 0x23, 0x20,
    0x0, 0x0,

    /* U+63 "c" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3a, 0xef, 0xfd, 0x80, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xff, 0xd2, 0x0, 0x5f, 0xfc, 0x30, 0x27,
    0xff, 0xd0, 0xe, 0xfc, 0x0, 0x0, 0x5, 0xff,
    0x55, 0xff, 0x40, 0x0, 0x0, 0xd, 0xf9, 0x8f,
    0xf0, 0x0, 0x0, 0x0, 0x34, 0x3a, 0xfd, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xff, 0x20, 0x0, 0x0, 0x8, 0xa7, 0x1f, 0xfa,
    0x0, 0x0, 0x2, 0xff, 0x70, 0x7f, 0xf8, 0x0,
    0x3, 0xdf, 0xe1, 0x0, 0xaf, 0xff, 0xde, 0xff,
    0xf3, 0x0, 0x0, 0x6d, 0xff, 0xff, 0xa2, 0x0,
    0x0, 0x0, 0x2, 0x33, 0x0, 0x0, 0x0,

    /* U+64 "d" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xfc, 0x0,
    0x5, 0xcf, 0xfe, 0x91, 0xbf, 0xc0, 0x9, 0xff,
    0xff, 0xff, 0xed, 0xfc, 0x6, 0xff, 0xd4, 0x12,
    0x7f, 0xff, 0xc0, 0xef, 0xd0, 0x0, 0x0, 0x4f,
    0xfc, 0x4f, 0xf5, 0x0, 0x0, 0x0, 0xcf, 0xc8,
    0xff, 0x0, 0x0, 0x0, 0xb, 0xfc, 0xaf, 0xe0,
    0x0, 0x0, 0x0, 0xbf, 0xcb, 0xfd, 0x0, 0x0,
    0x0, 0xb, 0xfc, 0xaf, 0xe0, 0x0, 0x0, 0x0,
    0xbf, 0xc8, 0xff, 0x0, 0x0, 0x0, 0xb, 0xfc,
    0x5f, 0xf4, 0x0, 0x0, 0x0, 0xbf, 0xc0, 0xff,
    0xb0, 0x0, 0x0, 0x2f, 0xfc, 0x7, 0xff, 0xa1,
    0x0, 0x4e, 0xff, 0xc0, 0xb, 0xff, 0xfe, 0xff,
    0xfd, 0xfc, 0x0, 0x8, 0xff, 0xff, 0xc3, 0x9f,
    0xc0, 0x0, 0x0, 0x33, 0x10, 0x0, 0x0,

    /* U+65 "e" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x19, 0xef, 0xfd, 0x70, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0xff, 0xc1, 0x0, 0x3f, 0xfd, 0x40, 0x17,
    0xff, 0xa0, 0xc, 0xfe, 0x0, 0x0, 0x7, 0xff,
    0x23, 0xff, 0x50, 0x0, 0x0, 0xf, 0xf7, 0x8f,
    0xf1, 0x0, 0x0, 0x0, 0xcf, 0xba, 0xff, 0xbb,
    0xbb, 0xbb, 0xbe, 0xfc, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xdb, 0xfe, 0x55, 0x55, 0x55, 0x55,
    0x54, 0x9f, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xff, 0x40, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xfc,
    0x0, 0x0, 0x0, 0x37, 0x0, 0x7f, 0xfb, 0x20,
    0x0, 0x6f, 0xf6, 0x0, 0x9f, 0xff, 0xdd, 0xff,
    0xfa, 0x0, 0x0, 0x5c, 0xff, 0xff, 0xd6, 0x0,
    0x0, 0x0, 0x1, 0x33, 0x10, 0x0, 0x0,

    /* U+66 "f" */
    0x0, 0x0, 0x0, 0x13, 0x31, 0x0, 0x0, 0x1b,
    0xff, 0xfb, 0x0, 0x1, 0xdf, 0xff, 0xea, 0x0,
    0x7, 0xff, 0x80, 0x0, 0x0, 0xb, 0xfe, 0x0,
    0x0, 0x0, 0xd, 0xfb, 0x0, 0x0, 0x0, 0xd,
    0xfa, 0x0, 0x0, 0x2c, 0xcf, 0xfe, 0xcc, 0xa0,
    0x2f, 0xff, 0xff, 0xff, 0xd0, 0x2, 0x2d, 0xfb,
    0x22, 0x10, 0x0, 0xd, 0xfa, 0x0, 0x0, 0x0,
    0xd, 0xfa, 0x0, 0x0, 0x0, 0xd, 0xfa, 0x0,
    0x0, 0x0, 0xd, 0xfa, 0x0, 0x0, 0x0, 0xd,
    0xfa, 0x0, 0x0, 0x0, 0xd, 0xfa, 0x0, 0x0,
    0x0, 0xd, 0xfa, 0x0, 0x0, 0x0, 0xd, 0xfa,
    0x0, 0x0, 0x0, 0xd, 0xfa, 0x0, 0x0, 0x0,
    0xd, 0xfa, 0x0, 0x0, 0x0, 0xd, 0xfa, 0x0,
    0x0, 0x0, 0xd, 0xfa, 0x0, 0x0,

    /* U+67 "g" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5c, 0xff, 0xe9, 0x16, 0xca, 0x0, 0x9f, 0xff,
    0xff, 0xfe, 0xbf, 0xc0, 0x6f, 0xfd, 0x51, 0x27,
    0xff, 0xfc, 0xe, 0xfe, 0x10, 0x0, 0x4, 0xff,
    0xc4, 0xff, 0x60, 0x0, 0x0, 0xb, 0xfc, 0x8f,
    0xf1, 0x0, 0x0, 0x0, 0xbf, 0xca, 0xff, 0x0,
    0x0, 0x0, 0xb, 0xfc, 0xaf, 0xd0, 0x0, 0x0,
    0x0, 0xbf, 0xca, 0xff, 0x0, 0x0, 0x0, 0xb,
    0xfc, 0x8f, 0xf0, 0x0, 0x0, 0x0, 0xbf, 0xc5,
    0xff, 0x40, 0x0, 0x0, 0xb, 0xfc, 0xf, 0xfc,
    0x0, 0x0, 0x2, 0xff, 0xc0, 0x7f, 0xfa, 0x10,
    0x4, 0xef, 0xfc, 0x0, 0xbf, 0xff, 0xef, 0xff,
    0xef, 0xc0, 0x0, 0x8f, 0xff, 0xfc, 0x3b, 0xfc,
    0x0, 0x0, 0x3, 0x31, 0x0, 0xcf, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0xf9, 0x4, 0xe3, 0x0,
    0x0, 0x9, 0xff, 0x30, 0xaf, 0xfa, 0x54, 0x6c,
    0xff, 0xa0, 0x0, 0x9f, 0xff, 0xff, 0xff, 0xa0,
    0x0, 0x0, 0x27, 0xbc, 0xb8, 0x30, 0x0,

    /* U+68 "h" */
    0x1f, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xff, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xf7, 0x18, 0xef, 0xfd, 0x60, 0x1, 0xff, 0x9e,
    0xff, 0xff, 0xff, 0x80, 0x1f, 0xff, 0xe7, 0x22,
    0x6e, 0xff, 0x11, 0xff, 0xf2, 0x0, 0x0, 0x5f,
    0xf5, 0x1f, 0xf8, 0x0, 0x0, 0x1, 0xff, 0x71,
    0xff, 0x70, 0x0, 0x0, 0xf, 0xf8, 0x1f, 0xf7,
    0x0, 0x0, 0x0, 0xff, 0x81, 0xff, 0x70, 0x0,
    0x0, 0xf, 0xf8, 0x1f, 0xf7, 0x0, 0x0, 0x0,
    0xff, 0x81, 0xff, 0x70, 0x0, 0x0, 0xf, 0xf8,
    0x1f, 0xf7, 0x0, 0x0, 0x0, 0xff, 0x81, 0xff,
    0x70, 0x0, 0x0, 0xf, 0xf8, 0x1f, 0xf7, 0x0,
    0x0, 0x0, 0xff, 0x81, 0xff, 0x70, 0x0, 0x0,
    0xf, 0xf8, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0xff,
    0x80,

    /* U+69 "i" */
    0x0, 0x20, 0xc, 0xfa, 0xf, 0xfd, 0x6, 0xa4,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xc8, 0xd, 0xfa,
    0xd, 0xfa, 0xd, 0xfa, 0xd, 0xfa, 0xd, 0xfa,
    0xd, 0xfa, 0xd, 0xfa, 0xd, 0xfa, 0xd, 0xfa,
    0xd, 0xfa, 0xd, 0xfa, 0xd, 0xfa, 0xd, 0xfa,
    0xd, 0xfa,

    /* U+6A "j" */
    0x0, 0x0, 0x20, 0x0, 0x1e, 0xf7, 0x0, 0x3f,
    0xfa, 0x0, 0x8, 0xa2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xc6, 0x0, 0xf, 0xf8,
    0x0, 0xf, 0xf8, 0x0, 0xf, 0xf8, 0x0, 0xf,
    0xf8, 0x0, 0xf, 0xf8, 0x0, 0xf, 0xf8, 0x0,
    0xf, 0xf8, 0x0, 0xf, 0xf8, 0x0, 0xf, 0xf8,
    0x0, 0xf, 0xf8, 0x0, 0xf, 0xf8, 0x0, 0xf,
    0xf8, 0x0, 0xf, 0xf8, 0x0, 0xf, 0xf8, 0x0,
    0xf, 0xf8, 0x0, 0xf, 0xf8, 0x0, 0x1f, 0xf6,
    0x33, 0xaf, 0xf4, 0xef, 0xff, 0xc0, 0xbe, 0xe9,
    0x10,

    /* U+6B "k" */
    0x1f, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xf7, 0x0, 0x0, 0xb, 0xcc,
    0x20, 0x1f, 0xf7, 0x0, 0x0, 0xcf, 0xf5, 0x0,
    0x1f, 0xf7, 0x0, 0xb, 0xff, 0x60, 0x0, 0x1f,
    0xf7, 0x0, 0xaf, 0xf7, 0x0, 0x0, 0x1f, 0xf7,
    0x9, 0xff, 0x70, 0x0, 0x0, 0x1f, 0xf7, 0x8f,
    0xf9, 0x0, 0x0, 0x0, 0x1f, 0xfc, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x1f, 0xff, 0xbb, 0xff, 0x50, 0x0,
    0x0, 0x1f, 0xfb, 0x1, 0xdf, 0xe2, 0x0, 0x0,
    0x1f, 0xf7, 0x0, 0x3f, 0xfc, 0x0, 0x0, 0x1f,
    0xf7, 0x0, 0x6, 0xff, 0x80, 0x0, 0x1f, 0xf7,
    0x0, 0x0, 0xaf, 0xf5, 0x0, 0x1f, 0xf7, 0x0,
    0x0, 0x1d, 0xfe, 0x20, 0x1f, 0xf7, 0x0, 0x0,
    0x2, 0xff, 0xc0,

    /* U+6C "l" */
    0xdf, 0xad, 0xfa, 0xdf, 0xad, 0xfa, 0xdf, 0xad,
    0xfa, 0xdf, 0xad, 0xfa, 0xdf, 0xad, 0xfa, 0xdf,
    0xad, 0xfa, 0xdf, 0xad, 0xfa, 0xdf, 0xad, 0xfa,
    0xdf, 0xad, 0xfa, 0xdf, 0xad, 0xfa, 0xdf, 0xa0,

    /* U+6D "m" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1c, 0xc4, 0x2a, 0xef, 0xfc,
    0x50, 0x2, 0xae, 0xff, 0xd6, 0x0, 0x1f, 0xfa,
    0xff, 0xff, 0xff, 0xf6, 0x5f, 0xff, 0xff, 0xff,
    0x90, 0x1f, 0xff, 0xc4, 0x12, 0x7f, 0xff, 0xfe,
    0x62, 0x25, 0xef, 0xf2, 0x1f, 0xfd, 0x0, 0x0,
    0x7, 0xff, 0xf3, 0x0, 0x0, 0x4f, 0xf7, 0x1f,
    0xf7, 0x0, 0x0, 0x1, 0xff, 0xb0, 0x0, 0x0,
    0xf, 0xf9, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0xff,
    0x80, 0x0, 0x0, 0xe, 0xfa, 0x1f, 0xf7, 0x0,
    0x0, 0x0, 0xff, 0x80, 0x0, 0x0, 0xe, 0xfa,
    0x1f, 0xf7, 0x0, 0x0, 0x0, 0xff, 0x80, 0x0,
    0x0, 0xe, 0xfa, 0x1f, 0xf7, 0x0, 0x0, 0x0,
    0xff, 0x80, 0x0, 0x0, 0xe, 0xfa, 0x1f, 0xf7,
    0x0, 0x0, 0x0, 0xff, 0x80, 0x0, 0x0, 0xe,
    0xfa, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0xff, 0x80,
    0x0, 0x0, 0xe, 0xfa, 0x1f, 0xf7, 0x0, 0x0,
    0x0, 0xff, 0x80, 0x0, 0x0, 0xe, 0xfa, 0x1f,
    0xf7, 0x0, 0x0, 0x0, 0xff, 0x80, 0x0, 0x0,
    0xe, 0xfa, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0xff,
    0x80, 0x0, 0x0, 0xe, 0xfa, 0x1f, 0xf7, 0x0,
    0x0, 0x0, 0xff, 0x80, 0x0, 0x0, 0xe, 0xfa,

    /* U+6E "n" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xcc,
    0x41, 0x8e, 0xff, 0xd6, 0x0, 0x1f, 0xf8, 0xef,
    0xff, 0xff, 0xf8, 0x1, 0xff, 0xfe, 0x72, 0x26,
    0xef, 0xf1, 0x1f, 0xff, 0x20, 0x0, 0x5, 0xff,
    0x51, 0xff, 0x80, 0x0, 0x0, 0x1f, 0xf7, 0x1f,
    0xf7, 0x0, 0x0, 0x0, 0xff, 0x81, 0xff, 0x70,
    0x0, 0x0, 0xf, 0xf8, 0x1f, 0xf7, 0x0, 0x0,
    0x0, 0xff, 0x81, 0xff, 0x70, 0x0, 0x0, 0xf,
    0xf8, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0xff, 0x81,
    0xff, 0x70, 0x0, 0x0, 0xf, 0xf8, 0x1f, 0xf7,
    0x0, 0x0, 0x0, 0xff, 0x81, 0xff, 0x70, 0x0,
    0x0, 0xf, 0xf8, 0x1f, 0xf7, 0x0, 0x0, 0x0,
    0xff, 0x81, 0xff, 0x70, 0x0, 0x0, 0xf, 0xf8,

    /* U+6F "o" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x9e, 0xff, 0xe9, 0x10, 0x0, 0x0, 0x5f,
    0xff, 0xff, 0xff, 0xf4, 0x0, 0x3, 0xff, 0xd5,
    0x11, 0x5e, 0xff, 0x30, 0xd, 0xfe, 0x10, 0x0,
    0x1, 0xef, 0xc0, 0x4f, 0xf6, 0x0, 0x0, 0x0,
    0x6f, 0xf3, 0x8f, 0xf0, 0x0, 0x0, 0x0, 0x1f,
    0xf7, 0xaf, 0xe0, 0x0, 0x0, 0x0, 0xe, 0xfa,
    0xbf, 0xc0, 0x0, 0x0, 0x0, 0xd, 0xfb, 0xbf,
    0xd0, 0x0, 0x0, 0x0, 0xe, 0xfa, 0x9f, 0xf0,
    0x0, 0x0, 0x0, 0xf, 0xf8, 0x5f, 0xf4, 0x0,
    0x0, 0x0, 0x5f, 0xf4, 0xe, 0xfc, 0x0, 0x0,
    0x0, 0xdf, 0xe0, 0x6, 0xff, 0xb1, 0x0, 0x2b,
    0xff, 0x50, 0x0, 0x8f, 0xff, 0xdd, 0xff, 0xf8,
    0x0, 0x0, 0x4, 0xcf, 0xff, 0xfc, 0x40, 0x0,
    0x0, 0x0, 0x1, 0x33, 0x10, 0x0, 0x0,

    /* U+70 "p" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1c,
    0xc3, 0x2a, 0xff, 0xfb, 0x40, 0x0, 0x1f, 0xfa,
    0xff, 0xff, 0xff, 0xf6, 0x0, 0x1f, 0xff, 0xd5,
    0x22, 0x7f, 0xff, 0x30, 0x1f, 0xfd, 0x0, 0x0,
    0x3, 0xff, 0xb0, 0x1f, 0xf7, 0x0, 0x0, 0x0,
    0xaf, 0xf0, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0x5f,
    0xf3, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0x3f, 0xf5,
    0x1f, 0xf7, 0x0, 0x0, 0x0, 0x2f, 0xf6, 0x1f,
    0xf7, 0x0, 0x0, 0x0, 0x3f, 0xf5, 0x1f, 0xf7,
    0x0, 0x0, 0x0, 0x5f, 0xf4, 0x1f, 0xf7, 0x0,
    0x0, 0x0, 0x8f, 0xf1, 0x1f, 0xfa, 0x0, 0x0,
    0x1, 0xff, 0xc0, 0x1f, 0xff, 0x91, 0x0, 0x2d,
    0xff, 0x40, 0x1f, 0xfe, 0xff, 0xdd, 0xff, 0xf9,
    0x0, 0x1f, 0xf7, 0x6e, 0xff, 0xfe, 0x70, 0x0,
    0x1f, 0xf7, 0x0, 0x23, 0x20, 0x0, 0x0, 0x1f,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xa4, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+71 "q" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5c, 0xff, 0xe9, 0x17, 0xc9, 0x0, 0xaf, 0xff,
    0xff, 0xfe, 0xcf, 0xc0, 0x7f, 0xfd, 0x40, 0x16,
    0xef, 0xfc, 0xe, 0xfd, 0x10, 0x0, 0x2, 0xff,
    0xc5, 0xff, 0x50, 0x0, 0x0, 0xc, 0xfc, 0x8f,
    0xf1, 0x0, 0x0, 0x0, 0xcf, 0xca, 0xfe, 0x0,
    0x0, 0x0, 0xc, 0xfc, 0xbf, 0xd0, 0x0, 0x0,
    0x0, 0xcf, 0xca, 0xfe, 0x0, 0x0, 0x0, 0xc,
    0xfc, 0x8f, 0xf0, 0x0, 0x0, 0x0, 0xcf, 0xc5,
    0xff, 0x40, 0x0, 0x0, 0xc, 0xfc, 0xf, 0xfc,
    0x0, 0x0, 0x1, 0xef, 0xc0, 0x8f, 0xfa, 0x10,
    0x3, 0xdf, 0xfc, 0x0, 0xcf, 0xff, 0xde, 0xff,
    0xef, 0xc0, 0x0, 0x9f, 0xff, 0xfc, 0x4c, 0xfc,
    0x0, 0x0, 0x3, 0x31, 0x0, 0xcf, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xa8,

    /* U+72 "r" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0xcc, 0x44, 0xcf,
    0xf0, 0x1f, 0xfa, 0xff, 0xff, 0x11, 0xff, 0xff,
    0x96, 0x60, 0x1f, 0xff, 0x30, 0x0, 0x1, 0xff,
    0x80, 0x0, 0x0, 0x1f, 0xf7, 0x0, 0x0, 0x1,
    0xff, 0x70, 0x0, 0x0, 0x1f, 0xf7, 0x0, 0x0,
    0x1, 0xff, 0x70, 0x0, 0x0, 0x1f, 0xf7, 0x0,
    0x0, 0x1, 0xff, 0x70, 0x0, 0x0, 0x1f, 0xf7,
    0x0, 0x0, 0x1, 0xff, 0x70, 0x0, 0x0, 0x1f,
    0xf7, 0x0, 0x0, 0x1, 0xff, 0x70, 0x0, 0x0,

    /* U+73 "s" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7d, 0xff, 0xfb, 0x40, 0x0, 0x1, 0xdf, 0xff,
    0xff, 0xff, 0x90, 0x0, 0xbf, 0xf6, 0x11, 0x4c,
    0xff, 0x60, 0x1f, 0xf8, 0x0, 0x0, 0x1e, 0xfc,
    0x2, 0xff, 0x60, 0x0, 0x0, 0x58, 0x70, 0xe,
    0xfe, 0x30, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xff,
    0xd9, 0x40, 0x0, 0x0, 0x0, 0x3b, 0xff, 0xff,
    0xf9, 0x10, 0x0, 0x0, 0x1, 0x59, 0xef, 0xff,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xfc, 0x5,
    0x87, 0x0, 0x0, 0x0, 0x9f, 0xf0, 0x8f, 0xf2,
    0x0, 0x0, 0x9, 0xff, 0x2, 0xff, 0xd3, 0x0,
    0x5, 0xff, 0xb0, 0x6, 0xff, 0xfe, 0xde, 0xff,
    0xe2, 0x0, 0x3, 0xbf, 0xff, 0xff, 0x91, 0x0,
    0x0, 0x0, 0x3, 0x42, 0x0, 0x0, 0x0,

    /* U+74 "t" */
    0x0, 0x16, 0x62, 0x0, 0x0, 0x3, 0xff, 0x50,
    0x0, 0x0, 0x3f, 0xf5, 0x0, 0x0, 0x3, 0xff,
    0x50, 0x0, 0xbc, 0xdf, 0xfd, 0xcc, 0x1d, 0xff,
    0xff, 0xff, 0xf1, 0x12, 0x4f, 0xf6, 0x22, 0x0,
    0x3, 0xff, 0x50, 0x0, 0x0, 0x3f, 0xf5, 0x0,
    0x0, 0x3, 0xff, 0x50, 0x0, 0x0, 0x3f, 0xf5,
    0x0, 0x0, 0x3, 0xff, 0x50, 0x0, 0x0, 0x3f,
    0xf5, 0x0, 0x0, 0x3, 0xff, 0x50, 0x0, 0x0,
    0x3f, 0xf5, 0x0, 0x0, 0x2, 0xff, 0x60, 0x0,
    0x0, 0x1f, 0xfa, 0x0, 0x0, 0x0, 0xcf, 0xff,
    0xf2, 0x0, 0x2, 0xdf, 0xff, 0x20, 0x0, 0x0,
    0x23, 0x20,

    /* U+75 "u" */
    0x1c, 0xc5, 0x0, 0x0, 0x0, 0xcc, 0x62, 0xff,
    0x60, 0x0, 0x0, 0xf, 0xf8, 0x2f, 0xf6, 0x0,
    0x0, 0x0, 0xff, 0x82, 0xff, 0x60, 0x0, 0x0,
    0xf, 0xf8, 0x2f, 0xf6, 0x0, 0x0, 0x0, 0xff,
    0x82, 0xff, 0x60, 0x0, 0x0, 0xf, 0xf8, 0x2f,
    0xf6, 0x0, 0x0, 0x0, 0xff, 0x82, 0xff, 0x60,
    0x0, 0x0, 0xf, 0xf8, 0x2f, 0xf6, 0x0, 0x0,
    0x0, 0xff, 0x82, 0xff, 0x60, 0x0, 0x0, 0xf,
    0xf8, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0xff, 0x80,
    0xff, 0xb0, 0x0, 0x0, 0x5f, 0xf8, 0xa, 0xff,
    0x60, 0x0, 0x7f, 0xff, 0x80, 0x3f, 0xff, 0xfe,
    0xff, 0xef, 0xf8, 0x0, 0x4d, 0xff, 0xff, 0xa1,
    0xef, 0x80, 0x0, 0x2, 0x33, 0x0, 0x0, 0x0,

    /* U+76 "v" */
    0x5c, 0xc2, 0x0, 0x0, 0x0, 0x8c, 0xb0, 0x1f,
    0xf7, 0x0, 0x0, 0x0, 0xef, 0x90, 0xb, 0xfc,
    0x0, 0x0, 0x4, 0xff, 0x30, 0x5, 0xff, 0x20,
    0x0, 0x9, 0xfd, 0x0, 0x0, 0xff, 0x70, 0x0,
    0xe, 0xf8, 0x0, 0x0, 0xaf, 0xc0, 0x0, 0x4f,
    0xf2, 0x0, 0x0, 0x4f, 0xf2, 0x0, 0x9f, 0xc0,
    0x0, 0x0, 0xe, 0xf7, 0x0, 0xef, 0x60, 0x0,
    0x0, 0x8, 0xfc, 0x3, 0xff, 0x10, 0x0, 0x0,
    0x2, 0xff, 0x18, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x7d, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0xef, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xfe, 0x0, 0x0,
    0x0,

    /* U+77 "w" */
    0x3c, 0xc2, 0x0, 0x0, 0x8, 0xc7, 0x0, 0x0,
    0x3, 0xcc, 0x30, 0xff, 0x70, 0x0, 0x0, 0xef,
    0xe0, 0x0, 0x0, 0x7f, 0xf0, 0xb, 0xfb, 0x0,
    0x0, 0x4f, 0xff, 0x30, 0x0, 0xb, 0xfb, 0x0,
    0x7f, 0xf0, 0x0, 0x8, 0xff, 0xf8, 0x0, 0x0,
    0xff, 0x60, 0x2, 0xff, 0x30, 0x0, 0xdf, 0x8f,
    0xd0, 0x0, 0x3f, 0xf2, 0x0, 0xd, 0xf7, 0x0,
    0x3f, 0xe0, 0xff, 0x20, 0x7, 0xfd, 0x0, 0x0,
    0x9f, 0xc0, 0x7, 0xf9, 0xb, 0xf7, 0x0, 0xbf,
    0x80, 0x0, 0x4, 0xff, 0x0, 0xcf, 0x40, 0x5f,
    0xc0, 0xf, 0xf4, 0x0, 0x0, 0xf, 0xf4, 0x1f,
    0xf0, 0x1, 0xff, 0x13, 0xff, 0x0, 0x0, 0x0,
    0xbf, 0x86, 0xfa, 0x0, 0xb, 0xf6, 0x7f, 0xa0,
    0x0, 0x0, 0x6, 0xfc, 0xbf, 0x50, 0x0, 0x6f,
    0xbb, 0xf6, 0x0, 0x0, 0x0, 0x2f, 0xff, 0xf0,
    0x0, 0x1, 0xff, 0xff, 0x10, 0x0, 0x0, 0x0,
    0xdf, 0xfb, 0x0, 0x0, 0xc, 0xff, 0xc0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0x60, 0x0, 0x0, 0x7f,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xf1, 0x0,
    0x0, 0x2, 0xff, 0x30, 0x0, 0x0,

    /* U+78 "x" */
    0xc, 0xcb, 0x0, 0x0, 0x1, 0xcc, 0xa0, 0x6,
    0xff, 0x60, 0x0, 0xa, 0xff, 0x40, 0x0, 0xcf,
    0xe1, 0x0, 0x3f, 0xf9, 0x0, 0x0, 0x2f, 0xf9,
    0x0, 0xdf, 0xe0, 0x0, 0x0, 0x7, 0xff, 0x37,
    0xff, 0x40, 0x0, 0x0, 0x0, 0xcf, 0xdf, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0xe1, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xff, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xdf, 0xf9, 0x0, 0x0, 0x0, 0x7,
    0xff, 0x47, 0xff, 0x40, 0x0, 0x0, 0x2f, 0xfa,
    0x0, 0xcf, 0xe0, 0x0, 0x0, 0xcf, 0xf1, 0x0,
    0x3f, 0xf9, 0x0, 0x7, 0xff, 0x60, 0x0, 0x9,
    0xff, 0x40, 0x2f, 0xfc, 0x0, 0x0, 0x0, 0xef,
    0xe1,

    /* U+79 "y" */
    0x7c, 0xc2, 0x0, 0x0, 0x0, 0xbc, 0x93, 0xff,
    0x70, 0x0, 0x0, 0x3f, 0xf7, 0xd, 0xfd, 0x0,
    0x0, 0x8, 0xff, 0x10, 0x8f, 0xf2, 0x0, 0x0,
    0xdf, 0xc0, 0x2, 0xff, 0x70, 0x0, 0x2f, 0xf6,
    0x0, 0xc, 0xfd, 0x0, 0x7, 0xff, 0x10, 0x0,
    0x6f, 0xf2, 0x0, 0xcf, 0xb0, 0x0, 0x1, 0xff,
    0x70, 0x1f, 0xf5, 0x0, 0x0, 0xb, 0xfd, 0x6,
    0xff, 0x0, 0x0, 0x0, 0x5f, 0xf2, 0xbf, 0xa0,
    0x0, 0x0, 0x0, 0xff, 0x8f, 0xf5, 0x0, 0x0,
    0x0, 0x9, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x8, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xfd, 0x0, 0x0, 0x0, 0x3, 0x49, 0xff,
    0x50, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0xb, 0xed, 0x60, 0x0, 0x0, 0x0,
    0x0,

    /* U+7A "z" */
    0x8c, 0xcc, 0xcc, 0xcc, 0xcc, 0xc6, 0xaf, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x24, 0x44, 0x44, 0x44,
    0xef, 0xf3, 0x0, 0x0, 0x0, 0x8, 0xff, 0x60,
    0x0, 0x0, 0x0, 0x4f, 0xfa, 0x0, 0x0, 0x0,
    0x1, 0xef, 0xd0, 0x0, 0x0, 0x0, 0xc, 0xff,
    0x30, 0x0, 0x0, 0x0, 0x8f, 0xf6, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x1e,
    0xfd, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xf2, 0x0,
    0x0, 0x0, 0x9, 0xff, 0x60, 0x0, 0x0, 0x0,
    0x5f, 0xfa, 0x11, 0x11, 0x11, 0x11, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0xff,

    /* U+7B "{" */
    0x0, 0x0, 0x0, 0x6, 0x90, 0x0, 0x0, 0x3,
    0xdf, 0xf0, 0x0, 0x0, 0x1e, 0xfc, 0x10, 0x0,
    0x0, 0xaf, 0xe1, 0x0, 0x0, 0x0, 0xff, 0x90,
    0x0, 0x0, 0x1, 0xff, 0x60, 0x0, 0x0, 0x3,
    0xff, 0x40, 0x0, 0x0, 0x3, 0xff, 0x40, 0x0,
    0x0, 0x3, 0xff, 0x40, 0x0, 0x0, 0x3, 0xff,
    0x40, 0x0, 0x0, 0x6, 0xff, 0x20, 0x0, 0x0,
    0xc, 0xfd, 0x0, 0x0, 0x8, 0xcf, 0xf4, 0x0,
    0x0, 0x2f, 0xff, 0x50, 0x0, 0x0, 0x1a, 0xef,
    0xe2, 0x0, 0x0, 0x0, 0x1d, 0xfc, 0x0, 0x0,
    0x0, 0x6, 0xff, 0x10, 0x0, 0x0, 0x4, 0xff,
    0x40, 0x0, 0x0, 0x3, 0xff, 0x40, 0x0, 0x0,
    0x3, 0xff, 0x40, 0x0, 0x0, 0x3, 0xff, 0x40,
    0x0, 0x0, 0x1, 0xff, 0x60, 0x0, 0x0, 0x0,
    0xff, 0x80, 0x0, 0x0, 0x0, 0xbf, 0xe0, 0x0,
    0x0, 0x0, 0x3f, 0xfa, 0x0, 0x0, 0x0, 0x4,
    0xff, 0xd0, 0x0, 0x0, 0x0, 0x19, 0xb0,

    /* U+7C "|" */
    0x8e, 0x69, 0xf7, 0x9f, 0x79, 0xf7, 0x9f, 0x79,
    0xf7, 0x9f, 0x79, 0xf7, 0x9f, 0x79, 0xf7, 0x9f,
    0x79, 0xf7, 0x9f, 0x79, 0xf7, 0x9f, 0x79, 0xf7,
    0x9f, 0x79, 0xf7, 0x9f, 0x79, 0xf7, 0x9f, 0x79,
    0xf7, 0x9f, 0x76, 0xb4,

    /* U+7D "}" */
    0x49, 0x20, 0x0, 0x0, 0x9, 0xff, 0x80, 0x0,
    0x0, 0x7, 0xff, 0x70, 0x0, 0x0, 0x9, 0xff,
    0x10, 0x0, 0x0, 0x2f, 0xf6, 0x0, 0x0, 0x0,
    0xff, 0x80, 0x0, 0x0, 0xe, 0xfa, 0x0, 0x0,
    0x0, 0xdf, 0xa0, 0x0, 0x0, 0xd, 0xfa, 0x0,
    0x0, 0x0, 0xdf, 0xa0, 0x0, 0x0, 0xb, 0xfd,
    0x0, 0x0, 0x0, 0x6f, 0xf4, 0x0, 0x0, 0x0,
    0xcf, 0xf9, 0x40, 0x0, 0x0, 0xcf, 0xf8, 0x0,
    0x0, 0x9f, 0xfc, 0x50, 0x0, 0x5f, 0xf6, 0x0,
    0x0, 0xb, 0xfd, 0x0, 0x0, 0x0, 0xdf, 0xb0,
    0x0, 0x0, 0xd, 0xfa, 0x0, 0x0, 0x0, 0xdf,
    0xa0, 0x0, 0x0, 0xe, 0xfa, 0x0, 0x0, 0x0,
    0xff, 0x80, 0x0, 0x0, 0x1f, 0xf7, 0x0, 0x0,
    0x7, 0xff, 0x20, 0x0, 0x4, 0xff, 0x90, 0x0,
    0x8, 0xff, 0xa0, 0x0, 0x0, 0x5b, 0x40, 0x0,
    0x0, 0x0,

    /* U+7E "~" */
    0x0, 0x19, 0xee, 0xc5, 0x0, 0x0, 0x0, 0x89,
    0x20, 0x1d, 0xff, 0xff, 0xfb, 0x0, 0x0, 0xf,
    0xf2, 0xa, 0xfe, 0x64, 0xaf, 0xfd, 0x20, 0x9,
    0xfd, 0x0, 0xff, 0x50, 0x0, 0x6f, 0xff, 0xcd,
    0xff, 0x50, 0x2f, 0xf1, 0x0, 0x0, 0x3d, 0xff,
    0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0x76, 0x20, 0x0,

    /* U+F001 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0x7c, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x38, 0xdf, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x9e,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa5, 0xff, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xea, 0x50, 0x0, 0xff,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xfd, 0x94,
    0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xc7, 0x20, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x2,
    0x8c, 0xff, 0xd8, 0xff, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x0, 0x0, 0x5f, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff, 0xfe,
    0x2, 0x8c, 0xff, 0xd8, 0xff, 0x0, 0x0, 0x5f,
    0xff, 0xff, 0xff, 0xf5, 0x5f, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0x2, 0x8c, 0xff, 0xc8, 0x20,
    0xef, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0x8c, 0xff, 0xc8,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F008 "" */
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb1, 0xbf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xff, 0x30,
    0x3, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xff, 0x30, 0x3, 0xff, 0xff, 0x0, 0x0,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xff, 0xff, 0x30, 0x3, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x30,
    0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x30, 0x3, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0x30, 0x3, 0xff, 0xff,
    0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0x0, 0x0, 0xff, 0xff, 0x0,
    0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0x0, 0x0, 0xff, 0xff, 0x30, 0x3,
    0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xff, 0x30, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x30, 0x3, 0xff, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x30, 0x3,
    0xff, 0xff, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0xff,
    0xff, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0xff, 0xff,
    0x30, 0x3, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0x30, 0x3, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x3, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x30, 0x3, 0xff, 0xff, 0x0, 0x0, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0,
    0x0, 0xff, 0xff, 0x0, 0x0, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0x0,
    0xff, 0xff, 0x30, 0x3, 0xff, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xff, 0x30, 0x3, 0xff,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x1b,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb1,

    /* U+F00B "" */
    0x8f, 0xff, 0xff, 0xf8, 0x0, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,
    0xff, 0xf8, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xf8, 0x0, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,
    0xff, 0xf8, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xf8, 0x0, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,
    0xff, 0xf8, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8,

    /* U+F00C "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5b, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xff, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xff,
    0xe0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x0, 0xa,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff,
    0xff, 0xe2, 0x0, 0x0, 0xbf, 0xff, 0xb0, 0x0,
    0x0, 0x6, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x0,
    0xa, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x6f, 0xff,
    0xff, 0xff, 0xe2, 0x0, 0x0, 0x1f, 0xff, 0xff,
    0xff, 0xb0, 0x6, 0xff, 0xff, 0xff, 0xfe, 0x20,
    0x0, 0x0, 0xa, 0xff, 0xff, 0xff, 0xfb, 0x6f,
    0xff, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x20, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff,
    0xff, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xe2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xb2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F00D "" */
    0x0, 0x1, 0x30, 0x0, 0x0, 0x0, 0x0, 0x3,
    0x10, 0x0, 0x0, 0x2e, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xe2, 0x0, 0x2, 0xef, 0xff, 0xb0,
    0x0, 0x0, 0xb, 0xff, 0xfe, 0x20, 0x1e, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xe1,
    0x3f, 0xff, 0xff, 0xff, 0xb0, 0xb, 0xff, 0xff,
    0xff, 0xf3, 0xb, 0xff, 0xff, 0xff, 0xfb, 0xbf,
    0xff, 0xff, 0xff, 0xb0, 0x0, 0xbf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x0, 0xb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff,
    0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff,
    0xff, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xb0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0xb, 0xff, 0xff, 0xff,
    0xfb, 0xbf, 0xff, 0xff, 0xff, 0xb0, 0x3f, 0xff,
    0xff, 0xff, 0xb0, 0xb, 0xff, 0xff, 0xff, 0xf3,
    0x1e, 0xff, 0xff, 0xfb, 0x0, 0x0, 0xbf, 0xff,
    0xff, 0xe1, 0x2, 0xef, 0xff, 0xb0, 0x0, 0x0,
    0xb, 0xff, 0xfe, 0x20, 0x0, 0x2e, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xe2, 0x0, 0x0, 0x1,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x3, 0x10, 0x0,

    /* U+F011 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4e, 0xe4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xef, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5d, 0xd4, 0x0, 0xff, 0xff, 0x0,
    0x4d, 0xd5, 0x0, 0x0, 0x0, 0x7, 0xff, 0xfe,
    0x0, 0xff, 0xff, 0x0, 0xef, 0xff, 0x60, 0x0,
    0x0, 0x5f, 0xff, 0xfe, 0x0, 0xff, 0xff, 0x0,
    0xef, 0xff, 0xf5, 0x0, 0x2, 0xff, 0xff, 0xf4,
    0x0, 0xff, 0xff, 0x0, 0x4f, 0xff, 0xff, 0x10,
    0xa, 0xff, 0xff, 0x40, 0x0, 0xff, 0xff, 0x0,
    0x4, 0xff, 0xff, 0xa0, 0x2f, 0xff, 0xf7, 0x0,
    0x0, 0xff, 0xff, 0x0, 0x0, 0x7f, 0xff, 0xf1,
    0x7f, 0xff, 0xd0, 0x0, 0x0, 0xff, 0xff, 0x0,
    0x0, 0xd, 0xff, 0xf7, 0xbf, 0xff, 0x70, 0x0,
    0x0, 0xff, 0xff, 0x0, 0x0, 0x7, 0xff, 0xfb,
    0xef, 0xff, 0x20, 0x0, 0x0, 0xef, 0xfe, 0x0,
    0x0, 0x2, 0xff, 0xfe, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x4e, 0xe4, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xdf, 0xff, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff, 0xfd,
    0xbf, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xff, 0xfb, 0x6f, 0xff, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xff, 0xf6,
    0x1f, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xf1, 0x9, 0xff, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0x90,
    0x1, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xff, 0xff, 0x10, 0x0, 0x4f, 0xff, 0xff,
    0xd7, 0x20, 0x2, 0x7d, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x6b, 0xdf, 0xfd, 0xb6, 0x10, 0x0, 0x0, 0x0,

    /* U+F013 "" */
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6b, 0x20, 0x9, 0xff, 0xff, 0x90,
    0x2, 0xb6, 0x0, 0x0, 0x0, 0x7, 0xff, 0xf5,
    0x5e, 0xff, 0xff, 0xe5, 0x5f, 0xff, 0x60, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0x0, 0x0, 0xbf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x0, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xe1, 0x0, 0x0, 0x5, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x0,
    0x0, 0x5, 0xff, 0xff, 0xfd, 0x40, 0x4, 0xdf,
    0xff, 0xff, 0x50, 0x0, 0x47, 0xae, 0xff, 0xff,
    0xd1, 0x0, 0x0, 0x1d, 0xff, 0xff, 0xe9, 0x63,
    0xff, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0, 0x4,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x40, 0x0, 0x0, 0x5, 0xff, 0xff, 0xff, 0xff,
    0x36, 0x9d, 0xff, 0xff, 0xd1, 0x0, 0x0, 0x1d,
    0xff, 0xff, 0xea, 0x74, 0x0, 0x5, 0xff, 0xff,
    0xfd, 0x40, 0x4, 0xdf, 0xff, 0xff, 0x50, 0x0,
    0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x50, 0x0, 0x0, 0x1e, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0x0, 0x5f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0,
    0x0, 0x6, 0xff, 0xf5, 0x5e, 0xff, 0xff, 0xe5,
    0x5f, 0xff, 0x70, 0x0, 0x0, 0x0, 0x5c, 0x20,
    0x9, 0xff, 0xff, 0x90, 0x2, 0xc6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xff, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0,

    /* U+F014 "" */
    0x0, 0x0, 0x0, 0x1b, 0xff, 0xff, 0xff, 0xb1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xff,
    0xff, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xff, 0x20, 0x0, 0x2, 0xff, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xfb, 0x0, 0x0, 0x0,
    0xbf, 0x70, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0,
    0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0x0, 0x0, 0xff, 0x0, 0xee, 0x0,
    0xee, 0x0, 0xee, 0x0, 0xff, 0x0, 0x0, 0xff,
    0x0, 0xff, 0x0, 0xff, 0x0, 0xff, 0x0, 0xff,
    0x0, 0x0, 0xff, 0x0, 0xff, 0x0, 0xff, 0x0,
    0xff, 0x0, 0xff, 0x0, 0x0, 0xff, 0x0, 0xff,
    0x0, 0xff, 0x0, 0xff, 0x0, 0xff, 0x0, 0x0,
    0xff, 0x0, 0xff, 0x0, 0xff, 0x0, 0xff, 0x0,
    0xff, 0x0, 0x0, 0xff, 0x0, 0xff, 0x0, 0xff,
    0x0, 0xff, 0x0, 0xff, 0x0, 0x0, 0xff, 0x0,
    0xff, 0x0, 0xff, 0x0, 0xff, 0x0, 0xff, 0x0,
    0x0, 0xff, 0x0, 0xff, 0x0, 0xff, 0x0, 0xff,
    0x0, 0xff, 0x0, 0x0, 0xff, 0x0, 0xff, 0x0,
    0xff, 0x0, 0xff, 0x0, 0xff, 0x0, 0x0, 0xff,
    0x0, 0xee, 0x0, 0xee, 0x0, 0xee, 0x0, 0xff,
    0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0x0, 0x0, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0x0,
    0xef, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xfe, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0xa, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x0,

    /* U+F015 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xee, 0x60, 0x0, 0xef, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0xf9, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0xee, 0xff, 0xb0,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xdf, 0xfd, 0x22, 0xdf, 0xfd, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3e, 0xff, 0xb1, 0x99,
    0x1b, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xff, 0xf9, 0x1b, 0xff, 0xc1, 0x8f, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0x62,
    0xdf, 0xff, 0xfd, 0x26, 0xff, 0xff, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xe4, 0x4f, 0xff, 0xff, 0xff,
    0xf5, 0x3e, 0xff, 0xb0, 0x0, 0x1, 0xcf, 0xfd,
    0x26, 0xff, 0xff, 0xff, 0xff, 0xff, 0x81, 0xcf,
    0xfd, 0x20, 0x3e, 0xff, 0xb1, 0xaf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0x1b, 0xff, 0xe3, 0x5f,
    0xf8, 0x1c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xc1, 0x8f, 0xf5, 0x7, 0x50, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x5,
    0x70, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xf0, 0x0, 0xf, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xf0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xf0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xf0, 0x0, 0xf, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff,
    0xff, 0xf0, 0x0, 0xf, 0xff, 0xff, 0xfc, 0x0,
    0x0,

    /* U+F019 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0xc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xdf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1d, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xd1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xdf, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1d, 0xff, 0xff,
    0xff, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xdf, 0xff, 0xfd, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1d, 0xff, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xff, 0xf4, 0x1, 0xcc, 0x10,
    0x4f, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x40, 0x0, 0x4, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0x11, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x33, 0xff, 0x33,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x33, 0xff, 0x33, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,

    /* U+F01C "" */
    0x0, 0x0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0x0, 0x0, 0x0, 0x2, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x0,
    0x0, 0x9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x90, 0x0, 0x0, 0xf, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xf0, 0x0,
    0x0, 0x7f, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0xf6, 0x0, 0x0, 0xdf, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xfd, 0x0,
    0x4, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xff, 0x40, 0xb, 0xff, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xb0,
    0x2f, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xff, 0xf2, 0x9f, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xf9,
    0xef, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xfd, 0xff, 0xff, 0xff, 0xff,
    0x40, 0x0, 0x0, 0x4, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0xc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf4, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,

    /* U+F021 "" */
    0x0, 0x0, 0x0, 0x2, 0x7b, 0xef, 0xfd, 0xb6,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xbf,
    0xff, 0xff, 0xff, 0xff, 0xf9, 0x10, 0x1, 0xcc,
    0x0, 0x0, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe4, 0x1d, 0xff, 0x0, 0x7, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xff,
    0x0, 0x5f, 0xff, 0xff, 0xd7, 0x21, 0x2, 0x6d,
    0xff, 0xff, 0xff, 0xff, 0x2, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xff,
    0x9, 0xff, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x1d, 0xff, 0xff, 0xff, 0x1f, 0xff, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xdf, 0xff, 0xff, 0xff,
    0x6f, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0, 0xc,
    0xff, 0xff, 0xff, 0xff, 0x9f, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xff, 0xf4,
    0xff, 0xff, 0xff, 0xfd, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0xff, 0xe0, 0xff, 0xff, 0xff, 0xd1,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0x70,
    0xff, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xff, 0xfe, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xd7, 0x20, 0x13, 0x7d, 0xff, 0xff, 0xf3, 0x0,
    0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x50, 0x0, 0xff, 0xd1, 0x4f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x0, 0x0,
    0xcc, 0x10, 0x1, 0x9f, 0xff, 0xff, 0xff, 0xff,
    0xfa, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x6b, 0xdf, 0xfe, 0xb7, 0x10, 0x0, 0x0, 0x0,

    /* U+F026 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x44, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xff, 0x0, 0x0, 0x0, 0x6, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x6f, 0xff, 0xff, 0x0, 0x0,
    0x6, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x6, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x6, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x44,

    /* U+F027 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x44, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x6a, 0x20, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xbf, 0xe2,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x1b,
    0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x1, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x1, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x1b, 0xfa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0xbf, 0xe2, 0xcf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x6a, 0x20, 0x0, 0x0,
    0x6, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x44, 0x0, 0x0, 0x0,

    /* U+F028 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xfa, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x44,
    0x0, 0x0, 0x5, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xff, 0x0, 0x0, 0x0,
    0x1a, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xff, 0x0, 0x0, 0x52, 0x0, 0x7f, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0xff, 0x0,
    0x2, 0xff, 0x90, 0x7, 0xff, 0x10, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0x0, 0x0, 0x8f, 0xfc,
    0x0, 0xbf, 0xa0, 0x0, 0x0, 0x6, 0xff, 0xff,
    0xff, 0x0, 0x0, 0x3, 0xef, 0x90, 0x1f, 0xf1,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x6a,
    0x20, 0x3f, 0xf2, 0xb, 0xf7, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xbf, 0xe2, 0x9, 0xf9,
    0x5, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x1b, 0xfa, 0x3, 0xfd, 0x2, 0xfe, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x1, 0xfe,
    0x0, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x1, 0xfe, 0x0, 0xff, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x1b, 0xfa, 0x3, 0xfd, 0x2, 0xfe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0xbf, 0xe2, 0x9,
    0xf9, 0x5, 0xfb, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x6a, 0x20, 0x3f, 0xf2, 0xb, 0xf7,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x3, 0xef, 0x90, 0x2f, 0xf1, 0x0, 0x0, 0x0,
    0x6f, 0xff, 0xff, 0x0, 0x0, 0x8f, 0xfc, 0x0,
    0xbf, 0xa0, 0x0, 0x0, 0x0, 0x6, 0xff, 0xff,
    0x0, 0x2, 0xff, 0x90, 0x7, 0xff, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xff, 0x0, 0x0, 0x52,
    0x0, 0x7f, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xff, 0x0, 0x0, 0x0, 0x1a, 0xff, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x44, 0x0,
    0x0, 0x5, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xfa,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F03E "" */
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb1, 0xbf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xff, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x8, 0xee,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0x0, 0x8f, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x0, 0xef, 0xff, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0x0, 0xef, 0xff, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x80, 0x0, 0x0, 0x0, 0xff,
    0xff, 0x0, 0x8f, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xf8, 0x0, 0x0, 0x0, 0xff, 0xff,
    0x0, 0x8, 0xee, 0x80, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0x80, 0x0, 0x0, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0x80, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x88, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0x0, 0xff, 0xff, 0x0, 0x0, 0x8, 0xff,
    0x80, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xff, 0xff, 0x0, 0x0, 0x8f, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0xff, 0xff, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff,
    0xff, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff, 0xff,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb1,

    /* U+F040 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x19, 0x91, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xdf, 0xfe, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1d,
    0xff, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xfe, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x22, 0x2d,
    0xff, 0xff, 0xff, 0xe1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xdd, 0x22, 0xdf, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2d, 0xff, 0xd2,
    0x2d, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xdf, 0xd7, 0xfd, 0x22, 0xdf, 0xff, 0xd1,
    0x0, 0x0, 0x0, 0x0, 0x1d, 0xfe, 0x4d, 0xff,
    0xe2, 0x1d, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x2,
    0xdf, 0xd3, 0xdf, 0xff, 0xfd, 0x22, 0xc2, 0x0,
    0x0, 0x0, 0x0, 0x1d, 0xfe, 0x4d, 0xff, 0xff,
    0xff, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x1, 0xdf,
    0xe4, 0xdf, 0xff, 0xff, 0xff, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x1d, 0xfe, 0x4d, 0xff, 0xff, 0xff,
    0xfe, 0x20, 0x0, 0x0, 0x0, 0x1, 0xdf, 0xe4,
    0xdf, 0xff, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x0,
    0x0, 0x1d, 0xfe, 0x4d, 0xff, 0xff, 0xff, 0xfe,
    0x20, 0x0, 0x0, 0x0, 0x2, 0xdf, 0xe3, 0xdf,
    0xff, 0xff, 0xff, 0xd2, 0x0, 0x0, 0x0, 0x0,
    0x2d, 0xff, 0xee, 0xff, 0xff, 0xff, 0xfd, 0x20,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0xc2, 0xdf, 0xff,
    0xff, 0xff, 0xd2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x0, 0x1d, 0xff, 0xff, 0xfd, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0x1, 0xdf,
    0xff, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0x0, 0x2f, 0xfd, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0xcf,
    0xe2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xe2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F048 "" */
    0xcf, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2d,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x1, 0xdf,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x1d, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x1, 0xdf, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x1d, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x1, 0xdf, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x1d, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x1, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x1d, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x1, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x1d, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x1d, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x1, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x1d, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x1, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x1d, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x1, 0xdf, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x1d, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x1, 0xdf, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x1d, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x1, 0xdf,
    0xcf, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2d,

    /* U+F04B "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xfa, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xf9,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xe7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xe5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xc3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x91, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x70,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x50, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x30,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x20, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0x20, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x30, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x50, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x70, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x91, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xc3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xe5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xe7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xf9, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xfa, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04C "" */
    0xcf, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x0, 0xcf,
    0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xff,
    0xfc, 0x0, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xfc,

    /* U+F04D "" */
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,

    /* U+F051 "" */
    0xd2, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xfc,
    0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xe2, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xfe, 0x20, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xe2, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe2, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x20, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe2, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe2, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x20, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe2, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xe2, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xfe, 0x20, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xe2, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xd2, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xfc,

    /* U+F052 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xdd, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xdf, 0xfe,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xdf, 0xff, 0xfe, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xdf, 0xff,
    0xff, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xdf, 0xff, 0xff, 0xff, 0xfe, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x20, 0x0, 0x0, 0x0, 0x1, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x0,
    0x0, 0x1, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x20, 0x0, 0x1, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x20, 0x1, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0,

    /* U+F053 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x66, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x6f, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x6, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xff, 0xff,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xff, 0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0x60, 0x0,

    /* U+F054 "" */
    0x0, 0x6, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0xff, 0xff, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xff,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xf6, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x66, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F067 "" */
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0xff, 0xf8, 0x0, 0x0,
    0x0, 0x0,

    /* U+F068 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8,

    /* U+F071 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4d, 0xd4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xef, 0xfe, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xff, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xff, 0xff, 0xff, 0xff, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xfd, 0x0, 0x0,
    0xdf, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xfc, 0x0, 0x0, 0xcf, 0xff,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xff, 0xfd, 0x0, 0x0, 0xdf, 0xff, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xfd,
    0x0, 0x0, 0xdf, 0xff, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xef, 0xff, 0xfe, 0x0, 0x0,
    0xef, 0xff, 0xfe, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xff, 0xfe, 0x0, 0x0, 0xff, 0xff,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff,
    0xff, 0xff, 0x0, 0x0, 0xff, 0xff, 0xff, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xff,
    0x10, 0x1, 0xff, 0xff, 0xff, 0xfa, 0x0, 0x0,
    0x0, 0x2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x30, 0x0, 0x0, 0xb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xb0, 0x0, 0x0, 0x4f, 0xff, 0xff,
    0xff, 0xff, 0x10, 0x1, 0xff, 0xff, 0xff, 0xff,
    0xf4, 0x0, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x0,
    0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0xe, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x10, 0x1, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x7f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x4d, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xd4,

    /* U+F074 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xfb, 0x0,
    0xef, 0xff, 0xfd, 0x82, 0x0, 0x0, 0x0, 0x28,
    0xce, 0xff, 0xff, 0xff, 0xff, 0xb0, 0xff, 0xff,
    0xff, 0xff, 0x60, 0x0, 0x7, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0xef, 0xff, 0xff, 0xff, 0xff, 0x35,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0x0, 0x15, 0xef, 0xfd, 0x1e, 0xff, 0xfe,
    0x51, 0x0, 0x0, 0xff, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0xf4, 0x9f, 0xff, 0xf2, 0x0, 0x0,
    0x0, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xd1, 0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x48, 0xff,
    0xfd, 0x0, 0x0, 0x0, 0x0, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xff, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0x84, 0x0, 0x0, 0x0, 0x0, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0xff,
    0x1d, 0x60, 0x0, 0x0, 0x0, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xff, 0xf9, 0x5f, 0xf2,
    0x0, 0x0, 0x0, 0xff, 0xb0, 0x0, 0x0, 0x0,
    0x15, 0xef, 0xff, 0xe1, 0xdf, 0xfe, 0x51, 0x0,
    0x0, 0xff, 0xfb, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xff, 0x53, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xb0, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0x70, 0x0, 0x7, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xef, 0xff,
    0xec, 0x82, 0x0, 0x0, 0x0, 0x29, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x50, 0x0, 0x0,

    /* U+F077 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x44, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xff, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0xff, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xff, 0xff, 0xff, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0xff, 0xff, 0x99, 0xff,
    0xff, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x6, 0xff,
    0xff, 0xff, 0xf9, 0x0, 0x9f, 0xff, 0xff, 0xff,
    0x60, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xff, 0x90,
    0x0, 0x9, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x6,
    0xff, 0xff, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0xff, 0x60, 0x5f, 0xff, 0xff, 0xff,
    0x90, 0x0, 0x0, 0x0, 0x9, 0xff, 0xff, 0xff,
    0xf5, 0x7f, 0xff, 0xff, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0xff, 0xff, 0xf6, 0x9, 0xff,
    0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xff, 0xff, 0x90, 0x0, 0x9f, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xf9, 0x0,
    0x0, 0x7, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0x70, 0x0,

    /* U+F078 "" */
    0x0, 0x7, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0x70, 0x0, 0x0, 0x9f, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xf9, 0x0, 0x9, 0xff, 0xff, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xff, 0xff, 0x90, 0x7f,
    0xff, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xff, 0xff, 0xf6, 0x5f, 0xff, 0xff, 0xff,
    0x90, 0x0, 0x0, 0x0, 0x9, 0xff, 0xff, 0xff,
    0xf5, 0x6, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xff, 0x60, 0x0, 0x6f,
    0xff, 0xff, 0xff, 0x90, 0x0, 0x9, 0xff, 0xff,
    0xff, 0xf6, 0x0, 0x0, 0x6, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0x9f, 0xff, 0xff, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0xff, 0xff, 0x99, 0xff,
    0xff, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0xff,
    0xff, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x44, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F079 "" */
    0x0, 0x0, 0xc, 0xc0, 0x0, 0xdf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xfb, 0x0, 0x5f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x8,
    0xff, 0xff, 0x80, 0x7, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x6f, 0xff,
    0xff, 0xf6, 0x0, 0xaf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x3, 0xff, 0xff, 0xff,
    0xff, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0x0, 0x0, 0x2e, 0xff, 0xff, 0xff, 0xff,
    0xe2, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0x0, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0x0,
    0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x0, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0x0, 0x0, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xff, 0xff,
    0xff, 0xff, 0xe2, 0x0, 0x0, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff, 0xff,
    0xff, 0x40, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfa, 0x0, 0x6f, 0xff, 0xff, 0xf6,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x70, 0x8, 0xff, 0xff, 0x80, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0x0, 0xbf, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0xc, 0xc0, 0x0, 0x0,

    /* U+F07B "" */
    0x4, 0xcf, 0xff, 0xff, 0xfc, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0x40, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0x4f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf4, 0x4, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x40,

    /* U+F093 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xcc, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1d, 0xff, 0xd1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xdf,
    0xff, 0xfd, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1d, 0xff, 0xff, 0xff, 0xd1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xdf, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1d, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x10, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xff, 0x70, 0x0, 0x0, 0x0, 0x7, 0xff, 0xff,
    0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x10,
    0x0, 0x1, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x33, 0xff, 0x33, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x33,
    0xff, 0x33, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8,

    /* U+F095 "" */
    0x0, 0x7d, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xff, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xef, 0xff, 0xff, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xff, 0xff, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xff, 0xfd,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff,
    0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xff, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xfa, 0x0,
    0x0, 0x2, 0xea, 0x10, 0x0, 0x0, 0x0, 0x1d,
    0xff, 0xff, 0xd3, 0x0, 0x1e, 0xff, 0xf7, 0x0,
    0x0, 0x0, 0x1, 0xdf, 0xff, 0xff, 0x94, 0xdf,
    0xff, 0xff, 0xe5, 0x0, 0x0, 0x0, 0x1c, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x0, 0x0, 0x0, 0x0, 0x5, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xdf, 0xff, 0xff, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x9d, 0xfe,
    0xa3, 0x0,

    /* U+F0C4 "" */
    0x1, 0x8d, 0xfe, 0xc7, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1d, 0xff,
    0xff, 0xff, 0xe5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xfc, 0x89, 0xdf,
    0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xdd, 0x50, 0xef, 0xb0, 0x0, 0x5, 0xef, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xbd, 0x43, 0xcc,
    0xff, 0x90, 0x0, 0x0, 0x2f, 0xfb, 0x0, 0x0,
    0x0, 0x1, 0x9e, 0x60, 0x0, 0x9c, 0xbf, 0xf2,
    0x0, 0x0, 0x9, 0xfe, 0x0, 0x0, 0x0, 0x8e,
    0x80, 0x0, 0x1c, 0xa0, 0x3f, 0xfe, 0x50, 0x0,
    0xb, 0xfe, 0x0, 0x0, 0x6e, 0xa1, 0x0, 0x4,
    0xe6, 0x0, 0x7, 0xff, 0xfd, 0x98, 0xcf, 0xff,
    0x90, 0x4c, 0xc3, 0x0, 0x0, 0x7e, 0x30, 0x0,
    0x0, 0x5e, 0xff, 0xff, 0xff, 0xe3, 0xbf, 0xd5,
    0x0, 0x0, 0xb, 0xc1, 0x0, 0x0, 0x0, 0x1,
    0x7c, 0xff, 0xda, 0xe6, 0xe7, 0x0, 0x0, 0x2,
    0xd9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2c, 0xf0, 0xcc, 0x0, 0x5e, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2c,
    0xc0, 0xcc, 0x9, 0xde, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x7c, 0xff, 0xda, 0xe6, 0x3, 0x52,
    0xcb, 0x2, 0xd9, 0x0, 0x0, 0x0, 0x0, 0x5e,
    0xff, 0xff, 0xff, 0xe3, 0x9f, 0xff, 0x70, 0x0,
    0xa, 0xc1, 0x0, 0x0, 0x7, 0xff, 0xfd, 0x98,
    0xcf, 0xff, 0x90, 0x4c, 0xc3, 0x0, 0x0, 0x7e,
    0x30, 0x0, 0x3f, 0xfe, 0x50, 0x0, 0xb, 0xfe,
    0x0, 0x0, 0x6e, 0xa1, 0x0, 0x4, 0xe6, 0x0,
    0xbf, 0xf2, 0x0, 0x0, 0x9, 0xfe, 0x0, 0x0,
    0x0, 0x8e, 0x80, 0x0, 0x1c, 0xa0, 0xff, 0x90,
    0x0, 0x0, 0x2f, 0xfb, 0x0, 0x0, 0x0, 0x1,
    0x9e, 0x60, 0x0, 0x9c, 0xff, 0xb0, 0x0, 0x5,
    0xef, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x3, 0xbd,
    0x43, 0xcc, 0xaf, 0xfc, 0x89, 0xdf, 0xff, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xdd, 0x50,
    0x1e, 0xff, 0xff, 0xff, 0xe5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x8d,
    0xfe, 0xc7, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F0C5 "" */
    0x0, 0x0, 0x0, 0x1, 0x9e, 0xff, 0xff, 0xff,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2d, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xdf,
    0xff, 0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2d, 0xfc, 0xff, 0x0,
    0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xdf, 0xc0, 0xff, 0x0, 0x0, 0x0,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1d,
    0xfc, 0x0, 0xff, 0x0, 0x0, 0x0, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xdf, 0xc0, 0x0,
    0xff, 0x0, 0x0, 0x0, 0xff, 0x9e, 0xff, 0xff,
    0xff, 0xf8, 0x1d, 0xfc, 0x0, 0x0, 0xff, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x9f, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x2,
    0xff, 0xff, 0x0, 0x0, 0x0, 0xff, 0xef, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0x2d, 0xfc, 0xff,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xdf, 0xc0, 0xff, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1d, 0xfc, 0x0, 0xff, 0x0, 0x0, 0x0, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x1, 0xdf, 0xc0,
    0x0, 0xff, 0x0, 0x0, 0x0, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x1d, 0xfc, 0x0, 0x0, 0xff,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,

    /* U+F0C7 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe9, 0x10, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x0, 0x0,
    0xff, 0x0, 0xff, 0xff, 0xff, 0x10, 0x1, 0xff,
    0x2c, 0xfd, 0x20, 0x0, 0xff, 0x0, 0xff, 0xff,
    0xff, 0x0, 0x0, 0xff, 0x0, 0xcf, 0xe2, 0x0,
    0xff, 0x0, 0xff, 0xff, 0xff, 0x0, 0x0, 0xff,
    0x0, 0xc, 0xfe, 0x20, 0xff, 0x0, 0xff, 0xff,
    0xff, 0x0, 0x0, 0xff, 0x0, 0x0, 0xcf, 0xd1,
    0xff, 0x0, 0xff, 0xff, 0xff, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xc, 0xf9, 0xff, 0x0, 0xff, 0xff,
    0xff, 0x10, 0x1, 0xff, 0x0, 0x0, 0x2, 0xfe,
    0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff,
    0xff, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0x0, 0xff, 0xff, 0x0, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0xff,
    0xff, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0x0, 0xff, 0xff, 0x0, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0xff,
    0xff, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0x0, 0xff, 0xff, 0x0, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,

    /* U+F0E7 "" */
    0x0, 0xc, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x5f,
    0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x9f, 0xff,
    0xff, 0xa0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xff,
    0x40, 0x0, 0x0, 0x1, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x0, 0x4, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0x34, 0x8, 0xff, 0xff, 0xf3, 0x37, 0xbf, 0xfe,
    0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x4f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x10, 0xcf, 0xff, 0xff, 0xce,
    0xff, 0xf9, 0x0, 0xef, 0xc8, 0x40, 0xf, 0xff,
    0xf2, 0x0, 0x10, 0x0, 0x0, 0x3f, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0x30, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0xb, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb8, 0x0, 0x0, 0x0, 0x0,

    /* U+F0F3 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xdd, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xae,
    0xff, 0xea, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xcf, 0xff, 0xff, 0xff, 0xfc,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2e,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x60, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x30, 0x0, 0x0, 0xa, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xa0, 0x0, 0x0, 0x2f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0x0, 0x8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x80, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x4e, 0xff, 0xff, 0xff, 0xff,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x7f, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xb9, 0xff, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xeb,
    0x7e, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2b, 0xff, 0xb2, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F11C "" */
    0x4e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0xff, 0x0,
    0xff, 0x0, 0xff, 0x0, 0xff, 0x0, 0xff, 0x0,
    0xff, 0x0, 0xff, 0xff, 0x0, 0xff, 0x0, 0xff,
    0x0, 0xff, 0x0, 0xff, 0x0, 0xff, 0x0, 0xff,
    0x0, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0xff,
    0xff, 0x0, 0xff, 0xff, 0x0, 0xff, 0x0, 0xff,
    0x0, 0xff, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff,
    0x0, 0xff, 0xff, 0x0, 0xff, 0x0, 0xff, 0x0,
    0xff, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0xff, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0xff, 0x0, 0xff, 0xff, 0x0, 0xff, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff,
    0x0, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x4e,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe4,

    /* U+F124 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xdc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xdf, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xdf, 0xff,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xdf, 0xff, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xdf, 0xff, 0xff, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xdf, 0xff, 0xff, 0xff,
    0xfd, 0x0, 0x0, 0x0, 0x0, 0x5, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x5,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x0,
    0x0, 0x5, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x50, 0x0, 0x5, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x0, 0x0, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xfd, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbc, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F15B "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x10, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xd2, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0xfe, 0x20, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xff, 0xe2, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0xff, 0xfe, 0x20, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0xe2, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0xff, 0xff, 0xfe, 0x20, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0xd1,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,

    /* U+F1EB "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x48, 0xbd, 0xef,
    0xfe, 0xdb, 0x84, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xaf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x50, 0x0, 0x0,
    0x0, 0x2, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x20, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0xff, 0xd9, 0x52, 0x10,
    0x1, 0x25, 0x9d, 0xff, 0xff, 0xff, 0xf6, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xb3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3b, 0xff, 0xff, 0xff, 0x80,
    0x3f, 0xff, 0xff, 0xc3, 0x0, 0x4, 0x9c, 0xdf,
    0xfd, 0xc9, 0x40, 0x0, 0x3c, 0xff, 0xff, 0xf3,
    0x8, 0xff, 0xf8, 0x0, 0x29, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x92, 0x0, 0x8f, 0xff, 0x80,
    0x0, 0x8e, 0x40, 0x9, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x90, 0x4, 0xe8, 0x0,
    0x0, 0x0, 0x2, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x20, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xff, 0xff, 0xff, 0xa5, 0x10,
    0x2, 0x49, 0xef, 0xff, 0xff, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xfe, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0xa1, 0x0, 0x5a, 0xdf,
    0xfd, 0xa5, 0x0, 0x1b, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x0, 0x5e, 0xff, 0xff,
    0xff, 0xff, 0xe5, 0x0, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xfa, 0x30,
    0x3, 0xaf, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0x20, 0x0,
    0x0, 0x2, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xae,
    0xea, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff,
    0xff, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F240 "" */
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xb1, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0xff, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xff, 0x0, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0,
    0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0xff, 0x0, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0xff, 0xe4, 0xff, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xff, 0xfe, 0xff, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0xff,
    0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x0, 0xff, 0xff, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0xff,
    0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0xff, 0xfe, 0xff, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xff, 0xe4, 0xff, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff, 0x0,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x0, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xff, 0x0, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x1b, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb1, 0x0,

    /* U+F241 "" */
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xb1, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0xff, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xff, 0x0, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0,
    0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x0, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xe4, 0xff, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xfe, 0xff, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xfe, 0xff, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xe4, 0xff, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x0, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xff, 0x0, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x1b, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb1, 0x0,

    /* U+F242 "" */
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xb1, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0xff, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xff, 0x0, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0,
    0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x0, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xe4, 0xff, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xfe, 0xff, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xfe, 0xff, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xe4, 0xff, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x0, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xff, 0x0, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x1b, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb1, 0x0,

    /* U+F243 "" */
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xb1, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0xff, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xff, 0x0, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0,
    0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x0, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xe4, 0xff, 0x0, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xfe, 0xff, 0x0,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0x0,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xfe, 0xff, 0x0, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xe4, 0xff, 0x0,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x0, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xff, 0x0, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x1b, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb1, 0x0,

    /* U+F244 "" */
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xb1, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0xff, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xff, 0x0, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xe4, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xfe, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xfe, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xe4, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x0, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xff, 0x0, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x1b, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb1, 0x0,

    /* U+F293 "" */
    0x0, 0x0, 0x0, 0x39, 0xce, 0xff, 0xec, 0x93,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2b, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xb2, 0x0, 0x0, 0x0, 0x3,
    0xef, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xfe, 0x20,
    0x0, 0x0, 0xe, 0xff, 0xff, 0xff, 0x16, 0xff,
    0xff, 0xff, 0xd0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xff, 0x10, 0x6f, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0x10, 0x6, 0xff, 0xff,
    0xff, 0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0x10,
    0x0, 0x6f, 0xff, 0xff, 0x50, 0x9, 0xff, 0xfe,
    0xdf, 0xff, 0x10, 0x90, 0x6, 0xff, 0xff, 0x90,
    0xd, 0xff, 0xe3, 0x1d, 0xff, 0x10, 0xdb, 0x0,
    0x6f, 0xff, 0xd0, 0xf, 0xff, 0xf3, 0x1, 0xdf,
    0x10, 0xdf, 0x20, 0x1e, 0xff, 0xf0, 0x2f, 0xff,
    0xff, 0x30, 0x1d, 0x10, 0xd3, 0x1, 0xdf, 0xff,
    0xf2, 0x3f, 0xff, 0xff, 0xf3, 0x1, 0x0, 0x20,
    0x1d, 0xff, 0xff, 0xf3, 0x4f, 0xff, 0xff, 0xff,
    0x30, 0x0, 0x1, 0xdf, 0xff, 0xff, 0xf4, 0x4f,
    0xff, 0xff, 0xff, 0xf3, 0x0, 0x1d, 0xff, 0xff,
    0xff, 0xf4, 0x4f, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x1d, 0xff, 0xff, 0xff, 0xf4, 0x4f, 0xff, 0xff,
    0xff, 0x30, 0x0, 0x1, 0xdf, 0xff, 0xff, 0xf4,
    0x3f, 0xff, 0xff, 0xf3, 0x1, 0x0, 0x20, 0x1d,
    0xff, 0xff, 0xf3, 0x2f, 0xff, 0xff, 0x30, 0x1d,
    0x10, 0xd3, 0x1, 0xdf, 0xff, 0xf2, 0xf, 0xff,
    0xf3, 0x1, 0xdf, 0x10, 0xdf, 0x20, 0x1e, 0xff,
    0xf0, 0xd, 0xff, 0xe3, 0x1d, 0xff, 0x10, 0xdb,
    0x0, 0x6f, 0xff, 0xd0, 0x9, 0xff, 0xfe, 0xdf,
    0xff, 0x10, 0x90, 0x6, 0xff, 0xff, 0x90, 0x5,
    0xff, 0xff, 0xff, 0xff, 0x10, 0x0, 0x6f, 0xff,
    0xff, 0x50, 0x0, 0xff, 0xff, 0xff, 0xff, 0x10,
    0x6, 0xff, 0xff, 0xff, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0x10, 0x6f, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0xd, 0xff, 0xff, 0xff, 0x16, 0xff, 0xff,
    0xff, 0xd0, 0x0, 0x0, 0x2, 0xef, 0xff, 0xff,
    0x7f, 0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0,
    0x2b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x39, 0xce, 0xff, 0xec,
    0x93, 0x0, 0x0, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_h = 0, .box_w = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 111, .box_h = 0, .box_w = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 115, .box_h = 21, .box_w = 4, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 42, .adv_w = 143, .box_h = 7, .box_w = 7, .ofs_x = 1, .ofs_y = 14},
    {.bitmap_index = 67, .adv_w = 279, .box_h = 20, .box_w = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 237, .adv_w = 252, .box_h = 27, .box_w = 14, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 426, .adv_w = 328, .box_h = 22, .box_w = 19, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 635, .adv_w = 278, .box_h = 22, .box_w = 17, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 822, .adv_w = 78, .box_h = 7, .box_w = 3, .ofs_x = 1, .ofs_y = 14},
    {.bitmap_index = 833, .adv_w = 153, .box_h = 30, .box_w = 8, .ofs_x = 1, .ofs_y = -7},
    {.bitmap_index = 953, .adv_w = 156, .box_h = 30, .box_w = 8, .ofs_x = 0, .ofs_y = -7},
    {.bitmap_index = 1073, .adv_w = 193, .box_h = 12, .box_w = 12, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 1145, .adv_w = 254, .box_h = 15, .box_w = 14, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 1250, .adv_w = 88, .box_h = 7, .box_w = 5, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 1268, .adv_w = 124, .box_h = 3, .box_w = 8, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 1280, .adv_w = 118, .box_h = 4, .box_w = 5, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 1290, .adv_w = 185, .box_h = 22, .box_w = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1411, .adv_w = 252, .box_h = 22, .box_w = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 1565, .adv_w = 252, .box_h = 20, .box_w = 8, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 1645, .adv_w = 252, .box_h = 21, .box_w = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1792, .adv_w = 252, .box_h = 22, .box_w = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 1935, .adv_w = 252, .box_h = 20, .box_w = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2095, .adv_w = 252, .box_h = 21, .box_w = 13, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 2232, .adv_w = 251, .box_h = 21, .box_w = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 2379, .adv_w = 252, .box_h = 20, .box_w = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2519, .adv_w = 252, .box_h = 22, .box_w = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 2673, .adv_w = 252, .box_h = 21, .box_w = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2810, .adv_w = 109, .box_h = 16, .box_w = 5, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 2850, .adv_w = 95, .box_h = 19, .box_w = 6, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 2907, .adv_w = 228, .box_h = 13, .box_w = 13, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 2992, .adv_w = 246, .box_h = 9, .box_w = 12, .ofs_x = 2, .ofs_y = 5},
    {.bitmap_index = 3046, .adv_w = 234, .box_h = 13, .box_w = 13, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 3131, .adv_w = 212, .box_h = 22, .box_w = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 3263, .adv_w = 402, .box_h = 27, .box_w = 23, .ofs_x = 1, .ofs_y = -7},
    {.bitmap_index = 3574, .adv_w = 292, .box_h = 20, .box_w = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3754, .adv_w = 279, .box_h = 20, .box_w = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3894, .adv_w = 292, .box_h = 22, .box_w = 16, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 4070, .adv_w = 294, .box_h = 20, .box_w = 15, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4220, .adv_w = 255, .box_h = 20, .box_w = 13, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4350, .adv_w = 248, .box_h = 20, .box_w = 13, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4480, .adv_w = 305, .box_h = 22, .box_w = 17, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 4667, .adv_w = 319, .box_h = 20, .box_w = 16, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4827, .adv_w = 122, .box_h = 20, .box_w = 4, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4867, .adv_w = 247, .box_h = 21, .box_w = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5014, .adv_w = 281, .box_h = 20, .box_w = 16, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 5174, .adv_w = 241, .box_h = 20, .box_w = 13, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 5304, .adv_w = 391, .box_h = 20, .box_w = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 5514, .adv_w = 319, .box_h = 20, .box_w = 16, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 5674, .adv_w = 308, .box_h = 22, .box_w = 17, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5861, .adv_w = 283, .box_h = 20, .box_w = 15, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 6011, .adv_w = 308, .box_h = 25, .box_w = 17, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 6224, .adv_w = 276, .box_h = 20, .box_w = 15, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 6374, .adv_w = 266, .box_h = 22, .box_w = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6539, .adv_w = 267, .box_h = 20, .box_w = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6709, .adv_w = 291, .box_h = 21, .box_w = 16, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6877, .adv_w = 285, .box_h = 20, .box_w = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7057, .adv_w = 397, .box_h = 20, .box_w = 25, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7307, .adv_w = 281, .box_h = 20, .box_w = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7477, .adv_w = 269, .box_h = 20, .box_w = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7647, .adv_w = 268, .box_h = 20, .box_w = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7797, .adv_w = 119, .box_h = 28, .box_w = 6, .ofs_x = 2, .ofs_y = -5},
    {.bitmap_index = 7881, .adv_w = 184, .box_h = 22, .box_w = 12, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 8013, .adv_w = 119, .box_h = 28, .box_w = 6, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 8097, .adv_w = 187, .box_h = 10, .box_w = 11, .ofs_x = 0, .ofs_y = 10},
    {.bitmap_index = 8152, .adv_w = 202, .box_h = 3, .box_w = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8172, .adv_w = 138, .box_h = 5, .box_w = 7, .ofs_x = 0, .ofs_y = 16},
    {.bitmap_index = 8190, .adv_w = 244, .box_h = 17, .box_w = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8301, .adv_w = 251, .box_h = 22, .box_w = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8455, .adv_w = 235, .box_h = 17, .box_w = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8566, .adv_w = 253, .box_h = 22, .box_w = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8709, .adv_w = 237, .box_h = 17, .box_w = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8820, .adv_w = 156, .box_h = 22, .box_w = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8930, .adv_w = 251, .box_h = 22, .box_w = 13, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 9073, .adv_w = 247, .box_h = 21, .box_w = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9210, .adv_w = 109, .box_h = 21, .box_w = 4, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9252, .adv_w = 107, .box_h = 27, .box_w = 6, .ofs_x = -1, .ofs_y = -6},
    {.bitmap_index = 9333, .adv_w = 227, .box_h = 21, .box_w = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9480, .adv_w = 109, .box_h = 21, .box_w = 3, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 9512, .adv_w = 393, .box_h = 16, .box_w = 22, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9688, .adv_w = 247, .box_h = 16, .box_w = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9792, .adv_w = 256, .box_h = 17, .box_w = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9911, .adv_w = 251, .box_h = 22, .box_w = 14, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 10065, .adv_w = 255, .box_h = 22, .box_w = 13, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 10208, .adv_w = 152, .box_h = 16, .box_w = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10280, .adv_w = 231, .box_h = 17, .box_w = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10391, .adv_w = 146, .box_h = 20, .box_w = 9, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 10481, .adv_w = 247, .box_h = 16, .box_w = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10585, .adv_w = 217, .box_h = 15, .box_w = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10690, .adv_w = 337, .box_h = 15, .box_w = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10848, .adv_w = 222, .box_h = 15, .box_w = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10953, .adv_w = 212, .box_h = 21, .box_w = 13, .ofs_x = 0, .ofs_y = -6},
    {.bitmap_index = 11090, .adv_w = 222, .box_h = 15, .box_w = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11180, .adv_w = 152, .box_h = 27, .box_w = 10, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 11315, .adv_w = 109, .box_h = 24, .box_w = 3, .ofs_x = 2, .ofs_y = -4},
    {.bitmap_index = 11351, .adv_w = 152, .box_h = 27, .box_w = 9, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 11473, .adv_w = 305, .box_h = 6, .box_w = 17, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 11524, .adv_w = 384, .box_h = 26, .box_w = 24, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 11836, .adv_w = 480, .box_h = 26, .box_w = 30, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 12226, .adv_w = 448, .box_h = 22, .box_w = 28, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12534, .adv_w = 448, .box_h = 19, .box_w = 26, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12781, .adv_w = 352, .box_h = 20, .box_w = 20, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 12981, .adv_w = 384, .box_h = 26, .box_w = 24, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 13293, .adv_w = 384, .box_h = 24, .box_w = 24, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 13581, .adv_w = 352, .box_h = 24, .box_w = 22, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 13845, .adv_w = 416, .box_h = 21, .box_w = 26, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14118, .adv_w = 416, .box_h = 24, .box_w = 26, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14430, .adv_w = 384, .box_h = 20, .box_w = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14670, .adv_w = 384, .box_h = 24, .box_w = 24, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 14958, .adv_w = 192, .box_h = 20, .box_w = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15078, .adv_w = 288, .box_h = 20, .box_w = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15258, .adv_w = 416, .box_h = 24, .box_w = 26, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 15570, .adv_w = 480, .box_h = 24, .box_w = 30, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 15930, .adv_w = 384, .box_h = 24, .box_w = 24, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 16218, .adv_w = 256, .box_h = 24, .box_w = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 16410, .adv_w = 352, .box_h = 26, .box_w = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 16696, .adv_w = 384, .box_h = 24, .box_w = 24, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 16984, .adv_w = 384, .box_h = 24, .box_w = 24, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 17272, .adv_w = 256, .box_h = 24, .box_w = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 17464, .adv_w = 385, .box_h = 21, .box_w = 25, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17727, .adv_w = 320, .box_h = 26, .box_w = 17, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 17948, .adv_w = 320, .box_h = 26, .box_w = 17, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 18169, .adv_w = 352, .box_h = 22, .box_w = 22, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18411, .adv_w = 352, .box_h = 6, .box_w = 22, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 18477, .adv_w = 448, .box_h = 26, .box_w = 28, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 18841, .adv_w = 448, .box_h = 26, .box_w = 28, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 19205, .adv_w = 448, .box_h = 17, .box_w = 26, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19426, .adv_w = 448, .box_h = 17, .box_w = 26, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 19647, .adv_w = 480, .box_h = 18, .box_w = 30, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19917, .adv_w = 416, .box_h = 22, .box_w = 26, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20203, .adv_w = 416, .box_h = 25, .box_w = 26, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 20528, .adv_w = 352, .box_h = 22, .box_w = 22, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20770, .adv_w = 448, .box_h = 22, .box_w = 28, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 21078, .adv_w = 448, .box_h = 28, .box_w = 28, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 21470, .adv_w = 384, .box_h = 24, .box_w = 24, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 21758, .adv_w = 224, .box_h = 26, .box_w = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 21940, .adv_w = 448, .box_h = 28, .box_w = 26, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 22304, .adv_w = 480, .box_h = 18, .box_w = 30, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22574, .adv_w = 352, .box_h = 22, .box_w = 22, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 22816, .adv_w = 384, .box_h = 28, .box_w = 24, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 23152, .adv_w = 512, .box_h = 22, .box_w = 32, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23504, .adv_w = 576, .box_h = 20, .box_w = 36, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23864, .adv_w = 576, .box_h = 20, .box_w = 36, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24224, .adv_w = 576, .box_h = 20, .box_w = 36, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24584, .adv_w = 576, .box_h = 20, .box_w = 36, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24944, .adv_w = 576, .box_h = 20, .box_w = 36, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 25304, .adv_w = 384, .box_h = 28, .box_w = 22, .ofs_x = 1, .ofs_y = -4}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static uint16_t unicode_list_1[] = {
    0x0, 0x7, 0xa, 0xb, 0xc, 0x10, 0x12, 0x13,
    0x14, 0x18, 0x1b, 0x20, 0x25, 0x26, 0x27, 0x3d,
    0x3f, 0x47, 0x4a, 0x4b, 0x4c, 0x50, 0x51, 0x52,
    0x53, 0x66, 0x67, 0x70, 0x73, 0x76, 0x77, 0x78,
    0x7a, 0x92, 0x94, 0xc3, 0xc4, 0xc6, 0xe6, 0xf2,
    0x11b, 0x123, 0x15a, 0x1ea, 0x23f, 0x240, 0x241, 0x242,
    0x243, 0x292
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY,
        .glyph_id_start = 1, .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0
    },
    {
        .range_start = 61441, .range_length = 659, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY,
        .glyph_id_start = 96, .unicode_list = unicode_list_1, .glyph_id_ofs_list = NULL, .list_length = 50
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static uint8_t kern_left_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 0,
    2, 3, 0, 0, 0, 4, 0, 4,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6, 7, 8, 9, 10, 11,
    0, 12, 12, 13, 14, 15, 12, 12,
    9, 16, 17, 18, 0, 19, 13, 20,
    21, 22, 23, 24, 25, 0, 0, 0,
    0, 0, 26, 27, 28, 0, 29, 30,
    0, 31, 0, 0, 32, 0, 31, 31,
    33, 27, 0, 34, 0, 35, 0, 36,
    37, 38, 36, 39, 40, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0
};

/*Map glyph_ids to kern right classes*/
static uint8_t kern_right_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 3,
    2, 0, 4, 5, 0, 6, 7, 6,
    8, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    9, 0, 10, 0, 11, 0, 0, 0,
    11, 0, 0, 12, 0, 0, 0, 0,
    11, 0, 11, 0, 13, 14, 15, 16,
    17, 18, 19, 20, 0, 0, 21, 0,
    0, 0, 22, 0, 23, 23, 23, 24,
    23, 0, 0, 0, 0, 0, 25, 25,
    26, 25, 23, 27, 28, 29, 30, 31,
    32, 33, 31, 34, 0, 0, 35, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0
};

/*Kern values between classes*/
static uint8_t kern_class_values[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -23, 0, 0, 0,
    0, 0, 0, 0, -26, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -11, -13, 0, -4, -13, 0, -17, 0,
    0, 0, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 4, 4, 0,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -37, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -49, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -26, 0, 0, 0, 0, 0, 0, -13,
    0, -2, 0, 0, -28, -4, -19, -15,
    0, -21, 0, 0, 0, 0, 0, 0,
    -3, 0, 0, -4, -2, -11, -7, 0,
    3, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -6,
    0, -5, 0, 0, -12, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -6, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -6, 0, 0, 0, 0, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -4,
    0, 0, 0, 0, 0, -22, 0, 0,
    0, -5, 0, 0, 0, -6, 0, -5,
    0, -5, -9, -5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 0, 0, 0, 0, 0, 0, 0,
    0, -4, -4, 0, -4, 0, 0, 0,
    -4, -6, -5, 0, 0, 0, 0, 0,
    0, 0, 0, -51, 0, 0, 0, -37,
    0, -58, 0, 4, 0, 0, 0, 0,
    0, 0, 0, -7, -5, 0, 0, -5,
    -6, 0, 0, -5, -5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 4, 0, 0, 0, -6, 0,
    0, 0, 4, -6, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -14, 0, 0,
    0, -7, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -6, 0, -5,
    -6, 0, 0, 0, -5, -9, -14, 0,
    0, 0, 0, -73, 0, 0, 0, 0,
    0, 0, 0, 4, -14, 0, 0, -60,
    -12, -38, -31, 0, -52, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -10,
    -29, -20, 0, 0, 0, 0, 0, 0,
    0, 0, -71, 0, 0, 0, -30, 0,
    -44, 0, 0, 0, 0, 0, -7, 0,
    -6, 0, -2, -3, 0, 0, -3, 0,
    0, 3, 0, 3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -9, 0, -6,
    -4, 0, -8, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -17, 0, -4, 0, 0, -10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -9, 0,
    0, 0, 0, -48, -51, 0, 0, -17,
    -6, -52, -3, 4, 0, 4, 3, 0,
    4, 0, 0, -25, -22, 0, -24, -22,
    -16, -25, 0, -21, -16, -12, -17, -13,
    0, 0, 0, 0, 4, 0, -49, -8,
    0, 0, -16, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 4, -10, -10,
    0, 0, -10, -7, 0, 0, -6, -2,
    0, 0, 0, 4, 0, 0, 0, 3,
    0, -27, -13, 0, 0, -9, 0, 0,
    0, 3, 0, 0, 0, 0, 0, 0,
    3, -7, -7, 0, 0, -7, -5, 0,
    0, -4, 0, 0, 0, 0, 3, 0,
    0, 0, 0, 0, 0, -10, 0, 0,
    0, -5, 0, 0, 0, 0, 3, 0,
    0, 0, 0, 0, 0, -6, 0, 0,
    -5, 0, 0, 0, -5, -7, 0, 0,
    0, 0, 0, 0, -7, 4, -11, -46,
    -11, 0, 0, -21, -6, -21, -3, 4,
    -21, 4, 4, 3, 4, 0, 4, -16,
    -14, -5, -9, -14, -9, -13, -5, -9,
    -4, 0, -5, -7, 4, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 3, -6,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -5, 0, 0, -5, 0,
    0, 0, -4, -6, -6, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -4, 0, 0, -4, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -15, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -3, 0, 0, 0, 0, 0, -6,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -2, 0, -3, -3,
    0, 0, -2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -3, 0, 0, 0, 0, 0,
    4, 0, 4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 4, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 4, 0, -23, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -30, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, 0,
    -5, -3, 0, 0, 4, 0, 0, 0,
    -27, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -9, -4, 3, 0, -4, 0, 0, 11,
    0, 4, 4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 3, 0, 0, 0, -23, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, -3,
    3, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -27, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, 0, 0,
    -4, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -3, 0, 0, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -4, 0, 0, -4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0
};


/*Collect the kern class' data in one place*/
static lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 40,
    .right_class_cnt     = 35,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .cmap_num = 2,
    .bpp = 4,

    .kern_scale = 16,
    .kern_dsc = &kern_classes,
    .kern_classes = 1
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t lv_font_roboto_28 = {
    .dsc = &font_dsc,          /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .line_height = 31,          /*The maximum line height required by the font*/
    .base_line = 7,             /*Baseline measured from the bottom of the line*/
};

#endif /*#if LV_FONT_ROBOTO_28*/

