#include "../../lvgl.h"

/*******************************************************************************
 * Size: 12 px
 * Bpp: 4
 * Opts: --no-compress --no-prefilter --bpp 4 --size 12 --font ./Roboto-Regular.woff -r 0x20-0x7F --font FontAwesome.ttf -r 61441,61448,61451,61452,61453,61457,61459,61460,61461,61465,61468,61473,61478,61479,61480,61502,61504,61512,61515,61516,61517,61521,61522,61523,61524,61543,61544,61553,61556,61559,61560,61561,61563,61587,61589,61636,61637,61639,61671,61683,61724,61732,61787,61931,62016,62017,62018,62019,62020,62099 --format lvgl -o lv_font_roboto_12.c --force-fast-kern-format
 ******************************************************************************/

#ifndef LV_FONT_ROBOTO_12
#define LV_FONT_ROBOTO_12 1
#endif

#if LV_FONT_ROBOTO_12

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0x8, 0x0, 0xf1, 0xf, 0x10, 0xf1, 0xf, 0x0,
    0xf0, 0x9, 0x0, 0x10, 0xe, 0x10, 0x0,

    /* U+22 "\"" */
    0x39, 0x93, 0x39, 0x92, 0x26, 0x80,

    /* U+23 "#" */
    0x0, 0x6, 0x5, 0x10, 0x3, 0xa0, 0xc0, 0x1,
    0x67, 0x1d, 0x11, 0xbe, 0xcc, 0xeb, 0x0, 0xc0,
    0x67, 0x1, 0x3d, 0x3a, 0x61, 0x5b, 0xd9, 0xe9,
    0x40, 0x57, 0xd, 0x0, 0x8, 0x42, 0xa0, 0x0,

    /* U+24 "$" */
    0x0, 0xc, 0x0, 0x0, 0x7, 0xf7, 0x0, 0xb,
    0xa5, 0xb9, 0x0, 0xf1, 0x2, 0xf0, 0xd, 0x70,
    0x1, 0x0, 0x3d, 0xd6, 0x0, 0x0, 0x4, 0xca,
    0x2, 0x60, 0x1, 0xf0, 0x2e, 0x10, 0x3f, 0x0,
    0x7e, 0xde, 0x50, 0x0, 0xd, 0x0, 0x0, 0x0,
    0x20, 0x0,

    /* U+25 "%" */
    0x6, 0x93, 0x0, 0x0, 0x3, 0xa2, 0xc0, 0x6,
    0x0, 0x57, 0xb, 0x19, 0x40, 0x2, 0xc7, 0xc3,
    0xa0, 0x0, 0x1, 0x40, 0xb1, 0x0, 0x0, 0x0,
    0x76, 0x7b, 0x80, 0x0, 0x2b, 0x2b, 0xa, 0x20,
    0xb, 0x23, 0x90, 0x93, 0x0, 0x20, 0xb, 0xab,
    0x0, 0x0, 0x0, 0x1, 0x0,

    /* U+26 "&" */
    0x0, 0x79, 0x50, 0x0, 0x7, 0xc4, 0xd4, 0x0,
    0xa, 0x70, 0xa6, 0x0, 0x5, 0xd8, 0xc0, 0x0,
    0x2, 0xee, 0x0, 0x0, 0x1e, 0x6c, 0x81, 0xc0,
    0x5b, 0x1, 0xea, 0xa0, 0x3e, 0x10, 0x5f, 0x50,
    0x7, 0xed, 0xe8, 0xe1, 0x0, 0x1, 0x0, 0x0,

    /* U+27 "'" */
    0x67, 0x66, 0x54,

    /* U+28 "(" */
    0x0, 0x5, 0x0, 0x87, 0x3, 0xc0, 0xa, 0x50,
    0xf, 0x10, 0x2f, 0x0, 0x3e, 0x0, 0x2f, 0x0,
    0xf, 0x0, 0xb, 0x50, 0x4, 0xb0, 0x0, 0xa5,
    0x0, 0x6,

    /* U+29 ")" */
    0x40, 0x0, 0x5a, 0x0, 0xb, 0x50, 0x4, 0xc0,
    0x0, 0xf1, 0x0, 0xd3, 0x0, 0xc4, 0x0, 0xd3,
    0x0, 0xf1, 0x3, 0xd0, 0x9, 0x60, 0x4b, 0x0,
    0x61, 0x0,

    /* U+2A "*" */
    0x0, 0x70, 0x0, 0xd, 0x0, 0x9c, 0xea, 0xc0,
    0x5f, 0x80, 0x1d, 0x2d, 0x10, 0x20, 0x20,

    /* U+2B "+" */
    0x0, 0x0, 0x0, 0x0, 0x2, 0xe0, 0x0, 0x0,
    0x2e, 0x0, 0x5, 0x9a, 0xf9, 0x92, 0x37, 0x8f,
    0x77, 0x20, 0x2, 0xe0, 0x0, 0x0, 0x2e, 0x0,
    0x0, 0x0, 0x20, 0x0,

    /* U+2C "," */
    0x13, 0x4c, 0x79, 0x61,

    /* U+2D "-" */
    0x1, 0x10, 0xad, 0xd1,

    /* U+2E "." */
    0x2, 0x1, 0xf1, 0x0, 0x0,

    /* U+2F "/" */
    0x0, 0x3, 0x40, 0x0, 0xb3, 0x0, 0x1c, 0x0,
    0x7, 0x60, 0x0, 0xd1, 0x0, 0x4a, 0x0, 0xa,
    0x40, 0x0, 0xd0, 0x0, 0x68, 0x0, 0x8, 0x20,
    0x0,

    /* U+30 "0" */
    0x0, 0x79, 0x60, 0x0, 0xb9, 0x4c, 0x70, 0x2e,
    0x0, 0x3e, 0x4, 0xc0, 0x1, 0xf0, 0x5c, 0x0,
    0xf, 0x14, 0xc0, 0x0, 0xf0, 0x3d, 0x0, 0x1f,
    0x0, 0xe3, 0x7, 0xb0, 0x5, 0xed, 0xd2, 0x0,
    0x0, 0x10, 0x0,

    /* U+31 "1" */
    0x0, 0x52, 0x9e, 0xf4, 0x61, 0xc4, 0x0, 0xc4,
    0x0, 0xc4, 0x0, 0xc4, 0x0, 0xc4, 0x0, 0xc4,
    0x0, 0xc4,

    /* U+32 "2" */
    0x1, 0x89, 0x60, 0x1, 0xe7, 0x4c, 0x90, 0x5b,
    0x0, 0x3d, 0x0, 0x0, 0x5, 0xb0, 0x0, 0x1,
    0xd3, 0x0, 0x0, 0xc6, 0x0, 0x0, 0xb8, 0x0,
    0x0, 0xa9, 0x0, 0x0, 0x4f, 0xdd, 0xdd, 0x40,

    /* U+33 "3" */
    0x1, 0x89, 0x50, 0x1e, 0x74, 0xc7, 0x39, 0x0,
    0x4c, 0x0, 0x0, 0x89, 0x0, 0x9d, 0xd1, 0x0,
    0x2, 0xa9, 0x12, 0x0, 0x2e, 0x4d, 0x0, 0x6c,
    0x8, 0xed, 0xd2, 0x0, 0x0, 0x0,

    /* U+34 "4" */
    0x0, 0x0, 0x82, 0x0, 0x0, 0x8f, 0x40, 0x0,
    0x3d, 0xd4, 0x0, 0xc, 0x3c, 0x40, 0x7, 0x90,
    0xc4, 0x2, 0xd1, 0xc, 0x40, 0xaf, 0xdd, 0xfe,
    0x60, 0x0, 0xc, 0x40, 0x0, 0x0, 0xc4, 0x0,

    /* U+35 "5" */
    0x3, 0x88, 0x88, 0x0, 0x7b, 0x77, 0x70, 0x9,
    0x70, 0x0, 0x0, 0xa9, 0x86, 0x0, 0xa, 0xa6,
    0xcb, 0x0, 0x0, 0x0, 0xf2, 0x4, 0x0, 0xd,
    0x30, 0xe3, 0x2, 0xf1, 0x4, 0xdc, 0xe5, 0x0,
    0x0, 0x10, 0x0,

    /* U+36 "6" */
    0x0, 0x5, 0x70, 0x0, 0x1d, 0xa6, 0x0, 0xa,
    0x70, 0x0, 0x0, 0xf4, 0x86, 0x0, 0x2f, 0xa5,
    0xba, 0x3, 0xe0, 0x1, 0xf0, 0x2f, 0x0, 0xf,
    0x10, 0xd5, 0x4, 0xe0, 0x2, 0xdd, 0xd3, 0x0,
    0x0, 0x10, 0x0,

    /* U+37 "7" */
    0x48, 0x88, 0x88, 0x12, 0x55, 0x56, 0xf1, 0x0,
    0x0, 0x79, 0x0, 0x0, 0xe, 0x20, 0x0, 0x6,
    0xb0, 0x0, 0x0, 0xd3, 0x0, 0x0, 0x4c, 0x0,
    0x0, 0xc, 0x50, 0x0, 0x3, 0xe0, 0x0, 0x0,

    /* U+38 "8" */
    0x1, 0x79, 0x60, 0x0, 0xc9, 0x4c, 0x80, 0x1f,
    0x0, 0x4d, 0x0, 0xe3, 0x7, 0xa0, 0x4, 0xfe,
    0xe1, 0x0, 0xe5, 0x18, 0xa0, 0x4c, 0x0, 0xf,
    0x2, 0xe1, 0x4, 0xe0, 0x7, 0xec, 0xd4, 0x0,
    0x0, 0x10, 0x0,

    /* U+39 "9" */
    0x1, 0x89, 0x40, 0xd, 0x85, 0xd4, 0x4c, 0x0,
    0x5c, 0x5b, 0x0, 0x2e, 0x2e, 0x10, 0x6e, 0x8,
    0xec, 0xbd, 0x0, 0x0, 0x6a, 0x0, 0x4, 0xe2,
    0x3, 0xeb, 0x30,

    /* U+3A ":" */
    0x2, 0x1, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x20, 0x1f, 0x10, 0x0,

    /* U+3B ";" */
    0x2, 0x1, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x30, 0x4c, 0x7, 0x90, 0x61, 0x0,

    /* U+3C "<" */
    0x0, 0x0, 0x11, 0x0, 0x2a, 0xe2, 0x3b, 0xd6,
    0x0, 0x7e, 0x60, 0x0, 0x2, 0x9e, 0x91, 0x0,
    0x1, 0x82,

    /* U+3D "=" */
    0x1b, 0xbb, 0xb8, 0x3, 0x33, 0x32, 0x4, 0x44,
    0x43, 0x1a, 0xaa, 0xa8,

    /* U+3E ">" */
    0x12, 0x0, 0x0, 0x2e, 0xa3, 0x0, 0x0, 0x5b,
    0xc5, 0x0, 0x5, 0xda, 0x19, 0xea, 0x30, 0x28,
    0x10, 0x0,

    /* U+3F "?" */
    0x4, 0x98, 0x20, 0x4e, 0x58, 0xe0, 0x34, 0x0,
    0xe2, 0x0, 0x3, 0xe0, 0x0, 0x2e, 0x50, 0x0,
    0xb7, 0x0, 0x0, 0x82, 0x0, 0x0, 0x10, 0x0,
    0x0, 0xd3, 0x0, 0x0, 0x0, 0x0,

    /* U+40 "@" */
    0x0, 0x0, 0x35, 0x41, 0x0, 0x0, 0x3, 0xc9,
    0x67, 0xc7, 0x0, 0x2, 0xc1, 0x0, 0x0, 0x85,
    0x0, 0xa3, 0x4, 0xba, 0x20, 0xb0, 0xd, 0x2,
    0xc1, 0x86, 0xb, 0x13, 0xa0, 0x86, 0x9, 0x40,
    0xa2, 0x58, 0xb, 0x20, 0xa3, 0xa, 0x14, 0x90,
    0xb3, 0xe, 0x20, 0xc0, 0x1c, 0x5, 0xeb, 0x7c,
    0xb4, 0x0, 0xa5, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xc7, 0x21, 0x42, 0x0, 0x0, 0x0, 0x59, 0xa7,
    0x10, 0x0,

    /* U+41 "A" */
    0x0, 0x5, 0x40, 0x0, 0x0, 0xe, 0xc0, 0x0,
    0x0, 0x5a, 0xd3, 0x0, 0x0, 0xb5, 0x79, 0x0,
    0x1, 0xe0, 0x1e, 0x0, 0x7, 0xa2, 0x2c, 0x50,
    0xd, 0xcb, 0xbc, 0xb0, 0x4d, 0x0, 0x0, 0xf1,
    0xa8, 0x0, 0x0, 0xa7,

    /* U+42 "B" */
    0x8, 0x88, 0x72, 0x0, 0xf7, 0x68, 0xf3, 0xf,
    0x10, 0x9, 0x80, 0xf1, 0x1, 0xd5, 0xf, 0xed,
    0xfb, 0x0, 0xf1, 0x1, 0xb7, 0xf, 0x10, 0x5,
    0xc0, 0xf1, 0x0, 0xb9, 0xf, 0xfe, 0xea, 0x10,

    /* U+43 "C" */
    0x0, 0x39, 0x95, 0x0, 0x5, 0xe6, 0x5c, 0x90,
    0xe, 0x30, 0x1, 0xf1, 0x2e, 0x0, 0x0, 0x20,
    0x4d, 0x0, 0x0, 0x0, 0x3d, 0x0, 0x0, 0x0,
    0x1f, 0x10, 0x0, 0xb2, 0xa, 0x90, 0x5, 0xd0,
    0x1, 0xae, 0xdc, 0x20, 0x0, 0x0, 0x0, 0x0,

    /* U+44 "D" */
    0x8, 0x88, 0x50, 0x0, 0xf, 0x76, 0xad, 0x20,
    0xf, 0x10, 0x7, 0xb0, 0xf, 0x10, 0x1, 0xf0,
    0xf, 0x10, 0x0, 0xf2, 0xf, 0x10, 0x0, 0xf1,
    0xf, 0x10, 0x4, 0xe0, 0xf, 0x10, 0x3d, 0x60,
    0xf, 0xff, 0xd6, 0x0,

    /* U+45 "E" */
    0x8, 0x88, 0x88, 0x30, 0xf7, 0x66, 0x62, 0xf,
    0x10, 0x0, 0x0, 0xf1, 0x0, 0x0, 0xf, 0xdd,
    0xdb, 0x0, 0xf2, 0x11, 0x0, 0xf, 0x10, 0x0,
    0x0, 0xf1, 0x0, 0x0, 0xf, 0xee, 0xee, 0x50,

    /* U+46 "F" */
    0x8, 0x88, 0x88, 0x20, 0xf7, 0x66, 0x61, 0xf,
    0x10, 0x0, 0x0, 0xf1, 0x0, 0x0, 0xf, 0xbb,
    0xb7, 0x0, 0xf5, 0x33, 0x20, 0xf, 0x10, 0x0,
    0x0, 0xf1, 0x0, 0x0, 0xf, 0x10, 0x0, 0x0,

    /* U+47 "G" */
    0x0, 0x49, 0x95, 0x0, 0x6, 0xe6, 0x5b, 0xa0,
    0xe, 0x30, 0x0, 0xf2, 0x2f, 0x0, 0x0, 0x0,
    0x4d, 0x0, 0x34, 0x41, 0x3e, 0x0, 0x8a, 0xf4,
    0xf, 0x10, 0x0, 0xd4, 0x9, 0xb0, 0x0, 0xe4,
    0x0, 0xae, 0xde, 0x90, 0x0, 0x0, 0x10, 0x0,

    /* U+48 "H" */
    0x8, 0x0, 0x0, 0x44, 0xf, 0x10, 0x0, 0x98,
    0xf, 0x10, 0x0, 0x98, 0xf, 0x10, 0x0, 0x98,
    0xf, 0xdd, 0xdd, 0xf8, 0xf, 0x21, 0x11, 0x98,
    0xf, 0x10, 0x0, 0x98, 0xf, 0x10, 0x0, 0x98,
    0xf, 0x10, 0x0, 0x98,

    /* U+49 "I" */
    0x71, 0xe3, 0xe3, 0xe3, 0xe3, 0xe3, 0xe3, 0xe3,
    0xe3,

    /* U+4A "J" */
    0x0, 0x0, 0x36, 0x0, 0x0, 0x7b, 0x0, 0x0,
    0x7b, 0x0, 0x0, 0x7b, 0x0, 0x0, 0x7b, 0x0,
    0x0, 0x7b, 0x32, 0x0, 0x7a, 0x8b, 0x0, 0xb7,
    0x1b, 0xee, 0xb0, 0x0, 0x0, 0x0,

    /* U+4B "K" */
    0x8, 0x0, 0x2, 0x80, 0xf, 0x10, 0x1e, 0x50,
    0xf, 0x11, 0xd7, 0x0, 0xf, 0x2c, 0x80, 0x0,
    0xf, 0xcf, 0x20, 0x0, 0xf, 0xa8, 0xd0, 0x0,
    0xf, 0x10, 0xba, 0x0, 0xf, 0x10, 0x1d, 0x60,
    0xf, 0x10, 0x3, 0xf3,

    /* U+4C "L" */
    0x8, 0x10, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf,
    0x20, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20,
    0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0xf2, 0x0, 0x0, 0xf, 0xee, 0xee, 0x20,

    /* U+4D "M" */
    0x8, 0x40, 0x0, 0x0, 0x84, 0xf, 0xd0, 0x0,
    0x6, 0xf7, 0xf, 0xd4, 0x0, 0xc, 0xd7, 0xf,
    0x7a, 0x0, 0x2e, 0x97, 0xf, 0x2e, 0x10, 0x97,
    0x97, 0xf, 0x19, 0x70, 0xe1, 0xa7, 0xf, 0x13,
    0xd6, 0xa0, 0xa7, 0xf, 0x10, 0xce, 0x40, 0xa7,
    0xf, 0x10, 0x6d, 0x0, 0xa7,

    /* U+4E "N" */
    0x8, 0x20, 0x0, 0x44, 0xf, 0xc0, 0x0, 0x98,
    0xf, 0xe7, 0x0, 0x98, 0xf, 0x4f, 0x20, 0x98,
    0xf, 0x28, 0xb0, 0x98, 0xf, 0x20, 0xd6, 0x98,
    0xf, 0x20, 0x3e, 0xb8, 0xf, 0x20, 0x8, 0xf8,
    0xf, 0x20, 0x0, 0xd8,

    /* U+4F "O" */
    0x0, 0x39, 0x95, 0x0, 0x5, 0xe7, 0x6d, 0x90,
    0xe, 0x40, 0x1, 0xe2, 0x2e, 0x0, 0x0, 0xa6,
    0x4d, 0x0, 0x0, 0x98, 0x3d, 0x0, 0x0, 0x97,
    0x1f, 0x10, 0x0, 0xc5, 0xa, 0xa0, 0x6, 0xd0,
    0x1, 0xae, 0xec, 0x30, 0x0, 0x0, 0x10, 0x0,

    /* U+50 "P" */
    0x8, 0x88, 0x74, 0x0, 0xf, 0x76, 0x7d, 0x80,
    0xf, 0x10, 0x2, 0xf0, 0xf, 0x10, 0x1, 0xf0,
    0xf, 0x54, 0x5b, 0xb0, 0xf, 0xba, 0x96, 0x0,
    0xf, 0x10, 0x0, 0x0, 0xf, 0x10, 0x0, 0x0,
    0xf, 0x10, 0x0, 0x0,

    /* U+51 "Q" */
    0x0, 0x49, 0x95, 0x0, 0x6, 0xe7, 0x6d, 0x80,
    0xe, 0x30, 0x1, 0xf2, 0x3e, 0x0, 0x0, 0xb5,
    0x5c, 0x0, 0x0, 0xa7, 0x4d, 0x0, 0x0, 0xa7,
    0x2f, 0x0, 0x0, 0xd4, 0xa, 0x90, 0x7, 0xd0,
    0x1, 0xbe, 0xef, 0x40, 0x0, 0x0, 0x16, 0xe3,
    0x0, 0x0, 0x0, 0x30,

    /* U+52 "R" */
    0x8, 0x88, 0x72, 0x0, 0xf, 0x76, 0x8e, 0x40,
    0xf, 0x10, 0x7, 0xb0, 0xf, 0x10, 0x7, 0xb0,
    0xf, 0x76, 0x8e, 0x40, 0xf, 0x98, 0xe6, 0x0,
    0xf, 0x10, 0x5d, 0x0, 0xf, 0x10, 0xc, 0x60,
    0xf, 0x10, 0x4, 0xe0,

    /* U+53 "S" */
    0x0, 0x79, 0x82, 0x0, 0xc9, 0x57, 0xe2, 0x3e,
    0x0, 0x8, 0x81, 0xf6, 0x0, 0x0, 0x3, 0xde,
    0x82, 0x0, 0x0, 0x39, 0xe3, 0x34, 0x0, 0x8,
    0x94, 0xe2, 0x0, 0xb8, 0x6, 0xed, 0xea, 0x0,
    0x0, 0x10, 0x0,

    /* U+54 "T" */
    0x68, 0x88, 0x88, 0x74, 0x66, 0xf7, 0x65, 0x0,
    0xf, 0x20, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf,
    0x20, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20,
    0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20, 0x0,

    /* U+55 "U" */
    0x18, 0x0, 0x1, 0x82, 0xe0, 0x0, 0x2f, 0x2e,
    0x0, 0x2, 0xf2, 0xe0, 0x0, 0x2f, 0x2e, 0x0,
    0x2, 0xf2, 0xe0, 0x0, 0x2f, 0x1f, 0x0, 0x3,
    0xf0, 0xd6, 0x0, 0x9a, 0x3, 0xdd, 0xeb, 0x10,
    0x0, 0x0, 0x0,

    /* U+56 "V" */
    0x64, 0x0, 0x0, 0x73, 0x7b, 0x0, 0x1, 0xf1,
    0x1f, 0x10, 0x7, 0xb0, 0xb, 0x60, 0xc, 0x50,
    0x5, 0xc0, 0x2f, 0x0, 0x0, 0xe2, 0x79, 0x0,
    0x0, 0x97, 0xd3, 0x0, 0x0, 0x3e, 0xd0, 0x0,
    0x0, 0xd, 0x70, 0x0,

    /* U+57 "W" */
    0x44, 0x0, 0x18, 0x0, 0x6, 0x26, 0xb0, 0x5,
    0xf2, 0x0, 0xf2, 0x2f, 0x0, 0xad, 0x60, 0x3e,
    0x0, 0xe2, 0xe, 0x5b, 0x6, 0xa0, 0xa, 0x63,
    0xc0, 0xe0, 0xa6, 0x0, 0x6a, 0x87, 0xb, 0x4e,
    0x20, 0x2, 0xdc, 0x20, 0x69, 0xe0, 0x0, 0xe,
    0xd0, 0x2, 0xfb, 0x0, 0x0, 0xb9, 0x0, 0xd,
    0x70, 0x0,

    /* U+58 "X" */
    0x37, 0x0, 0x3, 0x80, 0xe, 0x50, 0xc, 0x70,
    0x4, 0xe1, 0x7d, 0x0, 0x0, 0xab, 0xf3, 0x0,
    0x0, 0x1f, 0xa0, 0x0, 0x0, 0x6e, 0xe1, 0x0,
    0x1, 0xe4, 0xb9, 0x0, 0xb, 0x90, 0x1f, 0x40,
    0x5e, 0x10, 0x7, 0xd0,

    /* U+59 "Y" */
    0x64, 0x0, 0x2, 0x70, 0x5e, 0x0, 0xb, 0x80,
    0xc, 0x60, 0x3e, 0x0, 0x3, 0xe0, 0xb6, 0x0,
    0x0, 0xbb, 0xd0, 0x0, 0x0, 0x2f, 0x50, 0x0,
    0x0, 0xf, 0x20, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0xf, 0x20, 0x0,

    /* U+5A "Z" */
    0x38, 0x88, 0x88, 0x42, 0x66, 0x67, 0xf5, 0x0,
    0x0, 0x9b, 0x0, 0x0, 0x4e, 0x10, 0x0, 0x1e,
    0x50, 0x0, 0xa, 0x90, 0x0, 0x5, 0xd0, 0x0,
    0x1, 0xe3, 0x0, 0x0, 0x7f, 0xee, 0xee, 0xa0,

    /* U+5B "[" */
    0x1c, 0xc0, 0x2f, 0x20, 0x2f, 0x0, 0x2f, 0x0,
    0x2f, 0x0, 0x2f, 0x0, 0x2f, 0x0, 0x2f, 0x0,
    0x2f, 0x0, 0x2f, 0x0, 0x2f, 0x10, 0x1d, 0xd0,

    /* U+5C "\\" */
    0x53, 0x0, 0x5, 0xa0, 0x0, 0xe, 0x10, 0x0,
    0x96, 0x0, 0x3, 0xd0, 0x0, 0xd, 0x30, 0x0,
    0x79, 0x0, 0x1, 0xe0, 0x0, 0xa, 0x50, 0x0,
    0x48,

    /* U+5D "]" */
    0xbc, 0x32, 0xd4, 0xd, 0x40, 0xd4, 0xd, 0x40,
    0xd4, 0xd, 0x40, 0xd4, 0xd, 0x40, 0xd4, 0xd,
    0x4c, 0xd3,

    /* U+5E "^" */
    0x0, 0x70, 0x0, 0x4f, 0x40, 0xb, 0x8b, 0x1,
    0xd0, 0xd2, 0x56, 0x6, 0x50,

    /* U+5F "_" */
    0xde, 0xee, 0xe5,

    /* U+60 "`" */
    0x4d, 0x10, 0x56,

    /* U+61 "a" */
    0x0, 0x56, 0x20, 0xc, 0x97, 0xe4, 0x15, 0x0,
    0x79, 0x4, 0xbc, 0xea, 0x2e, 0x20, 0x7a, 0x4d,
    0x0, 0xaa, 0xb, 0xee, 0xbc, 0x0, 0x0, 0x0,

    /* U+62 "b" */
    0x2e, 0x0, 0x0, 0x2, 0xe0, 0x0, 0x0, 0x2e,
    0x26, 0x40, 0x2, 0xfb, 0x8d, 0x80, 0x2f, 0x0,
    0x2f, 0x2, 0xe0, 0x0, 0xe2, 0x2e, 0x0, 0xf,
    0x12, 0xf2, 0x5, 0xd0, 0x2e, 0xbd, 0xe4, 0x0,
    0x0, 0x0, 0x0,

    /* U+63 "c" */
    0x0, 0x46, 0x20, 0xa, 0xb7, 0xd5, 0x3d, 0x0,
    0x3a, 0x6a, 0x0, 0x0, 0x6a, 0x0, 0x0, 0x2e,
    0x10, 0x5b, 0x5, 0xed, 0xc2, 0x0, 0x0, 0x0,

    /* U+64 "d" */
    0x0, 0x0, 0x2e, 0x0, 0x0, 0x2e, 0x0, 0x55,
    0x3e, 0xb, 0xc8, 0xce, 0x3e, 0x0, 0x3e, 0x6a,
    0x0, 0x2e, 0x5b, 0x0, 0x2e, 0x1f, 0x20, 0x6e,
    0x6, 0xed, 0xae, 0x0, 0x0, 0x0,

    /* U+65 "e" */
    0x0, 0x46, 0x20, 0x9, 0xb7, 0xd4, 0x3d, 0x0,
    0x4c, 0x6e, 0xbb, 0xce, 0x6b, 0x22, 0x21, 0x2e,
    0x20, 0x15, 0x5, 0xed, 0xe4, 0x0, 0x1, 0x0,

    /* U+66 "f" */
    0x0, 0x1, 0x0, 0x2e, 0xd2, 0x9, 0x80, 0x3,
    0xc9, 0x40, 0x5d, 0xb6, 0x0, 0xa7, 0x0, 0xa,
    0x70, 0x0, 0xa7, 0x0, 0xa, 0x70, 0x0, 0xa7,
    0x0,

    /* U+67 "g" */
    0x0, 0x55, 0x14, 0xb, 0xc8, 0xce, 0x3e, 0x0,
    0x3e, 0x6b, 0x0, 0x2e, 0x5b, 0x0, 0x2e, 0x1f,
    0x20, 0x6e, 0x6, 0xed, 0xbe, 0x0, 0x0, 0x4c,
    0xc, 0x87, 0xd5, 0x0, 0x67, 0x30,

    /* U+68 "h" */
    0x2e, 0x0, 0x0, 0x2e, 0x0, 0x0, 0x2e, 0x16,
    0x50, 0x2f, 0xb8, 0xd7, 0x2f, 0x0, 0x5c, 0x2e,
    0x0, 0x4c, 0x2e, 0x0, 0x4c, 0x2e, 0x0, 0x4c,
    0x2e, 0x0, 0x4c,

    /* U+69 "i" */
    0x8, 0x0, 0x70, 0x5, 0x1, 0xf0, 0x1f, 0x1,
    0xf0, 0x1f, 0x1, 0xf0, 0x1f, 0x0,

    /* U+6A "j" */
    0x1, 0x80, 0x17, 0x0, 0x50, 0x2e, 0x2, 0xe0,
    0x2e, 0x2, 0xe0, 0x2e, 0x2, 0xe0, 0x2e, 0x29,
    0xc3, 0x82,

    /* U+6B "k" */
    0x2e, 0x0, 0x0, 0x2, 0xe0, 0x0, 0x0, 0x2e,
    0x0, 0x33, 0x2, 0xe0, 0x5d, 0x10, 0x2e, 0x4e,
    0x20, 0x2, 0xff, 0x80, 0x0, 0x2f, 0x5e, 0x30,
    0x2, 0xe0, 0x5e, 0x10, 0x2e, 0x0, 0x9b, 0x0,

    /* U+6C "l" */
    0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f,
    0x1f,

    /* U+6D "m" */
    0x14, 0x26, 0x40, 0x36, 0x40, 0x3f, 0xb7, 0xdb,
    0xb8, 0xe5, 0x3e, 0x0, 0x5e, 0x0, 0x6a, 0x3e,
    0x0, 0x4c, 0x0, 0x6b, 0x3e, 0x0, 0x4c, 0x0,
    0x6b, 0x3e, 0x0, 0x4c, 0x0, 0x6b, 0x3e, 0x0,
    0x4c, 0x0, 0x6b,

    /* U+6E "n" */
    0x4, 0x16, 0x50, 0x2f, 0xb8, 0xd7, 0x2f, 0x0,
    0x5c, 0x2e, 0x0, 0x4c, 0x2e, 0x0, 0x4c, 0x2e,
    0x0, 0x4c, 0x2e, 0x0, 0x4c,

    /* U+6F "o" */
    0x0, 0x46, 0x30, 0x0, 0x9c, 0x8d, 0x70, 0x3e,
    0x0, 0x1f, 0x16, 0xa0, 0x0, 0xd4, 0x5b, 0x0,
    0xd, 0x31, 0xe2, 0x4, 0xe0, 0x5, 0xdd, 0xd3,
    0x0, 0x0, 0x0, 0x0,

    /* U+70 "p" */
    0x4, 0x26, 0x40, 0x2, 0xfb, 0x8e, 0x80, 0x2e,
    0x0, 0x2f, 0x2, 0xe0, 0x0, 0xf2, 0x2e, 0x0,
    0xf, 0x12, 0xf1, 0x5, 0xd0, 0x2f, 0xbd, 0xe3,
    0x2, 0xe0, 0x0, 0x0, 0x2e, 0x0, 0x0, 0x1,
    0x60, 0x0, 0x0,

    /* U+71 "q" */
    0x0, 0x56, 0x14, 0xb, 0xb7, 0xce, 0x3e, 0x0,
    0x3e, 0x6a, 0x0, 0x3e, 0x5b, 0x0, 0x3e, 0x2f,
    0x20, 0x5e, 0x6, 0xed, 0xbe, 0x0, 0x0, 0x3e,
    0x0, 0x0, 0x3e, 0x0, 0x0, 0x16,

    /* U+72 "r" */
    0x4, 0x25, 0x2f, 0xd8, 0x2f, 0x0, 0x2e, 0x0,
    0x2e, 0x0, 0x2e, 0x0, 0x2e, 0x0,

    /* U+73 "s" */
    0x0, 0x56, 0x10, 0xd, 0x98, 0xe3, 0x2e, 0x0,
    0x54, 0x9, 0xe9, 0x30, 0x0, 0x15, 0xd5, 0x4c,
    0x0, 0x98, 0x9, 0xed, 0xc1, 0x0, 0x0, 0x0,

    /* U+74 "t" */
    0xb, 0x40, 0x5d, 0x82, 0x8e, 0xa4, 0xc, 0x40,
    0xc, 0x40, 0xc, 0x40, 0xc, 0x50, 0x7, 0xe6,
    0x0, 0x10,

    /* U+75 "u" */
    0x14, 0x0, 0x14, 0x3d, 0x0, 0x4c, 0x3d, 0x0,
    0x4c, 0x3d, 0x0, 0x4c, 0x3e, 0x0, 0x4c, 0x1f,
    0x10, 0x8c, 0x9, 0xed, 0xbc, 0x0, 0x0, 0x0,

    /* U+76 "v" */
    0x41, 0x0, 0x32, 0x89, 0x0, 0xc4, 0x2e, 0x1,
    0xe0, 0xc, 0x37, 0x90, 0x6, 0x9c, 0x30, 0x1,
    0xed, 0x0, 0x0, 0xb7, 0x0,

    /* U+77 "w" */
    0x32, 0x0, 0x50, 0x2, 0x38, 0x80, 0x3f, 0x30,
    0x87, 0x3c, 0x8, 0xc7, 0xc, 0x30, 0xe1, 0xd2,
    0xc1, 0xe0, 0xa, 0x7b, 0xc, 0x79, 0x0, 0x5f,
    0x60, 0x7e, 0x50, 0x1, 0xf2, 0x2, 0xf0, 0x0,

    /* U+78 "x" */
    0x33, 0x0, 0x42, 0x2e, 0x12, 0xe1, 0x7, 0xac,
    0x60, 0x0, 0xdc, 0x0, 0x2, 0xee, 0x10, 0xc,
    0x67, 0xb0, 0x6c, 0x0, 0xd5,

    /* U+79 "y" */
    0x42, 0x0, 0x32, 0x99, 0x0, 0xe3, 0x3e, 0x3,
    0xe0, 0xd, 0x48, 0x80, 0x7, 0x9d, 0x30, 0x2,
    0xfd, 0x0, 0x0, 0xc8, 0x0, 0x0, 0xd2, 0x0,
    0x39, 0xb0, 0x0, 0x47, 0x0, 0x0,

    /* U+7A "z" */
    0x25, 0x55, 0x52, 0x38, 0x89, 0xf4, 0x0, 0xa,
    0x80, 0x0, 0x7c, 0x0, 0x3, 0xe2, 0x0, 0x1d,
    0x50, 0x0, 0x7f, 0xdd, 0xd7,

    /* U+7B "{" */
    0x0, 0x2, 0x0, 0xb8, 0x3, 0xd0, 0x5, 0xb0,
    0x6, 0xa0, 0xa, 0x70, 0x8f, 0x10, 0x8, 0x80,
    0x6, 0xb0, 0x5, 0xb0, 0x2, 0xe0, 0x0, 0x7a,
    0x0, 0x0,

    /* U+7C "|" */
    0x7e, 0xee, 0xee, 0xee, 0xee, 0x80,

    /* U+7D "}" */
    0x20, 0x0, 0x7b, 0x0, 0xc, 0x40, 0xa, 0x60,
    0xa, 0x60, 0x6, 0xb1, 0x1, 0xe9, 0x7, 0x90,
    0xa, 0x60, 0xa, 0x60, 0xd, 0x30, 0x98, 0x0,
    0x0, 0x0,

    /* U+7E "~" */
    0x3, 0xa7, 0x0, 0x43, 0xe, 0x5a, 0xc5, 0xd2,
    0x15, 0x0, 0x59, 0x40,

    /* U+F001 "" */
    0x0, 0x0, 0x0, 0x0, 0x15, 0x0, 0x0, 0x0,
    0x27, 0xcf, 0xf4, 0x0, 0x4, 0xdf, 0xff, 0xff,
    0x40, 0x0, 0x9f, 0xff, 0xff, 0xf4, 0x0, 0x9,
    0xff, 0xfb, 0x6a, 0x40, 0x0, 0x9b, 0x40, 0x0,
    0x94, 0x0, 0x9, 0x40, 0x0, 0x9, 0x40, 0x0,
    0x94, 0x1, 0x78, 0xb4, 0x0, 0x9, 0x40, 0xef,
    0xff, 0x45, 0xcc, 0xd4, 0x7, 0xef, 0xa0, 0xef,
    0xff, 0x30, 0x0, 0x0, 0x3, 0x9a, 0x50, 0x0,
    0x0, 0x0,

    /* U+F008 "" */
    0x36, 0x66, 0x66, 0x66, 0x66, 0x66, 0x2e, 0x6b,
    0xb6, 0x66, 0x66, 0xca, 0x7c, 0xd0, 0x76, 0x0,
    0x0, 0x9, 0x40, 0xdf, 0xef, 0x60, 0x0, 0x0,
    0x9e, 0xed, 0xe0, 0x76, 0x0, 0x0, 0x9, 0x50,
    0xde, 0x4a, 0xa4, 0x44, 0x44, 0xc8, 0x5d, 0xf9,
    0xdd, 0x99, 0x99, 0x9d, 0xca, 0xdd, 0x6, 0x60,
    0x0, 0x0, 0x94, 0xd, 0xfb, 0xe6, 0x0, 0x0,
    0x9, 0xdc, 0xde, 0x28, 0x60, 0x0, 0x0, 0x96,
    0x3d, 0xe2, 0x88, 0x22, 0x22, 0x2b, 0x63, 0xd7,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb5,

    /* U+F00B "" */
    0x46, 0x61, 0x36, 0x66, 0x66, 0x64, 0xff, 0xf6,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xaf, 0xff,
    0xff, 0xff, 0x12, 0x20, 0x2, 0x22, 0x22, 0x21,
    0xef, 0xf4, 0x9f, 0xff, 0xff, 0xfe, 0xff, 0xf6,
    0xbf, 0xff, 0xff, 0xff, 0x79, 0x92, 0x49, 0x99,
    0x99, 0x97, 0x79, 0x92, 0x49, 0x99, 0x99, 0x97,
    0xff, 0xf6, 0xbf, 0xff, 0xff, 0xff, 0xef, 0xf4,
    0x9f, 0xff, 0xff, 0xfe,

    /* U+F00C "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3e, 0x70, 0x0, 0x0, 0x0, 0x3,
    0xff, 0xf1, 0x2, 0x80, 0x0, 0x3f, 0xff, 0x70,
    0xe, 0xfb, 0x3, 0xff, 0xf7, 0x0, 0xd, 0xff,
    0xcf, 0xff, 0x70, 0x0, 0x1, 0xcf, 0xff, 0xf7,
    0x0, 0x0, 0x0, 0x1d, 0xff, 0x70, 0x0, 0x0,
    0x0, 0x1, 0xb7, 0x0, 0x0, 0x0,

    /* U+F00D "" */
    0x5, 0xb1, 0x0, 0x69, 0x2, 0xff, 0xd1, 0x7f,
    0xf8, 0xb, 0xff, 0xef, 0xff, 0x30, 0xb, 0xff,
    0xff, 0x30, 0x0, 0x7f, 0xff, 0xd1, 0x0, 0x7f,
    0xff, 0xff, 0xd1, 0x2f, 0xff, 0x4b, 0xff, 0x90,
    0x9f, 0x30, 0xb, 0xe2, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F011 "" */
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xe0, 0x0, 0x0, 0x0, 0x71, 0xbf, 0x6, 0x20,
    0x0, 0xcf, 0x4b, 0xf0, 0xff, 0x20, 0x7f, 0x90,
    0xbf, 0x4, 0xfb, 0xd, 0xe0, 0xb, 0xf0, 0xa,
    0xf1, 0xfc, 0x0, 0x47, 0x0, 0x7f, 0x3e, 0xd0,
    0x0, 0x0, 0x9, 0xf3, 0xaf, 0x40, 0x0, 0x1,
    0xee, 0x2, 0xfe, 0x50, 0x3, 0xcf, 0x60, 0x5,
    0xff, 0xfe, 0xff, 0x90, 0x0, 0x2, 0x8c, 0xda,
    0x40, 0x0,

    /* U+F013 "" */
    0x0, 0x0, 0x56, 0x0, 0x0, 0x0, 0x15, 0xf,
    0xf3, 0x33, 0x0, 0xd, 0xfd, 0xff, 0xef, 0xe2,
    0x0, 0xaf, 0xff, 0xff, 0xfd, 0x0, 0x5b, 0xfd,
    0x21, 0xbf, 0xd5, 0xf, 0xff, 0x70, 0x3, 0xff,
    0xf4, 0xbe, 0xfa, 0x0, 0x6f, 0xfc, 0x30, 0x7f,
    0xfc, 0xaf, 0xfb, 0x0, 0xe, 0xff, 0xff, 0xff,
    0xf3, 0x0, 0x4c, 0x4f, 0xf7, 0x99, 0x0, 0x0,
    0x0, 0xbd, 0x20, 0x0, 0x0,

    /* U+F014 "" */
    0x0, 0x5, 0x66, 0x10, 0x0, 0x0, 0x6a, 0x66,
    0xc0, 0x0, 0xbb, 0xec, 0xbb, 0xfc, 0xb4, 0x3c,
    0x22, 0x22, 0x26, 0xa0, 0x2b, 0x33, 0x61, 0x74,
    0x90, 0x2b, 0x66, 0xb2, 0xd4, 0x90, 0x2b, 0x66,
    0xb2, 0xd4, 0x90, 0x2b, 0x66, 0xb2, 0xd4, 0x90,
    0x2b, 0x44, 0x81, 0x94, 0x90, 0x2c, 0x0, 0x0,
    0x5, 0x80, 0xa, 0xdd, 0xdd, 0xdd, 0x30,

    /* U+F015 "" */
    0x0, 0x0, 0x18, 0x22, 0x93, 0x0, 0x0, 0x2d,
    0xce, 0x8f, 0x60, 0x0, 0x4e, 0x8a, 0x7f, 0xf6,
    0x0, 0x7e, 0x7e, 0xff, 0x7e, 0xa0, 0x8d, 0x8f,
    0xff, 0xff, 0x8c, 0xb3, 0x4f, 0xff, 0xff, 0xff,
    0x64, 0x4, 0xff, 0xd6, 0xbf, 0xf6, 0x0, 0x4f,
    0xfb, 0x9, 0xff, 0x60, 0x3, 0xff, 0xb0, 0x9f,
    0xf5, 0x0,

    /* U+F019 "" */
    0x0, 0x0, 0x24, 0x20, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xd0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xd0, 0x0, 0x0,
    0x0, 0xad, 0xff, 0xfd, 0xc0, 0x0, 0x0, 0x2e,
    0xff, 0xff, 0x40, 0x0, 0x0, 0x2, 0xef, 0xf4,
    0x0, 0x0, 0x46, 0x65, 0x3d, 0x45, 0x66, 0x50,
    0xff, 0xff, 0xa3, 0x9f, 0xff, 0xf2, 0xff, 0xff,
    0xff, 0xfd, 0xaa, 0xd2, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xe1,

    /* U+F01C "" */
    0x1, 0x99, 0x99, 0x99, 0x30, 0x0, 0x8e, 0xbb,
    0xbb, 0xdd, 0x0, 0xe, 0x60, 0x0, 0x2, 0xf4,
    0x6, 0xf0, 0x0, 0x0, 0xb, 0xa0, 0xc9, 0x0,
    0x0, 0x0, 0x4f, 0x1f, 0xed, 0x90, 0x5, 0xdd,
    0xf4, 0xff, 0xff, 0x99, 0xdf, 0xff, 0x4f, 0xff,
    0xff, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x30,

    /* U+F021 "" */
    0x0, 0x2, 0x56, 0x30, 0x0, 0x0, 0x1b, 0xff,
    0xff, 0xd3, 0xc3, 0xc, 0xfb, 0x55, 0x9f, 0xff,
    0x46, 0xf9, 0x0, 0x0, 0xdf, 0xf4, 0xac, 0x0,
    0x0, 0x6d, 0xdd, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x56, 0x64, 0x0, 0x0, 0x36, 0xf, 0xff,
    0x80, 0x0, 0x1e, 0xd0, 0xff, 0xf5, 0x0, 0x2c,
    0xf5, 0xf, 0xaf, 0xff, 0xef, 0xf8, 0x0, 0x40,
    0x29, 0xcc, 0xa3, 0x0, 0x0,

    /* U+F026 "" */
    0x0, 0x0, 0x30, 0x0, 0x5, 0xf2, 0x0, 0x5f,
    0xf2, 0xff, 0xff, 0xf2, 0xff, 0xff, 0xf2, 0xff,
    0xff, 0xf2, 0x56, 0xbf, 0xf2, 0x0, 0xb, 0xf2,
    0x0, 0x0, 0x91,

    /* U+F027 "" */
    0x0, 0x0, 0x30, 0x0, 0x0, 0x5, 0xf2, 0x0,
    0x0, 0x5f, 0xf2, 0x0, 0xff, 0xff, 0xf2, 0xa3,
    0xff, 0xff, 0xf2, 0x3a, 0xff, 0xff, 0xf2, 0x97,
    0x56, 0xbf, 0xf2, 0x30, 0x0, 0xb, 0xf2, 0x0,
    0x0, 0x0, 0x91, 0x0,

    /* U+F028 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x30, 0x6, 0xb1, 0x0, 0x0, 0x5, 0xf2, 0x15,
    0x4d, 0x10, 0x0, 0x5f, 0xf2, 0xa, 0x95, 0x90,
    0xff, 0xff, 0xf2, 0xa3, 0xc2, 0xd0, 0xff, 0xff,
    0xf2, 0x3a, 0x76, 0xc1, 0xff, 0xff, 0xf2, 0x97,
    0x94, 0xd0, 0x56, 0xbf, 0xf2, 0x34, 0xd2, 0xc0,
    0x0, 0xb, 0xf2, 0x1b, 0x2c, 0x40, 0x0, 0x0,
    0x91, 0x2, 0xc6, 0x0, 0x0, 0x0, 0x0, 0x3,
    0x20, 0x0,

    /* U+F03E "" */
    0x36, 0x66, 0x66, 0x66, 0x66, 0x66, 0x2e, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x6c, 0xd0, 0x88, 0x0,
    0x0, 0x0, 0x0, 0xdd, 0x3f, 0xf3, 0x0, 0x5,
    0x0, 0xd, 0xd0, 0xbb, 0x0, 0xb, 0xf8, 0x0,
    0xdd, 0x0, 0x10, 0xb, 0xff, 0xf8, 0xd, 0xd0,
    0x1d, 0xac, 0xff, 0xff, 0xf2, 0xdd, 0x1d, 0xff,
    0xff, 0xff, 0xff, 0x2d, 0xd4, 0xff, 0xff, 0xff,
    0xff, 0xf2, 0xdd, 0x2, 0x22, 0x22, 0x22, 0x22,
    0xd, 0x9d, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0x70,

    /* U+F040 "" */
    0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xfc, 0x10, 0x0, 0x0, 0x3, 0x9f, 0xfc,
    0x0, 0x0, 0x6, 0xe9, 0x9f, 0xe0, 0x0, 0x6,
    0xdb, 0xf9, 0x83, 0x0, 0x6, 0xdc, 0xff, 0xe2,
    0x0, 0x6, 0xdc, 0xff, 0xf3, 0x0, 0x6, 0xfc,
    0xff, 0xe3, 0x0, 0x0, 0xe1, 0xcf, 0xe3, 0x0,
    0x0, 0xf, 0x93, 0xe3, 0x0, 0x0, 0x0, 0xdd,
    0xd3, 0x0, 0x0, 0x0, 0x0,

    /* U+F048 "" */
    0x53, 0x0, 0x0, 0x2f, 0xb0, 0x0, 0x4d, 0xfb,
    0x0, 0x4f, 0xdf, 0xb0, 0x4f, 0xfd, 0xfb, 0x4f,
    0xff, 0xdf, 0xef, 0xff, 0xfd, 0xfb, 0xaf, 0xff,
    0xdf, 0xb0, 0xaf, 0xfd, 0xfb, 0x0, 0xaf, 0xdf,
    0xb0, 0x0, 0xad, 0xc9, 0x0, 0x0, 0x80,

    /* U+F04B "" */
    0x50, 0x0, 0x0, 0x0, 0x0, 0xfd, 0x40, 0x0,
    0x0, 0x0, 0xff, 0xfb, 0x20, 0x0, 0x0, 0xff,
    0xff, 0xfa, 0x10, 0x0, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xe2, 0xff, 0xff,
    0xff, 0xfe, 0x60, 0xff, 0xff, 0xff, 0x80, 0x0,
    0xff, 0xff, 0x91, 0x0, 0x0, 0xff, 0xb2, 0x0,
    0x0, 0x0, 0xb3, 0x0, 0x0, 0x0, 0x0,

    /* U+F04C "" */
    0x56, 0x66, 0x10, 0x56, 0x66, 0x1f, 0xff, 0xf4,
    0xf, 0xff, 0xf4, 0xff, 0xff, 0x40, 0xff, 0xff,
    0x4f, 0xff, 0xf4, 0xf, 0xff, 0xf4, 0xff, 0xff,
    0x40, 0xff, 0xff, 0x4f, 0xff, 0xf4, 0xf, 0xff,
    0xf4, 0xff, 0xff, 0x40, 0xff, 0xff, 0x4f, 0xff,
    0xf4, 0xf, 0xff, 0xf4, 0xff, 0xff, 0x40, 0xff,
    0xff, 0x4f, 0xff, 0xf4, 0xf, 0xff, 0xf4, 0xcd,
    0xdd, 0x30, 0xcd, 0xdd, 0x30,

    /* U+F04D "" */
    0x56, 0x66, 0x66, 0x66, 0x66, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x4f, 0xff, 0xff, 0xff, 0xff,
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4f, 0xff,
    0xff, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xcd,
    0xdd, 0xdd, 0xdd, 0xdd, 0x30,

    /* U+F051 "" */
    0x20, 0x0, 0x4, 0x4f, 0x30, 0x0, 0xdd, 0xff,
    0x30, 0xd, 0xdf, 0xff, 0x30, 0xdd, 0xff, 0xff,
    0x3d, 0xdf, 0xff, 0xff, 0xed, 0xff, 0xff, 0x9d,
    0xdf, 0xff, 0x90, 0xdd, 0xff, 0x90, 0xd, 0xdf,
    0x80, 0x0, 0xdd, 0x80, 0x0, 0xa, 0xa0,

    /* U+F052 "" */
    0x0, 0x0, 0x35, 0x0, 0x0, 0x0, 0x0, 0x3e,
    0xf7, 0x0, 0x0, 0x0, 0x3e, 0xff, 0xf7, 0x0,
    0x0, 0x3e, 0xff, 0xff, 0xf7, 0x0, 0x3e, 0xff,
    0xff, 0xff, 0xf7, 0x8, 0x99, 0x99, 0x99, 0x99,
    0x91, 0x89, 0x99, 0x99, 0x99, 0x99, 0x1f, 0xff,
    0xff, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x30,

    /* U+F053 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf4, 0x0,
    0x5, 0xff, 0xd0, 0x5, 0xff, 0xe2, 0x5, 0xff,
    0xe2, 0x5, 0xff, 0xe2, 0x0, 0xcf, 0xf9, 0x0,
    0x1, 0xdf, 0xf8, 0x0, 0x1, 0xdf, 0xf8, 0x0,
    0x1, 0xdf, 0xf7, 0x0, 0x1, 0xdf, 0xb0, 0x0,
    0x1, 0x80,

    /* U+F054 "" */
    0x0, 0x0, 0x0, 0x0, 0xa, 0xd1, 0x0, 0x0,
    0x4f, 0xfd, 0x10, 0x0, 0x7, 0xff, 0xd1, 0x0,
    0x0, 0x7f, 0xfd, 0x10, 0x0, 0x7, 0xff, 0xd1,
    0x0, 0x1, 0xef, 0xf5, 0x0, 0x1d, 0xff, 0x70,
    0x1, 0xdf, 0xf7, 0x0, 0x1d, 0xff, 0x80, 0x0,
    0x2f, 0xf8, 0x0, 0x0, 0x3, 0x60, 0x0, 0x0,

    /* U+F067 "" */
    0x0, 0x2, 0x64, 0x0, 0x0, 0x0, 0x9, 0xff,
    0x0, 0x0, 0x0, 0x9, 0xff, 0x0, 0x0, 0x0,
    0x9, 0xff, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x79, 0x9d,
    0xff, 0x99, 0x92, 0x0, 0x9, 0xff, 0x0, 0x0,
    0x0, 0x9, 0xff, 0x0, 0x0, 0x0, 0x7, 0xfe,
    0x0, 0x0,

    /* U+F068 "" */
    0xef, 0xff, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0x79, 0x99, 0x99, 0x99, 0x92,

    /* U+F071 "" */
    0x0, 0x0, 0x1, 0x10, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xf7,
    0x0, 0x0, 0x0, 0x1, 0xff, 0xff, 0x10, 0x0,
    0x0, 0x9, 0xf3, 0x3f, 0x90, 0x0, 0x0, 0x2f,
    0xf1, 0x1f, 0xf2, 0x0, 0x0, 0xaf, 0xf1, 0x1f,
    0xfa, 0x0, 0x3, 0xff, 0xf8, 0x8f, 0xff, 0x30,
    0xb, 0xff, 0xf8, 0x8f, 0xff, 0xb0, 0x4f, 0xff,
    0xf2, 0x2f, 0xff, 0xf4, 0xdf, 0xff, 0xfe, 0xef,
    0xff, 0xfd, 0xad, 0xdd, 0xdd, 0xdd, 0xdd, 0xda,

    /* U+F074 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0x50, 0x99, 0x71, 0x0, 0x58,
    0x9d, 0xf5, 0xff, 0xfe, 0x2a, 0xff, 0xff, 0xfc,
    0x12, 0x6f, 0x8f, 0xb3, 0x2a, 0xc1, 0x0, 0x5,
    0xdf, 0x10, 0x5, 0x10, 0x0, 0x5, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xf9, 0x40, 0x8, 0x50,
    0x99, 0xcf, 0x8d, 0xfa, 0x9d, 0xf5, 0xff, 0xf9,
    0x4, 0xef, 0xff, 0xfc, 0x12, 0x0, 0x0, 0x1,
    0x2a, 0xc1, 0x0, 0x0, 0x0, 0x0, 0x5, 0x10,

    /* U+F077 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xb0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xfb,
    0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0xbf, 0xfa, 0xaf, 0xfb, 0x0, 0xb, 0xff,
    0xa0, 0xa, 0xff, 0xb0, 0x3f, 0xfa, 0x0, 0x0,
    0xaf, 0xf3, 0x6, 0x90, 0x0, 0x0, 0x9, 0x60,

    /* U+F078 "" */
    0x4, 0x70, 0x0, 0x0, 0x7, 0x40, 0x3f, 0xf8,
    0x0, 0x0, 0x8f, 0xf3, 0x1d, 0xff, 0x80, 0x8,
    0xff, 0xd1, 0x1, 0xdf, 0xf8, 0x8f, 0xfd, 0x10,
    0x0, 0x1c, 0xff, 0xff, 0xd1, 0x0, 0x0, 0x1,
    0xcf, 0xfd, 0x10, 0x0, 0x0, 0x0, 0x1c, 0xd1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F079 "" */
    0x0, 0x91, 0x6b, 0xbb, 0xbb, 0xb1, 0x0, 0xaf,
    0xc1, 0xdf, 0xff, 0xff, 0x20, 0x7f, 0xff, 0xa0,
    0x0, 0x9, 0xf2, 0xa, 0xcf, 0xdb, 0x0, 0x0,
    0x9f, 0x20, 0x4, 0xf6, 0x0, 0x1, 0x6b, 0xf7,
    0x40, 0x4f, 0x60, 0x0, 0x1e, 0xff, 0xf8, 0x4,
    0xfd, 0xbb, 0xb7, 0x3f, 0xfb, 0x0, 0x4f, 0xff,
    0xff, 0xf5, 0x5c, 0x0,

    /* U+F07B "" */
    0x16, 0x66, 0x20, 0x0, 0x0, 0x0, 0xdf, 0xff,
    0xe0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xfc, 0xbb,
    0xbb, 0x60, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf2, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xa0,

    /* U+F093 "" */
    0x0, 0x0, 0x1b, 0x20, 0x0, 0x0, 0x0, 0x1,
    0xdf, 0xe3, 0x0, 0x0, 0x0, 0x1d, 0xff, 0xfe,
    0x30, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xd0, 0x0,
    0x0, 0x0, 0xbf, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xd0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xd0,
    0x0, 0x0, 0x79, 0x96, 0x36, 0x45, 0x99, 0x80,
    0xff, 0xff, 0xcb, 0xcf, 0xff, 0xf2, 0xff, 0xff,
    0xff, 0xfd, 0x99, 0xd2, 0xbd, 0xdd, 0xdd, 0xdd,
    0xdd, 0xc0,

    /* U+F095 "" */
    0x5, 0x10, 0x0, 0x0, 0x0, 0x9f, 0xb0, 0x0,
    0x0, 0x0, 0xff, 0xf4, 0x0, 0x0, 0x0, 0xef,
    0xc1, 0x0, 0x0, 0x0, 0x8f, 0x50, 0x0, 0x0,
    0x0, 0x2f, 0xe1, 0x0, 0x0, 0x0, 0x6, 0xfc,
    0x10, 0x14, 0x0, 0x0, 0x8f, 0xe5, 0xcf, 0xb1,
    0x0, 0x6, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x28,
    0xef, 0x90,

    /* U+F0C4 "" */
    0x17, 0x83, 0x0, 0x0, 0x0, 0x0, 0xcb, 0x9e,
    0x60, 0x0, 0x2, 0x75, 0xe3, 0x2, 0xf0, 0x0,
    0x75, 0x18, 0x6e, 0x77, 0xf5, 0x56, 0x3, 0x60,
    0x4, 0x9a, 0x99, 0x40, 0x64, 0x0, 0x0, 0x55,
    0x65, 0x77, 0x81, 0x0, 0x3e, 0xcb, 0xe7, 0xa4,
    0x6, 0x30, 0xd6, 0x0, 0xf1, 0x4, 0x72, 0x45,
    0xe7, 0x4c, 0xa0, 0x0, 0x5, 0x77, 0x4c, 0xc7,
    0x0, 0x0, 0x0, 0x0,

    /* U+F0C5 "" */
    0x0, 0x1, 0x44, 0x41, 0x0, 0x0, 0x0, 0x3e,
    0xb9, 0xab, 0x0, 0x0, 0x3, 0xdb, 0x40, 0x2b,
    0x0, 0x0, 0x3d, 0x29, 0x40, 0x2d, 0xab, 0xb9,
    0xde, 0xde, 0x30, 0x5f, 0xa2, 0x2e, 0xd0, 0x0,
    0x4, 0xd6, 0x90, 0xd, 0xd0, 0x0, 0x4e, 0x57,
    0x90, 0xd, 0xd0, 0x0, 0xaa, 0x99, 0x30, 0xd,
    0xd0, 0x0, 0xb2, 0x0, 0x0, 0xd, 0xeb, 0xbb,
    0xe2, 0x0, 0x0, 0xd, 0x12, 0x22, 0xc2, 0x0,
    0x0, 0xd, 0x0, 0x0, 0xb4, 0x22, 0x22, 0x2e,
    0x0, 0x0, 0x6b, 0xbb, 0xbb, 0xb9,

    /* U+F0C7 "" */
    0x46, 0x66, 0x66, 0x63, 0x0, 0xe, 0x9f, 0xf9,
    0x6e, 0xc6, 0x0, 0xd4, 0xff, 0x40, 0xd0, 0xb6,
    0xd, 0x4f, 0xf4, 0xd, 0x0, 0xc2, 0xd2, 0xdd,
    0xdd, 0x90, 0x9, 0x4d, 0x0, 0x0, 0x0, 0x0,
    0x94, 0xd0, 0x66, 0x66, 0x66, 0x29, 0x4d, 0x4b,
    0x66, 0x66, 0x99, 0x94, 0xd4, 0x90, 0x0, 0x4,
    0x99, 0x4d, 0x49, 0x0, 0x0, 0x49, 0x94, 0xbd,
    0xdd, 0xdd, 0xdd, 0xdd, 0x20,

    /* U+F0E7 "" */
    0x4, 0x66, 0x0, 0xd, 0xfe, 0x0, 0x1f, 0xf8,
    0x0, 0x4f, 0xf3, 0x47, 0x8f, 0xff, 0xfa, 0xcf,
    0xff, 0xf3, 0x85, 0x2f, 0xb0, 0x0, 0x4f, 0x30,
    0x0, 0x8c, 0x0, 0x0, 0xc4, 0x0, 0x0, 0xc0,
    0x0, 0x1, 0x40, 0x0,

    /* U+F0F3 "" */
    0x0, 0x0, 0x1, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x1b, 0xb1, 0x0, 0x0, 0x0, 0x6, 0xff, 0xff,
    0x60, 0x0, 0x0, 0x2f, 0xff, 0xff, 0xf2, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x7f,
    0xff, 0xff, 0xf7, 0x0, 0x0, 0x9f, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xfd, 0x0,
    0x4, 0xff, 0xff, 0xff, 0xff, 0x40, 0x1d, 0xff,
    0xff, 0xff, 0xff, 0xd1, 0x5f, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0x0, 0x0, 0x8c, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x18, 0x91, 0x0, 0x0,

    /* U+F11C "" */
    0x8b, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x6d, 0x22,
    0x22, 0x22, 0x22, 0x22, 0x2d, 0xd3, 0x77, 0x3b,
    0x19, 0x55, 0xb2, 0xdd, 0x14, 0x13, 0x3, 0x12,
    0x2c, 0x2d, 0xd2, 0x93, 0x61, 0x72, 0x55, 0x91,
    0xdd, 0x25, 0x59, 0x99, 0x99, 0x36, 0x1d, 0xd1,
    0x22, 0x44, 0x44, 0x41, 0x30, 0xdc, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xda,

    /* U+F124 "" */
    0x0, 0x0, 0x0, 0x0, 0x53, 0x0, 0x0, 0x0,
    0x5d, 0xf2, 0x0, 0x0, 0x5d, 0xff, 0xa0, 0x0,
    0x5d, 0xff, 0xff, 0x20, 0x5d, 0xff, 0xff, 0xfa,
    0x0, 0x89, 0x99, 0xef, 0xf2, 0x0, 0x0, 0x0,
    0xbf, 0xa0, 0x0, 0x0, 0x0, 0xbf, 0x20, 0x0,
    0x0, 0x0, 0xba, 0x0, 0x0, 0x0, 0x0, 0x82,
    0x0, 0x0,

    /* U+F15B "" */
    0x24, 0x44, 0x44, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xf2, 0x60, 0x0, 0xff, 0xff, 0xff, 0x2f, 0x60,
    0xf, 0xff, 0xff, 0xf2, 0xff, 0x60, 0xff, 0xff,
    0xff, 0x22, 0x22, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4f, 0xff,
    0xff, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x4f, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0x9b, 0xbb, 0xbb, 0xbb, 0xbb, 0x10,

    /* U+F1EB "" */
    0x0, 0x0, 0x14, 0x65, 0x40, 0x0, 0x0, 0x0,
    0x5c, 0xff, 0xff, 0xff, 0xa2, 0x0, 0x1b, 0xff,
    0xa6, 0x45, 0x7c, 0xff, 0x80, 0x8f, 0xa2, 0x6b,
    0xdc, 0xa4, 0x4d, 0xf3, 0x4, 0x4e, 0xff, 0xee,
    0xff, 0xc2, 0x40, 0x0, 0x9f, 0x72, 0x32, 0x2b,
    0xf5, 0x0, 0x0, 0x1, 0x9f, 0xff, 0xe5, 0x20,
    0x0, 0x0, 0x0, 0x9d, 0x78, 0xe5, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xa8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x95, 0x0, 0x0, 0x0,

    /* U+F240 "" */
    0x59, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x10,
    0xe4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x47, 0x80,
    0xd3, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xb4, 0xb0,
    0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0xa6,
    0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x66,
    0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x66,
    0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0xe2,
    0xd1, 0x44, 0x44, 0x44, 0x44, 0x44, 0x34, 0x90,
    0xbd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xde, 0x50,

    /* U+F241 "" */
    0x59, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x10,
    0xe4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x47, 0x80,
    0xd3, 0xdd, 0xdd, 0xdd, 0xdd, 0x30, 0x4, 0xb0,
    0xd4, 0xff, 0xff, 0xff, 0xff, 0x40, 0x1, 0xa6,
    0xd4, 0xff, 0xff, 0xff, 0xff, 0x40, 0x0, 0x66,
    0xd4, 0xff, 0xff, 0xff, 0xff, 0x40, 0x0, 0x66,
    0xd4, 0xff, 0xff, 0xff, 0xff, 0x40, 0x4, 0xe2,
    0xd1, 0x44, 0x44, 0x44, 0x44, 0x10, 0x4, 0x90,
    0xbd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xde, 0x50,

    /* U+F242 "" */
    0x59, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x10,
    0xe4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x47, 0x80,
    0xd3, 0xdd, 0xdd, 0xd9, 0x0, 0x0, 0x4, 0xb0,
    0xd4, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x1, 0xa6,
    0xd4, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x66,
    0xd4, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x66,
    0xd4, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x4, 0xe2,
    0xd1, 0x44, 0x44, 0x43, 0x0, 0x0, 0x4, 0x90,
    0xbd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xde, 0x50,

    /* U+F243 "" */
    0x59, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x10,
    0xe4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x47, 0x80,
    0xd3, 0xdd, 0xd1, 0x0, 0x0, 0x0, 0x4, 0xb0,
    0xd4, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x1, 0xa6,
    0xd4, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x66,
    0xd4, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x66,
    0xd4, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x4, 0xe2,
    0xd1, 0x44, 0x40, 0x0, 0x0, 0x0, 0x4, 0x90,
    0xbd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xde, 0x50,

    /* U+F244 "" */
    0x59, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x10,
    0xe4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x47, 0x80,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xb0,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xa6,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x66,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x66,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xe2,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x90,
    0xbd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xde, 0x50,

    /* U+F293 "" */
    0x0, 0x0, 0x33, 0x10, 0x0, 0x0, 0x8f, 0xef,
    0xfb, 0x10, 0x6, 0xff, 0xb5, 0xff, 0xb0, 0xc,
    0xff, 0xb0, 0x5f, 0xf1, 0x1f, 0xa6, 0xb5, 0x56,
    0xf5, 0x2f, 0xf5, 0x32, 0x2d, 0xf7, 0x4f, 0xff,
    0x40, 0xdf, 0xf8, 0x3f, 0xfb, 0x10, 0x6f, 0xf7,
    0x2f, 0xc2, 0x95, 0x57, 0xf6, 0xe, 0xed, 0xb3,
    0x2c, 0xf3, 0x9, 0xff, 0xb1, 0xcf, 0xe0, 0x1,
    0xef, 0xcc, 0xff, 0x40, 0x0, 0x7, 0xaa, 0x82,
    0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_h = 0, .box_w = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 48, .box_h = 0, .box_w = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 49, .box_h = 10, .box_w = 3, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 15, .adv_w = 61, .box_h = 3, .box_w = 4, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 21, .adv_w = 120, .box_h = 9, .box_w = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 53, .adv_w = 108, .box_h = 12, .box_w = 7, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 95, .adv_w = 141, .box_h = 10, .box_w = 9, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 140, .adv_w = 119, .box_h = 10, .box_w = 8, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 180, .adv_w = 33, .box_h = 3, .box_w = 2, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 183, .adv_w = 66, .box_h = 13, .box_w = 4, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 209, .adv_w = 67, .box_h = 13, .box_w = 4, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 235, .adv_w = 83, .box_h = 6, .box_w = 5, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 250, .adv_w = 109, .box_h = 8, .box_w = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 278, .adv_w = 38, .box_h = 4, .box_w = 2, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 282, .adv_w = 53, .box_h = 2, .box_w = 4, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 286, .adv_w = 51, .box_h = 3, .box_w = 3, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 291, .adv_w = 79, .box_h = 10, .box_w = 5, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 316, .adv_w = 108, .box_h = 10, .box_w = 7, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 351, .adv_w = 108, .box_h = 9, .box_w = 4, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 369, .adv_w = 108, .box_h = 9, .box_w = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 401, .adv_w = 108, .box_h = 10, .box_w = 6, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 431, .adv_w = 108, .box_h = 9, .box_w = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 463, .adv_w = 108, .box_h = 10, .box_w = 7, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 498, .adv_w = 108, .box_h = 10, .box_w = 7, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 533, .adv_w = 108, .box_h = 9, .box_w = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 565, .adv_w = 108, .box_h = 10, .box_w = 7, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 600, .adv_w = 108, .box_h = 9, .box_w = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 627, .adv_w = 47, .box_h = 8, .box_w = 3, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 639, .adv_w = 41, .box_h = 9, .box_w = 3, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 653, .adv_w = 98, .box_h = 6, .box_w = 6, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 671, .adv_w = 105, .box_h = 4, .box_w = 6, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 683, .adv_w = 100, .box_h = 6, .box_w = 6, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 701, .adv_w = 91, .box_h = 10, .box_w = 6, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 731, .adv_w = 172, .box_h = 12, .box_w = 11, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 797, .adv_w = 125, .box_h = 9, .box_w = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 833, .adv_w = 120, .box_h = 9, .box_w = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 865, .adv_w = 125, .box_h = 10, .box_w = 8, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 905, .adv_w = 126, .box_h = 9, .box_w = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 941, .adv_w = 109, .box_h = 9, .box_w = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 973, .adv_w = 106, .box_h = 9, .box_w = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1005, .adv_w = 131, .box_h = 10, .box_w = 8, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1045, .adv_w = 137, .box_h = 9, .box_w = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1081, .adv_w = 52, .box_h = 9, .box_w = 2, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1090, .adv_w = 106, .box_h = 10, .box_w = 6, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1120, .adv_w = 120, .box_h = 9, .box_w = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1156, .adv_w = 103, .box_h = 9, .box_w = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1188, .adv_w = 168, .box_h = 9, .box_w = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1233, .adv_w = 137, .box_h = 9, .box_w = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1269, .adv_w = 132, .box_h = 10, .box_w = 8, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1309, .adv_w = 121, .box_h = 9, .box_w = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1345, .adv_w = 132, .box_h = 11, .box_w = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1389, .adv_w = 118, .box_h = 9, .box_w = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1425, .adv_w = 114, .box_h = 10, .box_w = 7, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1460, .adv_w = 115, .box_h = 9, .box_w = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1492, .adv_w = 125, .box_h = 10, .box_w = 7, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1527, .adv_w = 122, .box_h = 9, .box_w = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1563, .adv_w = 170, .box_h = 9, .box_w = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1613, .adv_w = 120, .box_h = 9, .box_w = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1649, .adv_w = 115, .box_h = 9, .box_w = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1685, .adv_w = 115, .box_h = 9, .box_w = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1717, .adv_w = 51, .box_h = 12, .box_w = 4, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1741, .adv_w = 79, .box_h = 10, .box_w = 5, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1766, .adv_w = 51, .box_h = 12, .box_w = 3, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1784, .adv_w = 80, .box_h = 5, .box_w = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 1797, .adv_w = 87, .box_h = 1, .box_w = 6, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1800, .adv_w = 59, .box_h = 2, .box_w = 3, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 1803, .adv_w = 104, .box_h = 8, .box_w = 6, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1827, .adv_w = 108, .box_h = 10, .box_w = 7, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1862, .adv_w = 101, .box_h = 8, .box_w = 6, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1886, .adv_w = 108, .box_h = 10, .box_w = 6, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1916, .adv_w = 102, .box_h = 8, .box_w = 6, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1940, .adv_w = 67, .box_h = 10, .box_w = 5, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1965, .adv_w = 108, .box_h = 10, .box_w = 6, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1995, .adv_w = 106, .box_h = 9, .box_w = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2022, .adv_w = 47, .box_h = 9, .box_w = 3, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2036, .adv_w = 46, .box_h = 12, .box_w = 3, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 2054, .adv_w = 97, .box_h = 9, .box_w = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2086, .adv_w = 47, .box_h = 9, .box_w = 2, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2095, .adv_w = 168, .box_h = 7, .box_w = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2130, .adv_w = 106, .box_h = 7, .box_w = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2151, .adv_w = 110, .box_h = 8, .box_w = 7, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 2179, .adv_w = 108, .box_h = 10, .box_w = 7, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2214, .adv_w = 109, .box_h = 10, .box_w = 6, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2244, .adv_w = 65, .box_h = 7, .box_w = 4, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2258, .adv_w = 99, .box_h = 8, .box_w = 6, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 2282, .adv_w = 63, .box_h = 9, .box_w = 4, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 2300, .adv_w = 106, .box_h = 8, .box_w = 6, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 2324, .adv_w = 93, .box_h = 7, .box_w = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2345, .adv_w = 144, .box_h = 7, .box_w = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2377, .adv_w = 95, .box_h = 7, .box_w = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2398, .adv_w = 91, .box_h = 10, .box_w = 6, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2428, .adv_w = 95, .box_h = 7, .box_w = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2449, .adv_w = 65, .box_h = 13, .box_w = 4, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2475, .adv_w = 47, .box_h = 11, .box_w = 1, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 2481, .adv_w = 65, .box_h = 13, .box_w = 4, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2507, .adv_w = 131, .box_h = 3, .box_w = 8, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 2519, .adv_w = 165, .box_h = 12, .box_w = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2585, .adv_w = 206, .box_h = 12, .box_w = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2663, .adv_w = 192, .box_h = 10, .box_w = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2723, .adv_w = 192, .box_h = 9, .box_w = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2777, .adv_w = 151, .box_h = 9, .box_w = 9, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 2818, .adv_w = 165, .box_h = 12, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 2884, .adv_w = 165, .box_h = 11, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 2945, .adv_w = 151, .box_h = 11, .box_w = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3000, .adv_w = 178, .box_h = 9, .box_w = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3050, .adv_w = 178, .box_h = 11, .box_w = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3116, .adv_w = 165, .box_h = 9, .box_w = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3166, .adv_w = 165, .box_h = 11, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3227, .adv_w = 82, .box_h = 9, .box_w = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3254, .adv_w = 123, .box_h = 9, .box_w = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3290, .adv_w = 178, .box_h = 11, .box_w = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3356, .adv_w = 206, .box_h = 11, .box_w = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3428, .adv_w = 165, .box_h = 11, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3489, .adv_w = 110, .box_h = 11, .box_w = 7, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3528, .adv_w = 151, .box_h = 11, .box_w = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3583, .adv_w = 165, .box_h = 11, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3644, .adv_w = 165, .box_h = 11, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3705, .adv_w = 110, .box_h = 11, .box_w = 7, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3744, .adv_w = 165, .box_h = 9, .box_w = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3794, .adv_w = 137, .box_h = 12, .box_w = 7, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 3836, .adv_w = 137, .box_h = 12, .box_w = 8, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3884, .adv_w = 151, .box_h = 10, .box_w = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3934, .adv_w = 151, .box_h = 3, .box_w = 10, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 3949, .adv_w = 192, .box_h = 12, .box_w = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4021, .adv_w = 192, .box_h = 12, .box_w = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4093, .adv_w = 192, .box_h = 8, .box_w = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4141, .adv_w = 192, .box_h = 8, .box_w = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4189, .adv_w = 206, .box_h = 8, .box_w = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4241, .adv_w = 178, .box_h = 10, .box_w = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4301, .adv_w = 178, .box_h = 11, .box_w = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4367, .adv_w = 151, .box_h = 10, .box_w = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4417, .adv_w = 192, .box_h = 10, .box_w = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4477, .adv_w = 192, .box_h = 13, .box_w = 12, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4555, .adv_w = 165, .box_h = 11, .box_w = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4616, .adv_w = 96, .box_h = 12, .box_w = 6, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4652, .adv_w = 192, .box_h = 13, .box_w = 12, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4730, .adv_w = 206, .box_h = 8, .box_w = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4782, .adv_w = 151, .box_h = 10, .box_w = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4832, .adv_w = 165, .box_h = 13, .box_w = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4904, .adv_w = 219, .box_h = 10, .box_w = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4974, .adv_w = 247, .box_h = 9, .box_w = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5046, .adv_w = 247, .box_h = 9, .box_w = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5118, .adv_w = 247, .box_h = 9, .box_w = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5190, .adv_w = 247, .box_h = 9, .box_w = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5262, .adv_w = 247, .box_h = 9, .box_w = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5334, .adv_w = 165, .box_h = 13, .box_w = 10, .ofs_x = 0, .ofs_y = -2}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static uint16_t unicode_list_1[] = {
    0x0, 0x7, 0xa, 0xb, 0xc, 0x10, 0x12, 0x13,
    0x14, 0x18, 0x1b, 0x20, 0x25, 0x26, 0x27, 0x3d,
    0x3f, 0x47, 0x4a, 0x4b, 0x4c, 0x50, 0x51, 0x52,
    0x53, 0x66, 0x67, 0x70, 0x73, 0x76, 0x77, 0x78,
    0x7a, 0x92, 0x94, 0xc3, 0xc4, 0xc6, 0xe6, 0xf2,
    0x11b, 0x123, 0x15a, 0x1ea, 0x23f, 0x240, 0x241, 0x242,
    0x243, 0x292
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY,
        .glyph_id_start = 1, .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0
    },
    {
        .range_start = 61441, .range_length = 659, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY,
        .glyph_id_start = 96, .unicode_list = unicode_list_1, .glyph_id_ofs_list = NULL, .list_length = 50
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static uint8_t kern_left_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 0,
    2, 3, 0, 0, 0, 4, 0, 4,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6, 7, 8, 9, 10, 11,
    0, 12, 12, 13, 14, 15, 12, 12,
    9, 16, 17, 18, 0, 19, 13, 20,
    21, 22, 23, 24, 25, 0, 0, 0,
    0, 0, 26, 27, 28, 0, 29, 30,
    0, 31, 0, 0, 32, 0, 31, 31,
    33, 27, 0, 34, 0, 35, 0, 36,
    37, 38, 36, 39, 40, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0
};

/*Map glyph_ids to kern right classes*/
static uint8_t kern_right_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 3,
    2, 0, 4, 5, 0, 6, 7, 6,
    8, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    9, 0, 10, 0, 11, 0, 0, 0,
    11, 0, 0, 12, 0, 0, 0, 0,
    11, 0, 11, 0, 13, 14, 15, 16,
    17, 18, 19, 20, 0, 0, 21, 0,
    0, 0, 22, 0, 23, 23, 23, 24,
    23, 0, 0, 0, 0, 0, 25, 25,
    26, 25, 23, 27, 28, 29, 30, 31,
    32, 33, 31, 34, 0, 0, 35, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0
};

/*Kern values between classes*/
static uint8_t kern_class_values[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -10, 0, 0, 0,
    0, 0, 0, 0, -11, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, -6, 0, -2, -6, 0, -7, 0,
    0, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2, 2, 0,
    2, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -16, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -21, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -11, 0, 0, 0, 0, 0, 0, -6,
    0, -1, 0, 0, -12, -2, -8, -6,
    0, -9, 0, 0, 0, 0, 0, 0,
    -1, 0, 0, -2, -1, -5, -3, 0,
    1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -3,
    0, -2, 0, 0, -5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -2, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -3, 0, 0, 0, 0, 0,
    0, -1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -2,
    0, 0, 0, 0, 0, -10, 0, 0,
    0, -2, 0, 0, 0, -3, 0, -2,
    0, -2, -4, -2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 0, 0, 0, 0, 0, 0, 0,
    0, -2, -2, 0, -2, 0, 0, 0,
    -2, -2, -2, 0, 0, 0, 0, 0,
    0, 0, 0, -22, 0, 0, 0, -16,
    0, -25, 0, 2, 0, 0, 0, 0,
    0, 0, 0, -3, -2, 0, 0, -2,
    -2, 0, 0, -2, -2, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 0, 0, 0, -3, 0,
    0, 0, 2, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -2, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -6, 0, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -2, 0, -2,
    -3, 0, 0, 0, -2, -4, -6, 0,
    0, 0, 0, -31, 0, 0, 0, 0,
    0, 0, 0, 2, -6, 0, 0, -26,
    -5, -16, -13, 0, -22, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -4,
    -12, -9, 0, 0, 0, 0, 0, 0,
    0, 0, -30, 0, 0, 0, -13, 0,
    -19, 0, 0, 0, 0, 0, -3, 0,
    -2, 0, -1, -1, 0, 0, -1, 0,
    0, 1, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, 0, -3,
    -2, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -7, 0, -2, 0, 0, -4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -4, 0,
    0, 0, 0, -20, -22, 0, 0, -7,
    -3, -22, -1, 2, 0, 2, 1, 0,
    2, 0, 0, -11, -9, 0, -10, -9,
    -7, -11, 0, -9, -7, -5, -7, -6,
    0, 0, 0, 0, 2, 0, -21, -3,
    0, 0, -7, -1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2, -4, -4,
    0, 0, -4, -3, 0, 0, -3, -1,
    0, 0, 0, 2, 0, 0, 0, 1,
    0, -12, -6, 0, 0, -4, 0, 0,
    0, 1, 0, 0, 0, 0, 0, 0,
    1, -3, -3, 0, 0, -3, -2, 0,
    0, -2, 0, 0, 0, 0, 1, 0,
    0, 0, 0, 0, 0, -4, 0, 0,
    0, -2, 0, 0, 0, 0, 1, 0,
    0, 0, 0, 0, 0, -2, 0, 0,
    -2, 0, 0, 0, -2, -3, 0, 0,
    0, 0, 0, 0, -3, 2, -5, -20,
    -5, 0, 0, -9, -3, -9, -1, 2,
    -9, 2, 2, 1, 2, 0, 2, -7,
    -6, -2, -4, -6, -4, -5, -2, -4,
    -2, 0, -2, -3, 2, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, -2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -2, 0, 0, -2, 0,
    0, 0, -2, -3, -3, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -2, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -6, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -1, 0, 0, 0, 0, 0, -3,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -1, 0, -1, -1,
    0, 0, -1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -1, 0, 0, 0, 0, 0,
    2, 0, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2, 0, -2, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 0, -10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -13, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -1, 0,
    -2, -1, 0, 0, 2, 0, 0, 0,
    -12, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -4, -2, 1, 0, -2, 0, 0, 5,
    0, 2, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 0, 0, 0, -10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -1, -1,
    1, 0, -1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -12, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -2, 0, 0,
    -2, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, 0, -1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -2, 0, 0, -2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0
};


/*Collect the kern class' data in one place*/
static lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 40,
    .right_class_cnt     = 35,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .cmap_num = 2,
    .bpp = 4,

    .kern_scale = 16,
    .kern_dsc = &kern_classes,
    .kern_classes = 1
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t lv_font_roboto_12 = {
    .dsc = &font_dsc,          /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .line_height = 14,          /*The maximum line height required by the font*/
    .base_line = 3,             /*Baseline measured from the bottom of the line*/
};

#endif /*#if LV_FONT_ROBOTO_12*/

