// Generated by CoffeeScript 1.3.3
(function() {
  var amqp, amqp_connection, argv, assert, check_results, count, host, login, message_s, options, password, port, publish_message, test_exchange, test_exchange_name, test_message, test_queue_name, usage_text, vhost;

  usage_text = '\
Test federated multi-hop message receipt.\
\n\
\n* Probably you want to do this on a fresh rabbitmq install...\
\n\
\nTo enable this test:\
\n1. Create a virtual host named "reflector" and provide access\
\n2. Bring down the rabbit\
\n3. Enable the federation plugin\
\n4. Include this federation configuration as or in your rabbitmq.config file and bring up the rabbit:\
\n[\
\n  {rabbitmq_federation, [ \
\n    {exchanges, [\
\n      [\
\n        {exchange, "test.federation"},\
\n        {virtual_host, "reflector"},\
\n        {type, "topic"},\
\n        {upstream_set, "root.set"}\
\n      ],\
\n      [\
\n        {exchange, "test.federation"},\
\n        {virtual_host, "/"},\
\n        {type, "topic"},\
\n        {upstream_set, "reflector.set"}\
\n      ]\
\n    ]},\
\n    {upstream_sets, [\
\n      {"reflector.set", [\
\n        [\
\n          {connection, "reflector.connection"},\
\n          {max_hops, 2}\
\n        ]\
\n      ]},\
\n      {"root.set", [\
\n        [\
\n          {connection, "root.connection"},\
\n          {max_hops, 2}\
\n        ]\
\n      ]}\
\n    ]},\
\n    {connections, [\
\n      {"reflector.connection", [ \
\n        {host, "localhost"},\
\n        {virtual_host, "reflector"},\
\n        {username, "guest"},\
\n        {password, "guest"}\
\n      ]}, \
\n      {"root.connection", [ \
\n        {host, "localhost"},\
\n        {virtual_host, "/"},\
\n        {username, "guest"},\
\n        {password, "guest"}\
\n      ]}\
\n    ]},\
\n    {local_username, "guest"},\
\n    {local_password, "guest"}\
\n  ]}\
\n].\
';

  argv = require('optimist').usage(usage_text).demand('host').describe('host', 'Host')["default"]('host', 'localhost').demand('port').describe('port', 'Port')["default"]('port', 5672).demand('vhost').describe('vhost', 'Virtual Host')["default"]('vhost', '/').demand('login').describe('login', 'Login')["default"]('login', 'guest').demand('password').describe('password', 'Password').argv;

  amqp = require('../amqp');

  assert = require('assert');

  message_s = "";

  publish_message = function() {
    var message;
    message = {
      hello: 'world'
    };
    message_s = JSON.stringify(message);
    test_exchange.publish('whatever', message);
    return console.log("test message published: " + (JSON.stringify(message)) + " to exchange: " + test_exchange_name);
  };

  count = 0;

  test_message = function(message, headers, properties) {
    console.log("" + ("test message received:  message: " + (JSON.stringify(message))) + ("\n  headers: " + (JSON.stringify(headers, void 0, 4))));
    assert.equal(message_s, JSON.stringify(message, "incorrect message content or content_type"));
    if (count === 1) {
      assert.equal('reflector', headers["x-received-from"][0]["virtual_host"], "missing or mismatched virtual host name");
    }
    return count++;
  };

  check_results = function() {
    console.log("" + count + " messages received");
    assert.equal(2, count, "wrong number of messages received");
    return process.exit(0);
  };

  test_exchange = {};

  test_queue_name = test_exchange_name = 'test.federation';

  host = argv.host, port = argv.port, vhost = argv.vhost, login = argv.login, password = argv.password;

  options = {
    host: host,
    port: port,
    vhost: vhost,
    login: login,
    password: password
  };

  amqp_connection = amqp.createConnection(options);

  amqp_connection.on('ready', function() {
    return amqp_connection.exchange(test_exchange_name, {
      passive: true
    }, function(exchange) {
      test_exchange = exchange;
      return amqp_connection.queue(test_queue_name, function(queue) {
        return queue.bind(test_exchange, '#', function() {
          queue.subscribe(function(message, headers, properties) {
            return test_message(message, headers, properties);
          });
          setTimeout(check_results, 1000);
          return publish_message();
        });
      });
    });
  });

}).call(this);
