# Fedora
## 設定裝置

1. 設定一個隨便創立的使用者，例如 q w 或 a

2. 密碼和名稱設立一樣的

3. 進入桌面後，打開終端機 (Terminal)，並輸入 `sudo passwd root`這個讓我們進密碼更改系統，輸入密碼後，密碼設定為 `Skills@2024`

4. 登出我們之前創立的使用者，按沒有列出來，帳號輸入 root，密碼輸入前面所設定的密碼`Skills@2024`，並登入

5. 打開設定，按網路，並設定固定IP 
    - 設置 **固定 IP 地址**:
    - 打開 **網絡設置**。
    - 選擇 **手動配置**。
    - IP: `192.168.1.110` // 試場指定主機固定 IP
    - 子網掩碼: `255.255.255.0` 
    - 閘道: `192.168.1.254` // Windows 主機
    - DNS: `192.168.1.254` // Windows 主機

6. 打開終端機，並輸入 `userdel`前面創立的使用者 例: `userdel q`

7. 使用 `rpm -ivh * --force`

# 指令
## 更改主機名稱
這個可以透過設定的 UI 更改
```bash
hostnamectl set-hostname Business-01
```
## 刪除使用者
```bash
userdel -r user
```

## 增加群組
```bash
groupadd AIOTGroup
```
## 增加使用者
```bash
useradd user
```
## 使用者資訊
```bash
id {{ user }}
```
## 檢查 SELinux 是否開啟
```bash
sestatus
```
## 開啟 SELinux
1. 先到使用 `nano` 或 `gedit` 打開 `/etc/selinux/config`
2. 在這裡把 `disabled` 改成 `enforcing`
```
codeSELINUX=disabled
```
# 改 ssh 的連接埠

## 進入 ssh 的資料夾

```bash
cd /etc/ssh/
```
##  編輯 sshd_config

這個可以用 nano 或 gedit

```bash
nano sshd_config
```

或 

```bash
gedit sshd_config
```
nano 用 ctrl+x, y Enter 退出並儲存
## 在 sshd_config 中加入

```
Port 2424 
PermitRootLogin no
AllowUsers AIOT? AIOT10
```

Port 為它的連接埠，要用試場要求的連接埠 (2424)

PermitRoot Login 為 root 帳號登入，要用試場要求的設定 (基本上一定是不允許的，因為 root 是最高等級的使用者，和 Windows 的可以登入的 Administrator 差不多)

AllowUsers 是可以在範圍內的使用者，可以登入，?是 Wildcard，最後的帳號就是最後可以登的使用者
(113 年是 AIOT1~10 所以就是 AIOT? AIOT10)

## 使用 SELINUX 允許 SSHd 使用 2424 的 port
```bash
semanage --port -a -t ssh_port_t -p tcp 2424
```

## 重新啟動 sshd

 ```bash
 systemctl restart sshd.service
 ```


## 打開 ssh 的連接埠

(這個步驟可以越過，因為ssh有時候預設用 Firewalld 打開連接埠，但這個只確認的而已)
```bash 
firewall-cmd --add-service-ssh --permanent
```

## 打開連接埠
**在 113 年的工科賽，有要把 ssh 公開到網路上 (要在 Windows Server 裡打開連接埠)**


# 大量創立使用者

## 程式

```bash
userStartsWith=""  # 帳號開頭
startNum=1 # 數字開頭 
incrementBy=1 # 一次要加多少
endNum=50 # 最終數字要是多少
group="" # 要加入的群組
password="" # 密碼
for number in $(seq -w startNum incrementBy endNum) # 重複跑，注意只要是單位數字的一定會是 0X!
do # 開頭
	useradd -g $group -s /bin/bash $userStartsWith$number
	echo $password | passwd --stdin $userStartsWith$number
done # 結尾
```
## 解釋 
這段 Bash 腳本的功能是在 Fedora 系統上大量創建使用者帳號，並且為每個帳號設定密碼。以下是腳本的逐步解釋：

```bash
userStartsWith=""
```
定義一個變數 u，儲存使用者名稱的前綴部分 (目前為空)。
```bash
for i in $(seq -w 1 2 50)#：使用 seq 產生一個從 1 到 50 的數列，並以兩位數格式表示 (01, 02, ..., 50)，並每個數字都有 +2 的差別。
```
這裡的 ```-f "%02g"``` 會強制將數字格式化為兩位數。
```bash
useradd -g {{ group }} -s /bin/bash $userStartsWith$i
# useradd 是用於新增使用者的指令。
```

```-g {{ group }}```：將使用者加入指定的群組 ({{ group }} 是變數，應替換成實際的群組名稱)。

```-s /bin/bash```：設定使用者的預設 shell 為 Bash。

$u$i：建立的使用者名稱由變數 u (前綴) 加上數字序號組成，例如 user01、user02。
```bash
echo "{{ password }}" | passwd --stdin $u$i
```
這行用來設定使用者密碼。 

```echo "{{ password }}"```：將密碼以純文字格式輸出 (變數應替換為實際密碼)。

```passwd --stdin $u$i：passwd``` 是用來變更密碼的指令，--stdin 表示透過標準輸入接收密碼，而不是互動式輸入。
## 範例
以 113 年的為例
```bash
userStartsWith="AIOT"  # 帳號開頭
startNum=1 # 數字開頭 
incrementBy=1 # 一次要加多少
endNum=50 # 最終數字要是多少
group="AIOTGroup" # 要加入的群組
password="AIOT2024@" # 密碼
for number in $(seq -f "%02g" startNum incrementBy endNum) # 重複跑，注意只要是單位數字的一定會是 0X!
do # 開頭
	useradd -g $group -s /bin/bash $userStartsWith$number
	echo $password | passwd --stdin $userStartsWith$number
done # 結尾
```

# 設定網頁 + https + 使用者管理
## 憑證  (Linux 端)
### 進入憑證的資料夾
```bash
cd /etc/pki/tls/certs
```
### 創立憑證金鑰
```bash
openssl genrsa -out linux.key # 最好是使用 [name].tcivs.com.tw 為名稱
```

### 創立憑證要求，並匯出
```bash
openssl req -new -key linux.key -out linux.csr  # 最好是使用 [name].tcivs.com.tw 為名稱
```

#### 我們可以使用 `cat` 或 `gedit` 複製檔案
##### 使用 `cat`
```bash
cat linux.csr
```

##### 使用 gedit
```bash
gedit linux.csr
```

### 到 AD CA 平台創立憑證
1. 先到 `https://www.tcivs.com.tw/certsrv/`，如果試場沒有指定要不要在 Linux Fedora 裡信任AD CA 的憑證，可以跳過憑證警告頁面
(psst, 到 `https://192.168.1.254` 也 ok!)
2. 按要求憑證，並按進階憑證要求
3. 按用 Base-64 編碼的 CMC ... 要求，並在 `Base-64-encoded certificated request` 輸入欄位中複製你剛剛複製的 Base-64
4. 憑證範本為網頁伺服器（Web），並按提交

### 移動我們剛剛下載的憑證到憑證的資料夾
這個我們可以直接使用 `nautilus /etc/pki/tls/certs` 並把下載的東西複製到那邊

### 輸出憑證 (pem) 檔案

```bash
openssl x509 -inform der -in linux.cer -outform pem -out linux.pem
```
## 網頁 (apache2)

### 進入 httpd 的 config 資料夾

```bash
cd /etc/httpd/conf.d/
```

### 創立一個新的檔案 

```sh
touch linux.conf 
```

### 編輯檔案，可以用 nano 或 gedit

```sh
nano linux.conf
```

或

```bash
gedit linux.conf
```

### 檔案 (linux)

```xml
<VirtualHost *:443>
	ServerName linux.tcivs.com.tw
	DocumentRoot /var/www/linux
	SSLEngine on
	SSLCertificateFile /etc/pki/tls/certs/linux.pem
	SSLCertificateKeyFile /etc/pki/tls/certs/linux.key
  <Directory /var/www/linux>
	  AuthName "Private"
	  AuthType Basic
	  AuthBasicProvider file
	  AuthUserFile "/usr/local/etc/passwd"
	  Require user root
  </Directory>
</VirtualHost>
```
#### 解釋
```xml
<VirtualHost *:443>
```
是代表這個虛擬網頁主機要在 * (所有 IP 位置) 的 443 (HTTPS) port 號來做推播

```
ServerName linux.tcivs.com.tw
```
網域為 linux.tcivs.com.tw ，必須是該網域才可以使用該服務

```
DocumentRoot /var/www/linux
```

檔案來源來自 `/var/www/linux`
```
SSLEngine on
```
打開 SSL

```
SSLCertificateFile /etc/pki/tls/certs/linux.pem
SSLCertificateKeyFile /etc/pki/tls/certs/linux.key
```
指向我們剛剛創的 SSL 憑證

```
  <Directory /var/www/linux>
	  AuthName "Private"
	  AuthType Basic
	  AuthBasicProvider file
	  AuthUserFile "/usr/local/etc/passwd"
	  Require user root
  </Directory>
```
設定這個位置需要 "root" 的帳號和密碼

```
</VirtualHost>
```
結束
### 檔案 (old)
```xml
<VirtualHost *:443>
	ServerName old.tcivs.com.tw
	DocumentRoot /var/www/old
	SSLEngine on
	SSLCertificateFile /etc/pki/tls/certs/old.pem
	SSLCertificateKeyFile /etc/pki/tls/certs/old.key
</VirtualHost>
```
#### 解釋
```xml
<VirtualHost *:443>
```
是代表這個虛擬網頁主機要在 * (所有 IP 位置) 的 443 (HTTPS) port 號來做推播

```
ServerName old.tcivs.com.tw
```
網域為 linux.tcivs.com.tw ，必須是該網域才可以使用該服務

```
DocumentRoot /var/www/linux
```

檔案來源來自 `/var/www/linux`
```
SSLEngine on
```
打開 SSL

```
SSLCertificateFile /etc/pki/tls/certs/old.pem
SSLCertificateKeyFile /etc/pki/tls/certs/old.key
```
指向我們剛剛創的 SSL 憑證

```
</VirtualHost>
```
結束

###  設定使用者帳號密碼
我們會使用  apache2-utils 的 htpasswd 來設定密碼
```bash
htpasswd -b -c /usr/local/etc/passwd root Skills@2024
```
我們用 `htpasswd` 來 寫入檔案 `/usr/local/etc/passwd`，並設定帳號為 `root` 密碼也設定為 `Skills@2024`
###  重啟服務
```bash
systemctl restart httpd.service
```
如果還沒有啟用服務，或出現錯誤，可以跑

```
systemctl enable httpd.service
systemctl start httpd.service
```
## NTP (網路時間)
### 關閉預設 NTP 系統
先進入設定，並把自動設定時間的關掉
並在終端機跑以下指令
```bash
systemctl stop ntpd.service
systemctl disable ntpd.service
systemctl mask ntpd.service
```

### 編輯檔案 `/etc/chrony.conf`
##### 刪除

```
pool 2.fedora.pool.ntp.org iburst
```

##### 增加

```
allow 192.168.1.0/24
rtcsync
manual
local stratum 10
```
### 防火牆讓NTP的服務可以被其他裝置連線
 
```bash
firewall-cmd --add-service=ntp
firewall-cmd --runtime-to-permanent
```

### 啟動 Chrony

```
systemctl enable chronyd.service
systemctl start chronyd.service
```
### 把自動更改使時間關掉

```
chronyc manual on
```
### 設定時間

```
chronyc settime 2026-08-20 05:00:05
```

設定的時間 2026 年 8 月 20 日 5 點 0 分 5 秒

### 確認

1. 在 Windows 裡執行 `NTPClock.exe`
2. 按右鍵，並按設定系統時區
3. 把預設網域/預設IP刪除，並增加IP，使用Fedora Linux 的 IP
4. 按下矯正時間，並會看到和Fedora一樣的時間

## SMB 大量創立使用者
```bash
user=""
pwd=""
for item in $(seq -f "%02g" 1 1 50)
do
	echo -ne "$pwd\n$pwd\n" | smbpasswd -a -s $u$i
done
```
### 解釋
1. 變數定義
```bash
user=""
pwd=""
```

`user=""`：定義變數 user，用於儲存使用者名稱的前綴部分 (目前為空)。

`pwd=""`：定義變數 pwd，用於儲存設定的密碼 (目前為空，需要替換為實際的密碼)。
2. 迴圈產生使用者名稱
```bash
for item in $(seq -f "%02g" 1 1 50)
```
`for item in $(seq -f "%02g" 1 1 50)`：使用 `seq` 產生一個從 1 到 50 的數列，並將其格式化為兩位數 (01, 02, ..., 50)。

item 代表當前迴圈的數字，用於生成使用者名稱的後綴。
3. 創建 SMB 使用者
```bash
echo -ne "$pwd\n$pwd\n" | smbpasswd -a -s $u$i
echo -ne "$pwd\n$pwd\n"：
```

使用 echo 將密碼輸出兩次，分別對應 smbpasswd 指令需要的密碼輸入和確認輸入。

-n：禁止自動換行。

-e：啟用特殊字符（如 \n 表示換行）。

| smbpasswd -a -s $u$i：

smbpasswd：用於設定或修改 Samba 使用者的密碼。

-a：新增使用者到 Samba 的使用者資料庫。

-s：以非互動模式接收密碼輸入。

$u$i：將變數 user 的前綴與當前序號 (如 01, 02) 組合，生成 SMB 使用者名稱。

### 範例

假設我們需要創建名稱為 `smbuser01` 到 `smbuser50` 的 SMB 使用者，並設置密碼為 `Password123`：

```bash
user="smbuser"
pwd="Password123"

for item in $(seq -f "%02g" 1 50)
do
    echo -ne "$pwd\n$pwd\n" | smbpasswd -a -s $user$item
done
```
### 運作過程
生成使用者名稱：`smbuser01`, `smbuser02`, ..., `smbuser50`。

為每個使用者執行 `smbpasswd` 命令，並設定密碼為 `Password123`。

密碼會透過管道 `|` 傳入 `smbpasswd`，實現非互動式的密碼設定。

